/* assembly2002demo09.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Traffic */
#include "assembly2002demo.h"

static void params_09_copy_trafficbg(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_09_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 32)) {
    if(time%SONGPOSTOTIME(1, 4)<SONGPOSTOTIME(1, 1))
      data->source=pictures[TRAFFIC2];
    else
      data->source=pictures[TRAFFIC1];
  } else if(time<SONGPOSTOTIME(1, 52))
    data->source=pictures[TRAFFIC1];
  else if(time<SONGPOSTOTIME(1, 56))
    data->source=pictures[TRAFFIC2];
  else if(time<SONGPOSTOTIME(1, 60))
    data->source=pictures[TRAFFIC3];
  else if(time<SONGPOSTOTIME(2, 0))
    data->source=pictures[TRAFFIC4];
  else if(time<SONGPOSTOTIME(2, 32)) {
    if((time-SONGPOSTOTIME(2, 0))%SONGPOSTOTIME(1, 4)<SONGPOSTOTIME(1, 1))
      data->source=pictures[TRAFFIC6];
    else
      data->source=pictures[TRAFFIC5];
  } else if(time<SONGPOSTOTIME(2, 52))
    data->source=pictures[TRAFFIC5];
  else if(time<SONGPOSTOTIME(2, 56))
    data->source=pictures[TRAFFIC6];
  else if(time<SONGPOSTOTIME(2, 60))
    data->source=pictures[TRAFFIC7];
  else if(time<SONGPOSTOTIME(3, 0))
    data->source=pictures[TRAFFIC8];
}

static void params_09_horizontalstretch(void *d, long time) {
  horizontalstretch_data *data=(horizontalstretch_data *)d;
  time-=PART_09_START;
  if(time<0)
    time=0;

  /* Golden section horizontally: 247 153 */
  if(time<SONGPOSTOTIME(1, 32)) {
    data->position=0;
    data->length=0;
  } else if(time<SONGPOSTOTIME(2, 0)) {
    data->position=100+53*cos((double)(time-SONGPOSTOTIME(1, 32))*M_PI/3/SONGPOSTOTIME(1, 32));
    data->length=-data->position;
  } else if(time<SONGPOSTOTIME(2, 32)) {
    data->position=0;
    data->length=0;
  } else if(time<SONGPOSTOTIME(3, 0)) {
    data->position=300-53*cos((double)(time-SONGPOSTOTIME(2, 32))*M_PI/3/SONGPOSTOTIME(1, 32));
    data->length=data->dest->width-data->position;
  }
}

static void params_09_add(void *d, long time) {
  add_data *data=(add_data *)d;
  time-=PART_09_START;
  if(time<0)
    time=0;

  while(time>=SONGPOSTOTIME(1, 32))
    time-=SONGPOSTOTIME(1, 32);

  if(time>255)
    data->color=0;
  else 
    data->color=((255-time)<<24|0xffffff);
}

static void params_09_copy_traffic(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_09_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 32))
    data->alpha=0;
  else if(time<SONGPOSTOTIME(2, 0))
    data->alpha=255;
  else
    data->alpha=0;
}

static void params_09_copy_jam(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_09_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 32))
    data->alpha=0;
  else if(time<SONGPOSTOTIME(2, 0))
    data->alpha=255;
  else
    data->alpha=0;
}

static void params_09_copy_instant(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_09_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 32))
    data->alpha=0;
  else if(time<SONGPOSTOTIME(3, 0))
    data->alpha=255;
  else
    data->alpha=0;
}

static void params_09_copy_mobility(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_09_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 32))
    data->alpha=0;
  else if(time<SONGPOSTOTIME(3, 0))
    data->alpha=255;
  else
    data->alpha=0;
}

static void params_09_copy_trafficbullshit1(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_09_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 32))
    data->alpha=0;
  else if(time<SONGPOSTOTIME(2, 0))
    data->alpha=255;
  else
    data->alpha=0;
}

static void params_09_copy_trafficbullshit2(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_09_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 32))
    data->alpha=0;
  else if(time<SONGPOSTOTIME(3, 0))
    data->alpha=255;
  else
    data->alpha=0;
}

static void params_09_copy_bullshitwhite(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_09_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 32))
    data->alpha=0;
  else if(time<SONGPOSTOTIME(2, 0)) {
    if((time-SONGPOSTOTIME(1, 32))/8>127)
      data->alpha=128;
    else
      data->alpha=(time-SONGPOSTOTIME(1, 32))/8;
  } else
    data->alpha=0;
}

void part_09() {
  copy_data *copydata;
  horizontalstretch_data *hsdata;
  add_data *adddata;

  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  /* 11. Fade from white */
  effectlist=effectlistentry_new(effect_new(add_new, params_09_add),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=&screenbuffer;
  adddata->color=0xffffffff;
  adddata->x=0;
  adddata->y=0;
  adddata->width=screenbuffer.width;
  adddata->height=screenbuffer.height;

  /* 10. Copy bullshitwhite 2 */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_09_copy_bullshitwhite),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[BULLSHITWHITE];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=6;
  copydata->desty=234;
  copydata->sourcewidth=pictures[BULLSHITWHITE]->width;
  copydata->sourceheight=pictures[BULLSHITWHITE]->height;
  copydata->destwidth=pictures[BULLSHITWHITE]->width;
  copydata->destheight=pictures[BULLSHITWHITE]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 9. Copy bullshitwhite 1 */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_09_copy_bullshitwhite),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[BULLSHITWHITE];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=6;
  copydata->desty=36;
  copydata->sourcewidth=pictures[BULLSHITWHITE]->width;
  copydata->sourceheight=pictures[BULLSHITWHITE]->height;
  copydata->destwidth=pictures[BULLSHITWHITE]->width;
  copydata->destheight=pictures[BULLSHITWHITE]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 8. Copy trafficbullshit2 */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_09_copy_trafficbullshit2),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[TRAFFICBULLSHIT2];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=258;
  copydata->desty=243;
  copydata->sourcewidth=pictures[TRAFFICBULLSHIT2]->width;
  copydata->sourceheight=pictures[TRAFFICBULLSHIT2]->height;
  copydata->destwidth=pictures[TRAFFICBULLSHIT2]->width;
  copydata->destheight=pictures[TRAFFICBULLSHIT2]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 7. Copy trafficbullshit1 */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_09_copy_trafficbullshit1),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[TRAFFICBULLSHIT1];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=201;
  copydata->desty=181;
  copydata->sourcewidth=pictures[TRAFFICBULLSHIT1]->width;
  copydata->sourceheight=pictures[TRAFFICBULLSHIT1]->height;
  copydata->destwidth=pictures[TRAFFICBULLSHIT1]->width;
  copydata->destheight=pictures[TRAFFICBULLSHIT1]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 6. Copy mobility */
  effectlist=effectlistentry_new(effect_new(copy_new, params_09_copy_mobility),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[MOBILITY];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=96;
  copydata->desty=267;
  copydata->sourcewidth=pictures[MOBILITY]->width;
  copydata->sourceheight=pictures[MOBILITY]->height;
  copydata->destwidth=pictures[MOBILITY]->width;
  copydata->destheight=pictures[MOBILITY]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 5. Copy instant */
  effectlist=effectlistentry_new(effect_new(copy_new, params_09_copy_instant),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[INSTANT];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=24;
  copydata->desty=267;
  copydata->sourcewidth=pictures[INSTANT]->width;
  copydata->sourceheight=pictures[INSTANT]->height;
  copydata->destwidth=pictures[INSTANT]->width;
  copydata->destheight=pictures[INSTANT]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 4. Copy jam */
  effectlist=effectlistentry_new(effect_new(copy_new, params_09_copy_jam),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[JAM];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=286;
  copydata->desty=154;
  copydata->sourcewidth=pictures[JAM]->width;
  copydata->sourceheight=pictures[JAM]->height;
  copydata->destwidth=pictures[JAM]->width;
  copydata->destheight=pictures[JAM]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 3. Copy traffic */
  effectlist=effectlistentry_new(effect_new(copy_new, params_09_copy_traffic),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[TRAFFIC];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=200;
  copydata->desty=154;
  copydata->sourcewidth=pictures[TRAFFIC]->width;
  copydata->sourceheight=pictures[TRAFFIC]->height;
  copydata->destwidth=pictures[TRAFFIC]->width;
  copydata->destheight=pictures[TRAFFIC]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 2. Strech it */
  effectlist=effectlistentry_new(effect_new(horizontalstretch_new, params_09_horizontalstretch),
				 effectlist);
  hsdata=(horizontalstretch_data *)effectlist->effect->data;
  hsdata->dest=&screenbuffer;
  hsdata->position=0;
  hsdata->length=0;

  /* 1. Copy traffic background */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_09_copy_trafficbg),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[TRAFFIC1];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[TRAFFIC1]->width;
  copydata->sourceheight=pictures[TRAFFIC1]->height;
  copydata->destwidth=screenbuffer.width;
  copydata->destheight=screenbuffer.height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;
}
