/* assembly2002demo03.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Shipyard (da jormas present) */
#include "assembly2002demo.h"

static void params_03_horizontalblur(void *d, long time) {
  verticalblur_data *data=(verticalblur_data *)d;
  time-=PART_03_START;
  if(time<0)
    time=0;

  if(time<=SONGPOSTOTIME(2, 32))
    data->amount=1;
  else
    data->amount=rand()%((time-SONGPOSTOTIME(2, 32))/64+1)+1;
}


static void params_03_copy_shipyard(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_03_START;
  if(time<0)
    time=0;

  if(time>SONGPOSTOTIME(2, 32))
    data->alpha=(SONGPOSTOTIME(2, 32))/32-(time-SONGPOSTOTIME(2, 32))/16;
  else
    data->alpha=time/32;

  if((double)time/2816>M_PI)
    data->sourcex=139;
  else
    data->sourcex=69*cos((double)time/2816)+70;
}

static void params_03_stripes(void *d, long time) {
  verticalstripes_data *data=(verticalstripes_data *)d;
  time-=PART_03_START;
  if(time<0)
    time=0;
  
  if(time<SONGPOSTOTIME(1, 16)) {
  } else if(time<SONGPOSTOTIME(2, 0)) {
    int left=155*sin((time-SONGPOSTOTIME(1, 16))*M_PI/2/SONGPOSTOTIME(1, 48));
    int right=data->width-40*sin((time-SONGPOSTOTIME(1, 16))*M_PI/2/SONGPOSTOTIME(1, 48));
    int i;

    for(i=0; i<left; i++)
      data->alphas[i]=192;  
    data->alphas[left]=255;
    data->alphas[left+1]=192;
    data->alphas[left+2]=192;

    for(i=left+4; i<right-3; i++)
      data->alphas[i]=255;

    for(i=right; i<data->width; i++)
      data->alphas[i]=192;
    data->alphas[right-1]=255;
    data->alphas[right-2]=192;
    data->alphas[right-3]=192;
  }
}

static void params_03_copy_symbol(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_03_START;
  if(time<0)
    time=0;

  if(time>SONGPOSTOTIME(2, 32))
    data->alpha=(SONGPOSTOTIME(2, 32))/32-(time-SONGPOSTOTIME(2, 32))/16;
  else
    data->alpha=time/32;
}

static void params_03_copy_present(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_03_START;
  if(time<0)
    time=0;

  if(time>SONGPOSTOTIME(2, 32))
    data->alpha=(SONGPOSTOTIME(2, 32))/32-(time-SONGPOSTOTIME(2, 32))/16;
  else {
    double s=sin(pow((double)time/600, 2));
    if(time>SONGPOSTOTIME(2, 0) || s>0)
      data->alpha=time/32;
    else
      data->alpha=0;
  }
}

static void params_03_copy_jormas(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_03_START;
  if(time<0)
    time=0;

  if(time>SONGPOSTOTIME(2, 32))
    data->alpha=(SONGPOSTOTIME(2, 32))/32-(time-SONGPOSTOTIME(2, 32))/16;
  else {
    double s=sin(pow((double)time/600, 2));
    if(time>SONGPOSTOTIME(2, 0) || s>0)
      data->alpha=time/32;
    else
      data->alpha=0;
  }
}

static void params_03_copy_da(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_03_START;
  if(time<0)
    time=0;

  if(time>SONGPOSTOTIME(2, 32))
    data->alpha=(SONGPOSTOTIME(2, 32))/32-(time-SONGPOSTOTIME(2, 32))/16;
  else {
    double s=sin(pow((double)time/600, 2));
    if(time>SONGPOSTOTIME(2, 0) || s>0)
      data->alpha=time/32;
    else
      data->alpha=0;
  }
}

void part_03() {
  copy_data *copydata;
  horizontalblur_data *hbdata;
  verticalstripes_data *vsdata;
  int i;

  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  /* 7. Blur it */
  effectlist=effectlistentry_new(effect_new(horizontalblur_new,
					    params_03_horizontalblur),
				 effectlist);
  hbdata=(horizontalblur_data *)effectlist->effect->data;
  hbdata->source=pictures[TEMP];
  hbdata->dest=&screenbuffer;
  hbdata->amount=1;

  /* 6. Copy SYMBOL */
  effectlist=effectlistentry_new(effect_new(copy_new, params_03_copy_symbol),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[SYMBOL];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=8;
  copydata->desty=237;
  copydata->sourcewidth=pictures[SYMBOL]->width;
  copydata->sourceheight=pictures[SYMBOL]->height;
  copydata->destwidth=pictures[SYMBOL]->width;
  copydata->destheight=pictures[SYMBOL]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 5. Copy PRESENT */
  effectlist=effectlistentry_new(effect_new(copy_new, params_03_copy_present),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[PRESENT];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=265;
  copydata->desty=103;
  copydata->sourcewidth=pictures[PRESENT]->width;
  copydata->sourceheight=pictures[PRESENT]->height;
  copydata->destwidth=pictures[PRESENT]->width;
  copydata->destheight=pictures[PRESENT]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 4. Copy JORMAS */
  effectlist=effectlistentry_new(effect_new(copy_new, params_03_copy_jormas),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[JORMAS];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=205;
  copydata->desty=78;
  copydata->sourcewidth=pictures[JORMAS]->width;
  copydata->sourceheight=pictures[JORMAS]->height;
  copydata->destwidth=pictures[JORMAS]->width;
  copydata->destheight=pictures[JORMAS]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 3. Copy Da */
  effectlist=effectlistentry_new(effect_new(copy_new, params_03_copy_da),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[DA];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=180;
  copydata->desty=84;
  copydata->sourcewidth=pictures[DA]->width;
  copydata->sourceheight=pictures[DA]->height;
  copydata->destwidth=pictures[DA]->width;
  copydata->destheight=pictures[DA]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 2. Stripe it */
  effectlist=effectlistentry_new(effect_new(verticalstripes_new,
					    params_03_stripes), effectlist);
  vsdata=(verticalstripes_data *)effectlist->effect->data;
  vsdata->dest=pictures[TEMP];
  vsdata->x=0;
  vsdata->y=0;
  vsdata->width=pictures[TEMP]->width;
  vsdata->height=pictures[TEMP]->height;
  vsdata->alphas=(unsigned char *)calloc(vsdata->width,
					 sizeof(unsigned char));
  for(i=0; i<vsdata->width; i++)
    vsdata->alphas[i]=255;

  /* 1. Copy shipyard */
  effectlist=effectlistentry_new(effect_new(copy_new, params_03_copy_shipyard),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[SHIPYARD1];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[TEMP]->width;
  copydata->sourceheight=pictures[TEMP]->height;
  copydata->destwidth=pictures[TEMP]->width;
  copydata->destheight=pictures[TEMP]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;
}
