/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;

public class Fract
extends Applet
implements Runnable {
    private int[] colors = new int[128];
    private float x;
    private float y;
    private float width;
    private float height;
    private Image offScrImage;
    private Graphics offScrGr;
    private MemoryImageSource imageSource;
    private int[] pixels;
    private Image image;
    private Dimension size;
    private boolean doRender;
    private Rectangle mouseArea;
    private boolean mouseDown;
    int mouseX;
    int mouseY;
    private volatile boolean running;

    public Fract() {
        int n = 0;
        while (n < this.colors.length) {
            int n2 = n * n;
            int n3 = 80 + n2;
            int n4 = n2;
            int n5 = 2 * n;
            n3 = Math.min(255, n3);
            n5 = Math.min(255, n5);
            n4 = Math.min(255, n4);
            this.colors[n] = 0xFF000000 | n3 << 16 | n4 << 8 | n5;
            ++n;
        }
        this.x = -2.1f;
        this.y = -1.5f;
        this.width = 3.0f;
        this.height = 3.0f;
        this.offScrImage = null;
        this.offScrGr = null;
        this.doRender = true;
        this.mouseArea = new Rectangle();
        this.mouseDown = false;
        this.running = true;
    }

    private void calcNewArea() {
        if (this.mouseArea.width == 0 || this.mouseArea.height == 0) {
            this.x = -2.1f;
            this.y = -1.5f;
            this.width = 3.0f;
            this.height = 3.0f;
        } else {
            double d = (double)this.mouseArea.x / (double)this.size.width;
            double d2 = (double)this.mouseArea.y / (double)this.size.height;
            double d3 = (double)this.mouseArea.width / (double)this.size.width;
            double d4 = (double)this.mouseArea.height / (double)this.size.width;
            double d5 = (double)this.x + d * (double)this.width;
            double d6 = (double)this.y + d2 * (double)this.height;
            double d7 = d3 * (double)this.width;
            double d8 = d4 * (double)this.height;
            this.x = (float)d5;
            this.y = (float)d6;
            this.width = (float)d7;
            this.height = (float)d8;
        }
        this.doRender = true;
    }

    private int getColor(float f, float f2) {
        float f3 = f;
        float f4 = f2;
        boolean bl = false;
        int n = 0;
        while (!bl) {
            float f5 = f3 * f3 + -f4 * f4;
            float f6 = 2.0f * f3 * f4;
            float f7 = (f3 = f5 + f) * f3 + (f4 = f6 + f2) * f4;
            if ((double)f7 > 4.0 || ++n > 126) break;
        }
        return this.colors[n];
    }

    public void paint(Graphics graphics) {
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, this);
            if (this.mouseDown) {
                graphics.setColor(Color.black);
                graphics.drawRect(this.mouseArea.x, this.mouseArea.y, this.mouseArea.width, this.mouseArea.height);
            }
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.mouseDown = true;
            this.mouseX = this.mouseArea.x = mouseEvent.getX();
            this.mouseY = this.mouseArea.y = mouseEvent.getY();
        } else if (mouseEvent.getID() == 502) {
            this.mouseArea.x = this.mouseX;
            this.mouseArea.y = this.mouseY;
            this.mouseArea.width = mouseEvent.getX() - this.mouseArea.x;
            this.mouseArea.height = mouseEvent.getY() - this.mouseArea.y;
            if (this.mouseArea.width < 0) {
                this.mouseArea.x += this.mouseArea.width;
                this.mouseArea.width = -this.mouseArea.width;
            }
            if (this.mouseArea.height < 0) {
                this.mouseArea.y += this.mouseArea.height;
                this.mouseArea.height = -this.mouseArea.height;
            }
            this.mouseDown = false;
            this.calcNewArea();
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506) {
            this.mouseArea.x = this.mouseX;
            this.mouseArea.y = this.mouseY;
            this.mouseArea.width = mouseEvent.getX() - this.mouseArea.x;
            this.mouseArea.height = mouseEvent.getY() - this.mouseArea.y;
            if (this.mouseArea.width < 0) {
                this.mouseArea.x += this.mouseArea.width;
                this.mouseArea.width = -this.mouseArea.width;
            }
            if (this.mouseArea.height < 0) {
                this.mouseArea.y += this.mouseArea.height;
                this.mouseArea.height = -this.mouseArea.height;
            }
            this.repaint();
        }
    }

    public void run() {
        this.size = this.getSize();
        this.pixels = new int[this.size.width * this.size.height];
        this.imageSource = new MemoryImageSource(this.size.width, this.size.height, this.pixels, 0, this.size.width);
        this.imageSource.setAnimated(true);
        this.imageSource.setFullBufferUpdates(true);
        this.image = this.createImage(this.imageSource);
        this.enableEvents(48L);
        Thread.currentThread().setPriority(1);
        while (this.running) {
            if (this.doRender) {
                int n = 0;
                int n2 = 4;
                float f = this.width / (float)this.size.width;
                float f2 = this.height / (float)this.size.height;
                while (n < n2) {
                    int n3 = n;
                    while (n3 < this.size.width) {
                        float f3 = this.x + (float)n3 * f;
                        int n4 = 0;
                        while (n4 < this.size.height && !this.mouseDown) {
                            int n5;
                            this.pixels[this.size.width * n4 + n3] = n5 = this.getColor(f3, this.y + (float)n4 * f2);
                            ++n4;
                        }
                        n3 += n2;
                    }
                    this.image.flush();
                    this.repaint();
                    ++n;
                    Thread.yield();
                }
                this.doRender = false;
            }
            try {
                Thread.sleep(40L);
            }
            catch (Exception exception) {}
        }
    }

    public void start() {
        this.running = true;
        new Thread(this).start();
    }

    public void stop() {
        this.running = false;
    }

    public void update(Graphics graphics) {
        if (this.offScrImage == null) {
            this.offScrImage = this.createImage(this.size.width, this.size.height);
            this.offScrGr = this.offScrImage.getGraphics();
        }
        this.paint(this.offScrGr);
        graphics.drawImage(this.offScrImage, 0, 0, this);
    }
}

