// thrown together in a hurry 
// (when i should have been studying/sleeping)
// by pompy / ethereal


#include <windows.h>
#include "music.hpp"


void BassSync(FMUSIC_MODULE *mod,unsigned char param);
void PercSync(FMUSIC_MODULE *mod,unsigned char param);
void BlehSync(FMUSIC_MODULE *mod,unsigned char param);


ModPlayer::ModPlayer() 
{
	if (FSOUND_GetVersion() < FMOD_VERSION)	
	{
		MessageBox(0, "fmod sez: incorrect version", "fmud", MB_OK);
		exit(1);
	}

	if (!FSOUND_Init(44100, 32, /*FSOUND_INIT_GLOBALFOCUS*/ 0)) 
	{
		MessageBox(0, FMOD_ErrorString(FSOUND_GetError()) ,"fmud", MB_OK);
		exit(1);
	}

	open = false;
	play = false;
}


ModPlayer::~ModPlayer() 
{
	if( play ) FMUSIC_StopSong(mod);
	if( open ) FMUSIC_FreeSong(mod);
	FSOUND_Close();
}


bool ModPlayer::Open(char *filename) 
{
	if( open ) FMUSIC_FreeSong(mod);
	mod = FMUSIC_LoadSong(filename);
	if( !mod ) return false;
	open = true;
	return true;
}


bool ModPlayer::Play() 
{
	if( !open ) return false;
	play = true;
	FMUSIC_PlaySong(mod);
	
	FMUSIC_SetInstCallback(mod,BassSync, 1);
	FMUSIC_SetInstCallback(mod,PercSync, 4);
	FMUSIC_SetInstCallback(mod,BlehSync, 20);

	return true;
}


unsigned long ModPlayer::GetTicks() 
{
	if( !play ) return 0;
	return FMUSIC_GetTime(mod);
}


bool ModPlayer::Stop() 
{
	if( !open || !play ) return false;
	FMUSIC_StopSong(mod);
	play = false;
	return true;
}
