/*
**	Water effect header. FirEdge / Ethereal
*/



#ifndef _FX_WATER_HPP_
#define _FX_WATER_HPP_


#include "Demoengine.hpp"


#define SX 32
#define SZ 32
#define CTRLPOINTS ((SX+SZ)*2)	// Defines a 1024 polygon surface.


#ifdef dx
#undef dx
#endif
#define dx 0.1f

#ifdef dz
#undef dz
#endif
#define dz 0.1f



#define FX_WATER 4



typedef struct {
	float u,v;
	float t;
	int plane;
} hitinfo;



typedef struct {
	float y;
	vertex n;
	hitinfo T;		// refraction hit info
	hitinfo R;		// reflection hit info
} CtrlPt ;



class fxWater : public FX
{
	vertex			f[CTRLPOINTS];						// Impact points
	CtrlPt			height[SX-2][SZ-2];					// Control points of water patch.

	int				traj;
	float			localt;										// to make it move...
	unsigned int	watermap,wallmap,undermap,envmap,grassmap;	// OpenGL textures

	virtual void Camera( float time );

public:

	vertex O;

	fxWater();
	
	bool	Init(const Loader* l);
	void	Render(float time, const Demo *env);
	void	Push(ud type, float value);
	void	DeInit();
	
	~fxWater();
};



#endif