/*
**
**	Water simulation effect. The render will be very strange, at the point it won't
**	seem to be water.
**
**	FirEdge / Ethereal on 06/20/2001
**
*/


#include <windows.h>
#include <gl/gl.h>
#include <math.h>
#include "ijl.h"

#include "fxWater.hpp"

// Planes definitions for raytracing.

#define SPlane 1
#define EPlane 2
#define NPlane 4
#define WPlane 8
#define UPlane 16




fxWater::fxWater()
{
	localt = 0.0f;
	traj = 0;

	/* init of the vertex array.
	**
	** here the impact points are arranged on the edges of a square.
	** They could be arranged on the edges of any convex polygon that
	** represents a lake.
	*/

	for (int i=0; i<CTRLPOINTS; i++)
	{
		if (i<SZ)
		{
			f[i].x = -1.0f;
			f[i].y = 0.0f;
			f[i].z = i * dz + ( rand() /  65000.0f );
		}

		if (( i >= SX ) && ( i < SX + SZ))
		{
			f[i].x = (i - SZ) * dx + ( rand() /  65000.0f );
			f[i].y = 0.0f;
			f[i].z = ( SZ * dz ) + 1.0f;
		}

		if (( i >= (SX + SZ)) && ( i < (SX + 2*SZ)))
		{
			f[i].x = dx * SX + 1.0f;
			f[i].y = 0.0f;
			f[i].z = - dz * ( i - 2 * SZ - SX ) + ( rand() /  65000.0f );
		}

		if ( i >= ( SX + 2*SZ ) )
		{
			f[i].x = ( CTRLPOINTS - i + SX ) * dx + ( rand() /  65000.0f );
			f[i].y = 0.0f;
			f[i].z = -1.0f;
		}
	}
}


bool fxWater::Init(const Loader* l)
{
	BYTE pixel_buf [256*256*3];
	JPEG_CORE_PROPERTIES jcprops1;
	JPEG_CORE_PROPERTIES jcprops;
	JPEG_CORE_PROPERTIES bleh;
	JPEG_CORE_PROPERTIES bleh1;


	// Load water texture.

	ijlInit (&jcprops1);

	jcprops1.JPGFile = "data/water.jpg";

	jcprops1.DIBWidth = 256;
	jcprops1.DIBHeight = 256;
	jcprops1.DIBChannels = 3;
	jcprops1.DIBColor = IJL_RGB;
	jcprops1.DIBPadBytes = 0;
	jcprops1.DIBBytes = pixel_buf;

    ijlRead (&jcprops1, IJL_JFILE_READWHOLEIMAGE);
	ijlFree (&jcprops1);	

	glGenTextures(4, &watermap);
	glBindTexture(GL_TEXTURE_2D, watermap);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, 256, 256, 0, GL_RGB, GL_UNSIGNED_BYTE, pixel_buf);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);


	// Load wall texture.

	ijlInit (&jcprops);

	jcprops.JPGFile = "data/wall.jpg";

	jcprops.DIBWidth = 256;
	jcprops.DIBHeight = 256;
	jcprops.DIBChannels = 3;
	jcprops.DIBColor = IJL_RGB;
	jcprops.DIBPadBytes = 0;
	jcprops.DIBBytes = pixel_buf;

    ijlRead (&jcprops, IJL_JFILE_READWHOLEIMAGE);
	ijlFree (&jcprops);	

	glBindTexture(GL_TEXTURE_2D, wallmap);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, 256, 256, 0, GL_RGB, GL_UNSIGNED_BYTE, pixel_buf);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);


	// Load underwater texture.

	ijlInit (&bleh);

	bleh.JPGFile = "data/underwater.jpg";

	bleh.DIBWidth = 128;
	bleh.DIBHeight = 128;
	bleh.DIBChannels = 3;
	bleh.DIBColor = IJL_RGB;
	bleh.DIBPadBytes = 0;
	bleh.DIBBytes = pixel_buf;

    ijlRead (&bleh, IJL_JFILE_READWHOLEIMAGE);
	ijlFree (&bleh);	

	glBindTexture(GL_TEXTURE_2D, undermap);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, 128, 128, 0, GL_RGB, GL_UNSIGNED_BYTE, pixel_buf);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);


	// Load sunset texture	


	// Load Grass texture

	ijlInit (&bleh1);

	bleh1.JPGFile = "data/grass.jpg";

	bleh1.DIBWidth = 128;
	bleh1.DIBHeight = 128;
	bleh1.DIBChannels = 3;
	bleh1.DIBColor = IJL_RGB;
	bleh1.DIBPadBytes = 0;
	bleh1.DIBBytes = pixel_buf;

    ijlRead (&bleh1, IJL_JFILE_READWHOLEIMAGE);
	ijlFree (&bleh1);	

	glBindTexture(GL_TEXTURE_2D, grassmap);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, 128, 128, 0, GL_RGB, GL_UNSIGNED_BYTE, pixel_buf);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);


	return true;
}


/*
**	The simulation is based on the fact we can approximate
**  the shape of the wave generated by a pebble falling down
**	in calm water by the following function:
**
**              i cos( sqrt( x + z ) + t )
**	y(x,z) = ----------------------------------
**                  sqrt( a + x + z )
**
**
**  let i,a be intensity coefficients.
**	let t be the "time". By making t groth continuously between 0 and 2*pi,
**	we get a wave animation.
**
**	Here we will approximate this function in a simple cube. 
**
*/

void fxWater::Camera( float time )
{
	// OpenGL Viewport setup.

	glLoadIdentity();
	glTranslatef( -1.0f - time , -0.5f + time * 0.15f , -3.5f + (time * 1.1f) );
	glRotatef( time*35.0f , 0.0f, 1.0f, 0.0f);
	glRotatef( time*30.0f , 1.0f, 0.4f, 0.0f );

	O.x = 1.0f + time;			// Camera Eye (fr : Oeil) position...
	O.y = 0.5f + time * 0.15f;
	O.z = 3.5f + time * 1.1f;

}


void fxWater::Render(float time, const Demo *env)
{
	int i,j,k;
	float heigh,px,pz,d,dI;
	vertex I,T;

	GLfloat light_position[] = { 0.5, 2.0, 4.0, 0.0 };
	localt = time * 30.0f;

	Camera( time );

	// Draw the pool walls:

	glDisable( GL_BLEND );
	glEnable( GL_DEPTH_TEST );
	glLightfv(GL_LIGHT0, GL_POSITION, light_position);
	glDisable( GL_LIGHTING );
	glDisable( GL_LIGHT0 );

	glEnable( GL_TEXTURE_2D );
	glBindTexture(GL_TEXTURE_2D, wallmap);
	glColor4ub( 127, 127, 127, 128 );


	glBegin( GL_QUADS );
		glTexCoord2f( 0.0f, 1.0f );
		glVertex3f( dx*3 , 0.25f , dz*3 );
		glTexCoord2f( 1.0f, 1.0f );
		glVertex3f( (SX-4) * dx , 0.25f , dz*3 );
		glTexCoord2f( 1.0f, 0.0f );
		glVertex3f( (SX-4) * dx , -1.0f , dz*3 );
		glTexCoord2f( 0.0f, 0.0f );
		glVertex3f( dx*3 , -1.0f , dz*3 );

		glTexCoord2f( 0.0f, 1.0f );
		glVertex3f( dx*3 , 0.25f , (SZ-3) * dz );
		glTexCoord2f( 1.0f, 1.0f );
		glVertex3f( (SX-4) * dx , 0.25f , (SZ-3) * dz );
		glTexCoord2f( 1.0f, 0.0f );
		glVertex3f( (SX-4) * dx , -1.0f , (SZ-3) * dz );
		glTexCoord2f( 0.0f, 0.0f );
		glVertex3f( dx*3 , -1.0f , (SZ-3) * dz );

		glTexCoord2f( 0.0f, 1.0f );
		glVertex3f( dx*3 , 0.25f , dz*3 );
		glTexCoord2f( 1.0f, 1.0f );
		glVertex3f( dx*3 , 0.25f , (SZ-3) * dz );
		glTexCoord2f( 1.0f, 0.0f );
		glVertex3f( dx*3 , -1.0f , (SZ-3) * dz );
		glTexCoord2f( 0.0f, 0.0f );
		glVertex3f( dx*3 , -1.0f , dz*3 );

		glTexCoord2f( 0.0f, 1.0f );
		glVertex3f( (SX-4) * dx , 0.25f , dz*3 );
		glTexCoord2f( 1.0f, 1.0f );
		glVertex3f( (SX-4) * dx , 0.25f , (SZ-3) * dz );
		glTexCoord2f( 1.0f, 0.0f );
		glVertex3f( (SX-4) * dx , -1.0f , (SZ-3) * dz );
		glTexCoord2f( 0.0f, 0.0f );
		glVertex3f( (SX-4) * dx , -1.0f , dz*3 );
	glEnd();


	// Render the surrounding grass...

	glBindTexture(GL_TEXTURE_2D, grassmap);
	glEnable( GL_BLEND );
	glBlendFunc( GL_ONE_MINUS_SRC_ALPHA, GL_SRC_ALPHA );

	glBegin( GL_QUADS );

		glColor4ub( 127, 127, 127, 0 );
		glTexCoord2f( 0.0f, 1.0f );				// Right quad
		glVertex3f( (SX-4) * dx , 0.25f , SZ * dz );
		glColor4ub( 0, 0, 0, 255 );
		glTexCoord2f( 1.0f, 1.0f );
		glVertex3f( 2 * SX * dx , 0.25f , SZ * dz );
		glTexCoord2f( 1.0f, 0.0f );
		glVertex3f( 2 * SX * dx, 0.25f , dz*3 );
		glColor4ub( 127, 127, 127, 0 );
		glTexCoord2f( 0.0f, 0.0f );
		glVertex3f( (SX-4) * dx , 0.25f , dz*3 );

		glColor4ub( 0, 0, 0, 255 );
		glTexCoord2f( 0.0f, 1.0f );				// Left quad
		glVertex3f( -SX * dx , 0.25f , dz*3 );
		glTexCoord2f( 1.0f, 1.0f );
		glVertex3f( -SX * dx , 0.25f , (SZ-3) * dz );
		glColor4ub( 127, 127, 127, 0 );
		glTexCoord2f( 1.0f, 0.0f );
		glVertex3f( dx*3 , 0.25f , (SZ-3) * dz );
		glTexCoord2f( 0.0f, 0.0f );
		glVertex3f( dx*3 , 0.25f , dz*3 );

/*		glTexCoord2f( 0.0f, 1.0f );				// Back Quad
		glVertex3f( dx*3 , 0.25f , (SZ-3) * dz );
		glTexCoord2f( 1.0f, 1.0f );
		glVertex3f( (SX-3) * dx , 0.25f , (SZ-3) * dz );
		glTexCoord2f( 1.0f, 0.0f );
		glVertex3f( (SX-3) * dx , 0.25f , (SZ-3) * dz );
		glTexCoord2f( 0.0f, 0.0f );
		glVertex3f( dx*3 , 0.25f , (SZ-3) * dz ); //*/

		glColor4ub( 127, 127, 127, 0 );
		glTexCoord2f( 0.0f, 1.0f );				// Front Quad
		glVertex3f( dx*3 , 0.25f , dz*3 );
		glTexCoord2f( 1.0f, 1.0f );
		glVertex3f( (SX-4) * dx , 0.25f , dz*3 );
		glColor4ub( 0, 0, 0, 255 );
		glTexCoord2f( 1.0f, 0.0f );
		glVertex3f( (SX-4) * dx , 0.25f , -SZ*dz );
		glTexCoord2f( 0.0f, 0.0f );
		glVertex3f( dx*3 , 0.25f , -SZ*dz );

		glColor4ub( 127, 127, 127, 0 );
		glTexCoord2f( 1.0f, 1.0f );				// Front Right Quad
		glVertex3f( (SX-4) * dx , 0.25f , dz*3 );
		glColor4ub( 0, 0, 0, 255 );
		glTexCoord2f( 0.0f, 1.0f );
		glVertex3f( 2 * SX * dx , 0.25f , dz*3 );
		glTexCoord2f( 0.0f, 0.0f );
		glVertex3f( 2 * SX * dx , 0.25f , -SZ*dz );
		glTexCoord2f( 1.0f, 0.0f );
		glVertex3f( (SX-4) * dx , 0.25f , -SZ*dz );

		glColor4ub( 127, 127, 127, 0 );
		glTexCoord2f( 0.0f, 1.0f );				// Front Left Quad
		glVertex3f( dx*3 , 0.25f , dz*3 );
		glColor4ub( 0, 0, 0, 255 );
		glTexCoord2f( 1.0f, 1.0f );
		glVertex3f( -SX * dx , 0.25f , dz*3 );
		glTexCoord2f( 1.0f, 0.0f );
		glVertex3f( -SX * dx , 0.25f , -SZ*dz );
		glTexCoord2f( 0.0f, 0.0f );
		glVertex3f( dx*3 , 0.25f , -SZ*dz );

	glEnd();

	//	calculate water waves, normals, raytrace... while our GPU is drawing 
	//	the big QUADS specified above...

	px = dx;

		for ( i = 1; i < SX-3; i++ )
		{
			pz = dz;

			for ( j = 1; j < SZ-3; j++ )
			{
				heigh = 0.0f;

				for ( k = 0; k<CTRLPOINTS; k++ )
				{
					d = (f[k].x - px) * (f[k].x - px) + (f[k].z - pz) * (f[k].z - pz);
					heigh += (float) ( cos( ( d * 10.0f ) - localt ) + 1.0 ) / ( 2.0f + d );
				}


				heigh /= CTRLPOINTS;
				height[i][j].y = heigh;

				/*
				**	Normal vertex calculation
				*/
				
				height[i][j].n.x = -2.0f * dz * ( height[i-1][j].y - height[i+1][j].y );
				height[i][j].n.y = 4.0f * dx * dz;
				height[i][j].n.z = -2.0f * dx * ( height[i][j-1].y - height[i][j+1].y);

				float norm = 1.0f / (float) sqrt( height[i][j].n.x * height[i][j].n.x + 
												  height[i][j].n.y * height[i][j].n.y +
												  height[i][j].n.z * height[i][j].n.z );

				height[i][j].n.x *= norm;
				height[i][j].n.y *= norm;
				height[i][j].n.z *= norm;


				pz += dz;
			}

			px += dx;
		}
				
				
	px = dx;


		for ( i = 0; i < SX-2; i++ )
		{
			pz = dz;

			for ( j = 0; j < SZ-2; j++ )
			{

				// Calculate refraction texture coordinates here.

				// Incident vector I calculation

				I.x = px - O.x;		// I : Incident vector
				I.y = height[i][j].y - O.y;
				I.z = pz - O.z;
				dI = 1.0f / (float) sqrt( I.x * I.x + I.y * I.y + I.z * I.z );
				I.x *= dI;
				I.y *= dI;
				I.z *= dI;

				// refraction vector T calculation. 
				// I cheated a lot with maths to make it beautiful ;)

				float dotp = I.x * height[i][j].n.x + I.y * height[i][j].n.y + I.z * height[i][j].n.z;
				float ncoef = 1.2f * dotp - (float) sqrt( abs(1.0f - 2.5f * (1.0f - dotp*dotp) ) );
				T.x = ncoef * height[i][j].n.x - 1.2f * I.x ;
				T.y = ncoef * height[i][j].n.y - 1.2f * I.y ;
				T.z = ncoef * height[i][j].n.z - 1.2f * I.z ;

				float	t = ( - 0.5f - height[i][j].y ) / T.y;

				height[i][j].T.u = (T.x * t + px);
				height[i][j].T.v = (T.z * t + pz);

				pz += dz;
			}

			px += dx;
		}

	// Draw the water.

	glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );

	px = dx+dx;

		for ( i = 2; i < SX-2; i++ )
		{
			pz = dz+dz;

			for ( j = 2; j < SZ-2; j++ )
			{

				/*
				**  Rendering below:
				*/

				// first pass : water.

				glBindTexture(GL_TEXTURE_2D, watermap);
				glEnable( GL_LIGHT0 );
				glEnable( GL_LIGHTING );
				glDisable( GL_BLEND );


				glBegin( GL_QUADS );

					glNormal3fv( &height[i-1][j].n.x );
					glTexCoord2f( (px) / ( SX * dx ), (pz+dz) / ( SZ * dz ) );
					glVertex3f( px , height[i-1][j].y, pz+dz );

					glNormal3fv( &height[i][j].n.x );
					glTexCoord2f( (px+dx) / ( SX * dx ), (pz+dz) / ( SZ * dz ) );
					glVertex3f( px+dx , height[i][j].y, pz+dz );

					glNormal3fv( &height[i][j-1].n.x );
					glTexCoord2f( (px+dx) / ( SX * dx ), (pz) / ( SZ * dz ) );
					glVertex3f( px+dx , height[i][j-1].y, pz );

					glNormal3fv( &height[i-1][j-1].n.x );
					glTexCoord2f( (px) / ( SX * dx ), (pz) / ( SZ * dz ) );
					glVertex3f( px , height[i-1][j-1].y, pz );

				glEnd();


				// Second pass : refracted underwater.

				/*
				**	Refraction uses formulae:
				**
				**	T = ( 3/2(N.I) - sqrt(1-9/4(1-(N.I))) ) N - 3/2 I
				**
				*/

				glBindTexture( GL_TEXTURE_2D, undermap );

				glDisable( GL_LIGHT0 );
				glDisable( GL_LIGHTING );
				glEnable( GL_BLEND );
				glColor4ub( 128, 128, 128, 80 );

				glBegin( GL_QUADS );

					glTexCoord2f( height[i-1][j].T.u , height[i-1][j].T.v );
					glVertex3f( px , height[i-1][j].y , pz+dz );

					glTexCoord2f( height[i][j].T.u, height[i][j].T.v );
					glVertex3f( px+dx , height[i][j].y, pz+dz );
					
					glTexCoord2f( height[i][j-1].T.u, height[i][j-1].T.v );
					glVertex3f( px+dx , height[i][j-1].y, pz );
					
					glTexCoord2f( height[i-1][j-1].T.u, height[i-1][j-1].T.v );
					glVertex3f( px , height[i-1][j-1].y, pz );

				glEnd();

				// Third pass : reflections.

				/*
				**	No sunset reflections, the effect is stopped at its current state:
				**	half finished...
				*/

/*				glBegin( GL_QUADS );


				glEnd();		//*/

				
				pz += dz;
			}

			px += dx;
		}


}


void fxWater::Push(ud type, float value)
{
	if (type == PUSH_BLEH)
		traj++;
}


void fxWater::DeInit()
{
	glDeleteTextures( 4, &watermap );
}


fxWater::~fxWater()
{

}

