// demoloader2.cpp
// implementation of data file loading/saving
// by pompy / Ethereal	

#include <memory.h>
#include <string.h>
#include <windows.h>

#include "loader.hpp"


Loader::Loader(char *filename, void (*callback)(int, char *), Demo* environement) 
{
	env = environement;
	currdemo = 0;
	data = NULL;
	tab = NULL;
	char head[4];
	char name[21];
	unsigned int size, next;
	ndemos = 0;
	in = fopen(filename, "rb");
	
	if( !in ) 
	{
		if( callback ) callback(-1, NULL);
		return;
	}

	fread(head, 4, 1, in);
	
	if( !strncmp(head, "pmpy", 4) ) 
	{
		if( callback ) callback(-1, NULL);
		return;
	}
	
	do 
	{
		memset(name, 0, 21);
		fread(&size, 4, 1, in);
		fread(&next, 4, 1, in);
		fread(name, 1, 20, in);
		fseek(in, next, SEEK_SET);
		ndemos++;
		if( callback ) callback(ndemos, name);
	} while( next!=0 );

	if( ndemos == 0 ) 
	{
		if(callback) callback(-1, NULL);
		return;
	}
	return;
}



bool Loader::SelectDemo(unsigned int demo) 
{
	
	unsigned int where=1, size, next;
	bool comp=false;
	
	if( demo > ndemos ) return false;
	
	if( currdemo ) 
	{
		if( data ) free(data);
	}

	currdemo = demo;
	fseek(in, 4, SEEK_SET);

	while(where != demo) 
	{
		where++;
		fread(&size, 4, 1, in);
		fread(&next, 4, 1, in);
		fseek(in, next, SEEK_SET);
	};
	
	
	if( size & 1 ) 
	{
		size--;
		comp = true;
	}

	if( comp ) 
	{
/*		char *compdata = malloc(size);
		fread(compdata, 1, size, in);
		decompress(compdata, &data);
		free(compdata);*/
		MessageBox(0, "compression not implemented", "error", MB_OK);
		return false;
	} else {

		data = (unsigned char *)malloc(size);

		if( fread(data, size, 1, in) != size ) 
		{
			free(data);
			return false;
		}
	}

	tabsize = *((int *)(data+28));
	tab = (table *)(data+32);
	return true;
}


int Loader::GetNumber(unsigned int type) 
{
	unsigned int num=0;
	for(unsigned int i=0; i<tabsize; i++) 
	{
		if( tab[i].type == type ) num++;
	}
	return num;
}


//Spline *Loader::GetSpline(int id) {
//	return NULL;
//}


Loader::~Loader() 
{
	if( data ) free(data);
	if( in ) fclose(in);
}

/*******************************************************
**
**		Writer here, sorry to modify so much 
**		your code, pompy.
**
*******************************************************/


Writer::Writer()
{
}


