/* PLASMA */
/* SoopaDoopa 2001 */

#include "eks3.h"
#include "gif.h"
#include "dma.h"
#include "texture.h"
#include "math.h"
#include "vu.h"
#include "matrix.h"

static int128	list[40];

extern unsigned int vucodebegin  __attribute__((section(".vudata")));
extern unsigned int vucodeend  __attribute__((section(".vudata")));
extern unsigned int vudatabegin  __attribute__((section(".vudata")));
extern unsigned int vudataend  __attribute__((section(".vudata")));

extern char binary_kantlogo_start[];
extern char binary_kantfade_start[];
extern char binary_scroll_start[];

static texture kantlogo;
static texture kantfade;
static texture scroll;

extern int128 e_start,e_delta,e_giftag,e_matrix,e_seed   __attribute__((section(".vudata")));
extern vec e_light,e_lightcolor   __attribute__((section(".vudata")));

static float sss1,sss2,sss3;
static float maxzoom;
static int scrollv;

static fvec ver(float x, float y, float z)
{
	fvec v;

	v.x=x;
	v.y=y;
	v.z=z;
	v.w=1.0;

	return v;
}

static ivec fac(int x, int y, int z)
{
	ivec v;

	v.x=x;
	v.y=y;
	v.z=z;
	v.w=0;

	return v;
}

extern int PAL;

static void vutest(float frames)
{
	static float angle;
	int x,y;
	float s;
	fmatrix M;
	int minx;
	gif_env;

	
	if(PAL)
		minx=0;
	else
		minx=10;

	
	vu1_wait();

	vu1_uploadcode(&vucodebegin,&vucodeend);

	{
		ivec *f;
		float a=0.5;
		float b=0.87;
		float c=0.25;
		fvec *v;

		v=((fvec*)vu1_mem)+20;

		v[0]=ver(1.0,0,c);
		v[1]=ver(a,b,c);
		v[2]=ver(-a,b,c);
		v[3]=ver(-1.0,0,c);
		v[4]=ver(-a,-b,c);
		v[5]=ver(a,-b,c);
		v[6]=ver(1.0,0,-c);
		v[7]=ver(a,b,-c);
		v[8]=ver(-a,b,-c);
		v[9]=ver(-1.0,0,-c);
		v[10]=ver(-a,-b,-c);
		v[11]=ver(a,-b,-c);

		v[12]=ver(0,0,1);
		v[13]=ver(b,a,0);
		v[14]=ver(0,1,0);
		v[15]=ver(-b,a,0);
		v[16]=ver(-b,-a,0);
		v[17]=ver(0,-1,0);
		v[18]=ver(b,-a,0);
		v[19]=ver(0,0,-1);
//		v[20]=ver(0,0,1);


		f=((ivec*)vu1_mem)+50;

		f[0]=fac(3,4,12);
		f[1]=fac(2,5,12);
		f[2]=fac(1,0,12);
		f[3]=fac(0,6,13);
		f[4]=fac(1,7,13);
		f[5]=fac(2,8,14);
		f[6]=fac(3,9,15);
		f[7]=fac(4,10,16);
		f[8]=fac(5,11,17);
		f[9]=fac(0,6,18);
		f[10]=fac(6,7,19);
		f[11]=fac(11,8,19);
		f[12]=fac(10,9,19);

		e_giftag.hi=0x551;
		e_giftag.lo=0x3002400000008000;

		angle=0.005*3*4*frames;
		
		vu1_uploaddata(&vudatabegin,&vudataend);
	}

	{
		float mulx,muly;
		fvec a,b,c,d;

		a.x=0.5+0.4*sin(angle);
		a.y=0.5+0.2*sin(angle+2);
		a.z=0.5+0.3*sin(angle+0.3);
		b.x=0.5+0.4*sin(2*angle);
		b.y=0.5+0.2*sin(angle+1);
		b.z=0.5+0.3*sin(0.5*angle+0.3);
		c.x=0.5+0.4*sin(0.2*angle);
		c.y=0.5+0.2*sin(0.9*angle);
		c.z=0.5+0.3*sin(angle+2);
		d.x=0.5+0.4*sin(angle+1);
		d.y=0.5+0.2*sin(0.8*angle+1);
		d.z=0.5+0.3*sin(0.9*angle+0.3);
		
		mulx=0.5*cos(angle*0.05);
		muly=0.5*cos(angle*0.1);

		for(x=minx;x<80;x++)
		{
			{
				s=0.2+maxzoom*(0.23-0.28*cos(2*angle*0.15+(x)*(0.03-0.03*cos2(2*angle*0.03))));

				e_light.fvec.x=0;
				e_light.fvec.y=0;
				e_light.fvec.z=-7/sqrt(s)/16.0;
				
				resetmatrixf(&M);
				scalematrixf(&M,s,s,s);
				scalematrixf(&M,170,170,170);
		
				frotatematrixzf(&M,0.3*sin(angle*0.08));
		
				frotatematrixxf(&M,0.15*sin(angle*0.07)*cos2(angle*0.4+x*0.05));
				frotatematrixyf(&M,0.13*sin(angle*0.08));
		
				scalematrixf(&M,1,320.0/256,1);
				movematrixf(&M,0,0,2000);
		
				M.xu+=0.5*M.zu;
				M.xv+=0.5*M.zv;
				M.xw+=0.5*M.zw;
				M.xx+=0.5*M.zz;
				M.yu+=0.5*M.zu;
				M.yv+=0.5*M.zv;
				M.yw+=0.5*M.zw;
				M.yy+=0.5*M.zz;
		
				scalematrixf(&M,640*16,256*16,1);
		
				M.xu+=32000*M.zu;
				M.xv+=32000*M.zv;
				M.xw+=32000*M.zw;
				M.xx+=32000*M.zz;
				M.yu+=32000*M.zu;
				M.yv+=32000*M.zv;
				M.yw+=32000*M.zw;
				M.yy+=32000*M.zz;
			}
		
				
			for(y=0;y<30;y++)
			{
				fmatrix m;
		
				float X=x*(1/80.0);
				float Y=y*(1/30.0);
		
				float A=X*Y;
				float B=(1-X)*Y;
				float C=X*(1-Y);
				float D=(1-X)*(1-Y);
		
				m=M;
				fmovematrixf(&m,0.75*(x-39.5),2*0.433*((y-10.5)+0.5*(x&1)),0);
		
				{
					float scale=0.5;
		
					scale=sss1*(0.5/256.0*(((unsigned char*)(kantlogo.image))[80*y+x]))
					     +sss2*(0.5/256.0*(((unsigned char*)(kantfade.image))[80*y+x]))
					     +sss3*(0.5/256.0*(((unsigned char*)(scroll.image))[2048*y+((x+scrollv)&2047)]));
		
					fscalematrixf(&m,scale,scale,scale);

				}

				frotatematrixyf(&m,angle*0.4+(x)*0.06*sin2(y*mulx));
				vu1_wait();
				frotatematrixxf(&m,angle+y*0.05*sin2((x)*muly));

				vu1_wait();
				*((fmatrix*)&e_matrix)=m;


				e_lightcolor.fvec.x=A*a.x+B*b.x+C*c.x+D*d.x;
				e_lightcolor.fvec.y=A*a.y+B*b.y+C*c.y+D*d.y;
				e_lightcolor.fvec.z=A*a.z+B*b.z+C*c.z+D*d.z;

				vu1_uploaddata(&vudatabegin,&vudataend);

				vu1_start();
			}
		}
	}
}


void eks3_init()
{
	texture_init(&kantlogo);
	texture_load(&kantlogo,binary_kantlogo_start);
	texture_init(&kantfade);
	texture_load(&kantfade,binary_kantfade_start);
	texture_init(&scroll);
	texture_load(&scroll,binary_scroll_start);
}

void eks3_init2()
{
}

void eks3_frame(float frames)
{
	scrollv=frames-900;
	
	maxzoom=1;

	{
		sss1=0.5-0.5*cos(frames*0.0025*0);
		sss2=1-sss1;
		sss3=0;
	}

	if(frames<100)
	{
		float s=min(1,frames/100.0);
		
		sss1*=s;
		sss2*=s;
	}

	if(frames>800)
	{
		sss3=min((frames-800)/150.0,1);

		maxzoom-=0.4*sss3*maxzoom;
	}
	sss1*=(1-sss3);
	sss2*=(1-sss3);

	vutest(frames);
}

void eks3_deinit()
{
}
