#include <math.h>
#include <iostream.h>
#include "states.h"
#include "3dengine.h"

tunnel::tunnel()
{
	Name = "tunnel";

	Manager.load_map("data/tunnel.ase");
	Tunnel = Manager.Maps.back();
	Manager.load_map("data/kbox.ase");
	Box = Manager.Maps.back();
}

tunnel::~tunnel()
{
}

void tunnel::on_enter(void* Parameter)
{
	glDisable(GL_CULL_FACE);
}

void tunnel::on_leave()
{
}

void tunnel::display_func()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	float Time = sys_timer();

	glEnable(GL_TEXTURE_2D);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(90, 4.0 / 3.0, 10, 10000);

	bil::vector Pos = bil::vector(cos(Time * 0.8) * 20, sin(Time * 0.7) * 20, (Time - TIME(64.625)) / TIME(8) * 1500);
	bil::vector Tar = bil::vector(sin(Time * 0.68) * 20, cos(Time * 0.85) * 20, (Time - TIME(64.625))/ TIME(8) * 1500 + 1500);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(
		Pos.x, Pos.y, Pos.z,
		Tar.x, Tar.y, Tar.z,
		sin(sin(Time * 0.2) * 0.3), cos(sin(Time * 0.2) * 0.3), 0);
	
	for(size_t VertexIndex = 0; VertexIndex < Tunnel->VertexCount; VertexIndex++)
	{
		vertex& Vertex =  Tunnel->Vertices[VertexIndex];
	
		bil::vector Normal = bil::vector(Vertex.x, Vertex.y, Vertex.z).normalize();

		Vertex.u = sin(Normal.x * 3 * sin(Time * 0.29) + Normal.y * 3 * cos(Time * 0.45) + Normal.z * 3 * sin(Time * 0.19));
		Vertex.v = sin(Normal.x * 3 * sin(Time * 0.42) + Normal.y * 3 * cos(Time * 0.33) + Normal.z * 3 * cos(Time * 0.35) + Vertex.z / 10);
	}

	glColor4f(0.5, 0.25, 0.33, 0.45);
	glScalef(3, 3, 3);
	glEnable(GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);
	glDisable(GL_DEPTH_TEST);
	Tunnel->render();
	Tunnel->render();
	glEnable(GL_DEPTH_TEST);
	glDisable(GL_BLEND);

	glColor4f(1, 1, 1, 1);
	for(size_t x = 0; x < 20; x++)
	{
		float Angle = sin(x * 0.6 + sin(x * 0.3)) + x * x;
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		gluLookAt(
			Pos.x, Pos.y, Pos.z,
			Tar.x, Tar.y, Tar.z,
			sin(sin(Time * 0.2) * 0.3), cos(sin(Time * 0.2) * 0.3), 0);
		glTranslatef(sin(Angle) * 55, cos(Angle) * 55, 120 * x);
		//glRotatef(x / 10.0 * 3.14, sin(x * 0.7 + cos(Time * 1.3)), cos(x * 0.9 + sin(Time + x * 0.4)), sin(x * 0.5 + sin(Time * 0.7 + x * 0.3)));

		Box->render();
	}

	/*
	START_END(56.625, 57.625)
	{
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glDisable(GL_TEXTURE_2D);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);

		glColor4f(1, 1, 1, 1 - (Time - TIME(56.625)) / TIME(1));
		glBegin(GL_QUADS);
		glVertex3f(-1, -1, 0.5f);
		glVertex3f( 1, -1, 0.5f);
		glVertex3f( 1,  1, 0.5f);
		glVertex3f(-1,  1, 0.5f);
		glEnd();
	}
*/
	if(Time >= TIME(72.625))
		leave();
}

