#if defined(WIN32)
#define WIN32_LEAN_AND_MEAN
#include <windows.h>

static LARGE_INTEGER StartTime;
static LARGE_INTEGER PerformanceFrequency;
#elif defined(LINUX)
#include <sys/time.h>
#include <unistd.h>

struct timeval StartTime;
#endif


void sys_init()
{
#if defined(WIN32)
	QueryPerformanceFrequency(&PerformanceFrequency);
#endif
}

float sys_timer()
{
#if defined(WIN32)
	LARGE_INTEGER EndTime;

	if(!StartTime.QuadPart)
	{
		QueryPerformanceCounter(&StartTime);

		return 0;
	}
	else
	{
		QueryPerformanceCounter(&EndTime);

		return ((float) EndTime.QuadPart - StartTime.QuadPart) / PerformanceFrequency.QuadPart;
	}
#elif defined(LINUX)
	struct timeval EndTime;
	
	if(!StartTime.tv_sec)
	{
		gettimeofday(&StartTime, NULL);

		return 0;
	}
	else
	{
		gettimeofday(&EndTime, NULL);

		return (EndTime.tv_sec + EndTime.tv_usec / 1.0e6)
		     - (StartTime.tv_sec + StartTime.tv_usec / 1.0e6);
	}
#endif
}
