#include "3dengine.h"
#include "state.h"
#include "audio.h"

#define TIME(n) (n * 4 * (60 / 137.0f))

#define START_END(a, b) if((Time >= (60 / 137.0f) * a * 4) && (Time <  (60 / 137.0f) * b * 4))

#define END(n) if(Time <  (60 / 137.0f) * n * 4)

class intro : public state
{
private:
	image* Fadeout;
	image* Presents;
	image* Tsunami;

public:
	intro();
	~intro();

	void   on_enter(void* Parameter);
	void   on_leave();
	void   display_func();
};

class car_start : public state
{
private:	
	map*    City;
	map*    Car;
	image*  Environ;
	
public:
	car_start();
	~car_start();

	void   on_enter(void* Parameter);
	void   on_leave();
	void   display_func();
};

class space : public state
{
private:
	image*  Star;
	map*    Box;
	vertex* Vertices;

public:
	space();
	~space();

	void   on_enter(void* Parameter);
	void   on_leave();
	void   display_func();
};

class ball : public state
{
private:	
	map*    Ball;
	vertex* Vertices;
	
public:
	ball();
	~ball();

	void   on_enter(void* Parameter);
	void   on_leave();
	void   display_func();
};

class credits : public state
{
private:
	image*         Loop;
	image*         Silvert;

public:
	credits();
	~credits();

	void   on_enter(void* Parameter);
	void   on_leave();
	void   display_func();
};

class outro : public state
{
private:
	image*         Image;

public:
	outro();
	~outro();

	void   on_enter(void* Parameter);
	void   on_leave();
	void   display_func();
};

class torus : public state
{
private:	
	map*    Torus;
	
public:
	torus();
	~torus();

	void   on_enter(void* Parameter);
	void   on_leave();
	void   display_func();
};

class tunnel : public state
{
private:	
	map*    Tunnel;
	map*    Box;
	
public:
	tunnel();
	~tunnel();

	void   on_enter(void* Parameter);
	void   on_leave();
	void   display_func();
};

class flare : public state
{
private:	
	map*  S1, *S2;
	vertex* S1b;
	
public:
	flare();
	~flare();

	void   on_enter(void* Parameter);
	void   on_leave();
	void   display_func();
};

class chain : public state
{
private:	
	map*  Chain;
	map*  Ball;
	
public:
	chain();
	~chain();

	void   on_enter(void* Parameter);
	void   on_leave();
	void   display_func();
};

class all : public state
{
private:	
	map*  Ball;
	map*  Box;
	vertex* Vertices;	

public:
	all();
	~all();

	void   on_enter(void* Parameter);
	void   on_leave();
	void   display_func();
};

class demo : public state
{
private:
	audio::stream* Song;

	intro*         Intro;
	car_start*     CarStart;
	space*         Space;
	ball*          Ball;
	credits*       Credits;
	torus*         Torus;
	tunnel*        Tunnel;
	flare*         Flare;
	chain*         Chain;
	all*           All;
	outro*         Outro;

public:
	demo();
	~demo();

	void   on_enter(void* Parameter);
	void   on_leave();
	void   display_func();
};

