#include <stdlib.h>
#include <iostream.h>

#include <GL/gl.h>
#include <GL/glut.h>

#include "state.h"

static state* CurrentState;

static void i_idle_func() { CurrentState->idle_func(); }
static void i_display_func() { CurrentState->display_func(); glutSwapBuffers(); }
static void i_keyboard_func(unsigned char key, int x, int y) { CurrentState->keyboard_func(key, x, y); }
static void i_keyboard_special_func(int key, int x, int y) { CurrentState->keyboard_special_func(key, x, y); }

bool state::Exit = false;

state::state()
{
	Name = "(anonymous)";
}

void state::init()
{
	cerr << "INFO: state::init: Binding idle, display and keyboard functions..." << endl;

	glutIdleFunc(i_idle_func);
	glutDisplayFunc(i_display_func);
	glutKeyboardFunc(i_keyboard_func);
	glutSpecialFunc(i_keyboard_special_func);
}

void state::enter(state* State, void* Parameter)
{
	cerr << "INFO: state::enter: " << State->Name << "." << endl;

	if(State == NULL)
		exit(0);

	State->Parent = CurrentState;
	CurrentState = State;

	CurrentState->on_enter(Parameter);
}

void state::close()
{
	while(CurrentState->Parent)
		CurrentState->leave();
}

void state::idle_func()
{
	glutPostRedisplay();
}

void state::display_func()
{
	glutSwapBuffers();
}

void state::keyboard_func(unsigned char key, int x, int y)
{
	switch(key)
	{
	case 27:
		Exit = true;
		this->leave();
	}
}

void state::keyboard_special_func(int key, int x, int y)
{
}

void state::on_enter(void* Parameter)
{
}

void state::on_leave()
{
}

void state::leave()
{
	if(Exit)
	{
		if(this != CurrentState)
		{
			cerr << "BUG: this != CurrentState in state::leave." << endl;

			throw 0;
		}

		while(CurrentState)
		{
			cerr << "INFO: state::leave: " << CurrentState->Name << "." << endl;
			
			CurrentState->on_leave();

			CurrentState = CurrentState->Parent;
		}

		exit(0);
	}
	else
	{
		cerr << "INFO: state::leave: " << this->Name << "." << endl;

		this->on_leave();

		if(!(CurrentState = this->Parent))
			exit(0);
	}
}

