#include <esd.h>

int sndInit(size_t Rate, size_t SampleBits, size_t Channels)
{
	if(SampleBits != 8 && SampleBits != 16)
		return 1;

	if(Channels != 1 && Channels != 2)
		return 1;

	esd_audio_format = ((SampleBits == 8) ? ESD_BITS8 : ESD_BITS16)
	                 | ((Channels == 1) ? ESD_MONO : ESD_STEREO);
	esd_audio_rate = Rate;
	esd_audio_device = "/dev/dsp"; /* XXX */

	esd_audio_open();

	return 0;
}

int sndWrite(void* Data, size_t Length)
{
	esd_audio_write(Data, Length);
	/* esd_audio_flush(); */
	
	return 0;
}

void sndClose()
{
	esd_audio_close();
}

