#ifndef _MODEL_H_
#define _MODEL_H_

#include <string>
#include <stdlib.h>

#include "matrix.h"
#include "vector.h"
#include "texture.h"

class color
{
public:
	float          r, g, b;
};

class face
{
public:
	size_t         VertexIndex[3];
};

class model
{
public:
	model();
	~model();

	string    Name;

	size_t         FaceCount;
	face*          Faces;
	bil::vector*        FaceNormals;

	size_t         TextureFaceCount;
	face*          TextureFaces;

	size_t         VertexCount;
	bil::vector*        Vertexes;
	bil::vector*        VertexNormals;

	size_t         TextureCoordCount;
	texture_coord* TextureCoords;

	size_t         MaterialIndex;

	matrix         Matrix;

	void*          Owner;
	model*         Parent;

	void           render(texture_manager& TextureManager);
};

#endif

