#ifndef _MATRIX_H_
#define _MATRIX_H_

#include <stdlib.h>
#include <math.h>

class matrix
{
private:	
	float v[4][4];

public:
	matrix() { identity(); }
	~matrix() { }

	float& operator()(size_t a, size_t b)
	{
		return v[a][b];
	}

	matrix operator*(matrix m)
	{
		matrix t;

		for(size_t a = 0; a < 4; a++)
			for(size_t b = 0; b < 4; b++)
			{
				t(a, b) = 0;
				
				for(size_t c = 0; c < 4; c++)
					t(a, b) += (*this)(a, c) * m(c, b);
			}

		return t;
	}

	matrix& operator*=(matrix m)
	{
		*this = m * *this;

		return *this;
	}

	matrix& identity()
	{
		for(size_t a = 0; a < 4; a++)
			for(size_t b = 0; b < 4; b++)
				v[a][b] = (a == b) ? 1.0f : 0.0f;

		return *this;
	}

	template<class vector_class>
	matrix& rotate(vector_class Axis, float Angle)
	{
		float sa = sin(Angle);
		float ca = cos(Angle);
		float dx = Axis.x / Axis.magnitude();
		float dy = Axis.y / Axis.magnitude();
		float dz = Axis.z / Axis.magnitude();

		matrix m;

		m(0, 0) = ca + (1 - ca) * dx * dx;
		m(0, 1) =      (1 - ca) * dx * dy - sa * dz;
		m(0, 2) =      (1 - ca) * dx * dz + sa * dy;
		m(1, 0) =      (1 - ca) * dy * dx + sa * dz;
		m(1, 1) = ca + (1 - ca) * dy * dy;
		m(1, 2) =      (1 - ca) * dy * dz - sa * dx;
		m(2, 0) =      (1 - ca) * dz * dx - sa * dy;
		m(2, 1) =      (1 - ca) * dz * dy + sa * dx;
		m(2, 2) = ca + (1 - ca) * dz * dz;

		return (*this *= m);
	}
	
	matrix& scale(float x, float y, float z)
	{
		matrix m;
		
		m(0, 0) = x;
		m(1, 1) = y;
		m(2, 2) = z;

		return (*this *= m);
	}

	matrix& translate(float x, float y, float z)
	{
		matrix m;
		
		m(0, 3) = x;
		m(1, 3) = y;
		m(2, 3) = z;

		return (*this *= m);
	}
};

#endif

