#include <math.h>
#include <iostream.h>
#include "states.h"
#include "3dengine.h"
#include "audio.h"

intro::intro()
{
	Name = "intro";

	Manager.load_image("data/fadeout.png");
	Fadeout = Manager.Images.back();
	Manager.load_image("data/presents.png");
	Presents = Manager.Images.back();
	Manager.load_image("data/tsunami.png");
	Tsunami = Manager.Images.back();
}

intro::~intro()
{
}

void intro::on_enter(void* Parameter)
{
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_CULL_FACE);

	/*
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
*/
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);
	glColor4f(0.2, 0.5, 1, 1.0f);
}

void intro::on_leave()
{
}

void intro::display_func()
{
	glClear(GL_COLOR_BUFFER_BIT);

	float Time = sys_timer();

	END(3)
	{
		image::set(0, Fadeout);
		Fadeout->draw(
			-0.5f * ((Time - TIME(0)) / 5 + 1.0) , 0.13f * ((Time - TIME(0)) / 5 + 1.0),
			0.5f * ((Time - TIME(0)) / 5 + 1.0), -0.13f * ((Time - TIME(0)) / 5 + 1.0));
		Fadeout->draw(
			-0.5f * ((Time - TIME(0)) / 5 + 0.95) , 0.13f * ((Time - TIME(0)) / 5 + 0.95),
			0.5f * ((Time - TIME(0)) / 5 + 0.95), -0.13f * ((Time - TIME(0)) / 5 + 0.95));
		Fadeout->draw(
			-0.5f * ((Time - TIME(0)) / 5 + 0.9) , 0.13f * ((Time - TIME(0)) / 5 + 0.9),
			0.5f * ((Time - TIME(0)) / 5 + 0.9), -0.13f * ((Time - TIME(0)) / 5 + 0.9));
	}		
	else END(6)
	{
		image::set(0, Presents);
		Presents->draw(
			-0.5f * ((Time - TIME(3)) / 5 + 1.0) , 0.13f * ((Time - TIME(3)) / 5 + 1.0),
			0.5f * ((Time - TIME(3)) / 5 + 1.0), -0.13f * ((Time - TIME(3)) / 5 + 1.0));
		Presents->draw(
			-0.5f * ((Time - TIME(3)) / 5 + 0.95) , 0.13f * ((Time - TIME(3)) / 5 + 0.95),
			0.5f * ((Time - TIME(3)) / 5 + 0.95), -0.13f * ((Time - TIME(3)) / 5 + 0.95));
		Presents->draw(
			-0.5f * ((Time - TIME(3)) / 5 + 0.9) , 0.13f * ((Time - TIME(3)) / 5 + 0.9),
			0.5f * ((Time - TIME(3)) / 5 + 0.9), -0.13f * ((Time - TIME(3)) / 5 + 0.9));
	}		
	else END(8)
	{
		image::set(0, Tsunami);
		Tsunami->draw(
			-0.5f * ((Time - TIME(6)) / 5 + 1.0) , 0.13f * ((Time - TIME(6)) / 5 + 1.0),
			0.5f * ((Time - TIME(6)) / 5 + 1.0), -0.13f * ((Time - TIME(6)) / 5 + 1.0));
		Tsunami->draw(
			-0.5f * ((Time - TIME(6)) / 5 + 0.95) , 0.13f * ((Time - TIME(6)) / 5 + 0.95),
			0.5f * ((Time - TIME(6)) / 5 + 0.95), -0.13f * ((Time - TIME(6)) / 5 + 0.95));
		Tsunami->draw(
			-0.5f * ((Time - TIME(6)) / 5 + 0.9) , 0.13f * ((Time - TIME(6)) / 5 + 0.9),
			0.5f * ((Time - TIME(6)) / 5 + 0.9), -0.13f * ((Time - TIME(6)) / 5 + 0.9));
	}
	else
		this->leave();
}

