//
// "Universal" import structures by Morten Hustveit
//
// Any memory allocated, will be automatically deleted
//

#ifndef _IMPORT_H_
#define _IMPORT_H_

#include <stdlib.h>
#include <vector>
#include <string>

#define IMPORT_VERTICES         0x00000001l
#define IMPORT_COLORMAP_COORDS  0x00000002l
#define IMPORT_LIGHTMAP_COORDS  0x00000004l
#define IMPORT_COLORS           0x00000008l
#define IMPORT_FACES            0x00000010l
#define IMPORT_MATERIALS        0x00000020l // Mutually exclusive with IMPORT_COLORMAPS
#define IMPORT_COLORMAPS        0x00000040l // Mutually exclusive with IMPORT_MATERIALS
#define IMPORT_LIGHTMAPS        0x00000080l
#define IMPORT_TEXTURE_FACES    0x00000100l

class i_vector
{
public:
	float x, y, z;
};

class i_map_coord
{
public:
	float u, v;
};

class i_face
{
public:
	size_t* Indices;
	size_t  IndexCount;
	size_t  MaterialIndex;
	size_t  ColormapIndex;
	size_t  LightmapIndex;

	i_face()
	{
		Indices = NULL;
	}

	~i_face()
	{
		//if(Indices)
	//		delete [] Indices;
	}
};

class i_image
{
public:
	char*  Data;
	size_t Width;
	size_t Height;

	i_image()
	{
		Data = NULL;
	}

	~i_image()
	{
		//if(Data)
	//		delete [] Data;
	}
};

class i_material
{
public:
	size_t                         Index;
	string                    Colormap;        // File name

	void*                          Reserved;
};

class import
{
public:
	size_t                         Fields;

	std::vector<i_vector>          Vertices;
	std::vector<i_vector>          VertexNormals;
	std::vector<i_map_coord>       ColormapCoords;
	std::vector<i_map_coord>       LightmapCoords;
	std::vector<i_face>            Faces;
	std::vector<i_face>            TextureFaces;
	std::vector<i_vector>          FaceNormals;
	std::vector<i_image>           Colormaps;
	std::vector<i_image>           Lightmaps;
	std::vector<i_image>           Images;
	std::vector<i_material>        Materials;
};

extern import*  ase_load(const char* FileName);
extern i_image* png_load(const char* FileName);

#endif
