#include <GL/gl.h>
#include <GL/glu.h>
#include "3dengine.h"

GLuint image::CurrentTexture[32];

void image::load(const char* FileName)
{
	i_image* ImportImage = png_load(FileName);

	load(*ImportImage);

	delete ImportImage;
}

void image::load(i_image& ImportImage)
{
	static GLuint NextTexture = 1;

	TextureIndex = NextTexture++;
/*
	glActiveTexture(GL_TEXTURE0);
*/
	glBindTexture(GL_TEXTURE_2D, TextureIndex);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST_MIPMAP_NEAREST);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_NEAREST);

	gluBuild2DMipmaps(GL_TEXTURE_2D, 3, ImportImage.Width, ImportImage.Height, GL_RGB, GL_UNSIGNED_BYTE, ImportImage.Data);
}
