#include <math.h>
#include <iostream.h>
#include "states.h"
#include "3dengine.h"

flare::flare()
{
	Name = "flare";

	Manager.load_map("data/s1.ase");
	S1 = Manager.Maps.back();
	Manager.load_map("data/s2.ase");
	S2 = Manager.Maps.back();

	S1b = new vertex[S1->VertexCount];
	memcpy(S1b, S1->Vertices, sizeof(vertex) * S1->VertexCount);
}

flare::~flare()
{
	delete [] S1b;
}

void flare::on_enter(void* Parameter)
{
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
	glDisable(GL_CULL_FACE);
	glEnable(GL_DEPTH_TEST);
}

void flare::on_leave()
{
}

void flare::display_func()
{
	float Time = sys_timer();

	if(Time >= TIME(81))
		leave();

	float BTime = (Time / TIME(1) * 4);
	float BTime2 = (Time / TIME(1)) * 6.28;
	

	glClearColor(0.5 - fmod(BTime, 1) * 0.5, 0.25 - fmod(BTime, 1) * 0.25, 1 - fmod(BTime, 1), 0);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glClearColor(0, 0, 0, 0);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(90, 4.0 / 3.0, 10, 10000);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(sin(Time * 5) * 200, sin(Time * 4 + sin(Time * 2)) * 50 + 20, cos(Time * 5) * -200, 0, 0, 0, 0, 1, 0);


	for(size_t i = 0; i < S1->VertexCount; i++)
	{
		S1->Vertices[i].x = pow(sin(BTime2), 2) * S1b[i].x + pow(cos(BTime2), 2) * S2->Vertices[i].x;
		S1->Vertices[i].y = pow(sin(BTime2), 2) * S1b[i].y + pow(cos(BTime2), 2) * S2->Vertices[i].y;
		S1->Vertices[i].z = pow(sin(BTime2), 2) * S1b[i].z + pow(cos(BTime2), 2) * S2->Vertices[i].z;
	}
			
	glColor3f(1, 0, 0);
	S1->render();

	END(74)
	{
		glColor4f(1, 1, 1, 1 - (Time - TIME(73)) / TIME(1));
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		glBegin(GL_QUADS);
		glVertex3f(-1, -1, 0.5f);
		glVertex3f( 1, -1, 0.5f);
		glVertex3f( 1,  1, 0.5f);
		glVertex3f(-1,  1, 0.5f);
		glEnd();
	}
}

