#include <stdio.h>
#include <fstream.h>
#include <iostream.h>
#include <algorithm>

#include "audio.h"
#include "sound.h"

namespace audio
{
	template<class T>
	T min(T a, T b)
	{
		return (a < b) ? a : b;
	}

	enum mad_flow input(void* Data, struct mad_stream* MadStream)
	{
		stream* Stream = (stream*) Data;

		if(Stream->BufferPos < Stream->BufferSize)
		{
			mad_stream_buffer(MadStream,
				(unsigned char*) Stream->Buffer, Stream->BufferSize);
			Stream->BufferPos += Stream->BufferSize;
		}
		else
			return MAD_FLOW_STOP;

		return MAD_FLOW_CONTINUE;
	}

	static signed short scale(mad_fixed_t Sample)
	{
		Sample += (1L << (MAD_F_FRACBITS - 16));
		if(Sample >= MAD_F_ONE)
			Sample = MAD_F_ONE - 1;
		else if(Sample < - MAD_F_ONE)
			Sample = -MAD_F_ONE;

		return Sample >> (MAD_F_FRACBITS + 1 - 16);
	}

	static short buf[16384]; // incredibly lame

	enum mad_flow output(void* Data, const struct mad_header* Header,
		struct mad_pcm* PCM)
	{
		// stream* Stream = (stream*) Data;

		unsigned int ChannelCount, SampleCount;
		mad_fixed_t const *Left, *Right;

		ChannelCount = MAD_NCHANNELS(Header);
		SampleCount = PCM->length;
		Left = PCM->samples[0];
		Right = PCM->samples[1];
	
		short* ptr = buf;
		
		size_t Size = SampleCount * 4;

		if(Size > sizeof(buf))
		{
			cerr << "ERROR: audio::stream: Too small static buffer in 'output'." << endl;
			throw 0;
		}
		
		while(SampleCount--)
		{
			*ptr++ = scale(*Left++);
			*ptr++ = scale(*Right++);
		}
		
		sndWrite(buf, Size);

		return MAD_FLOW_CONTINUE;
	}

	enum mad_flow error(void* Data, struct mad_stream* MadStream,
		struct mad_frame* Frame)
	{
		// stream* Stream = (stream*) Data;

		switch(MadStream->error)
		{
		case MAD_ERROR_LOSTSYNC:
			cerr << "WARNING: audio::stream: Decode error: Lost synchronization." << endl;
			break;
		case MAD_ERROR_BADDATAPTR:
			cerr << "WARNING: audio::stream: Decode error: Bad data pointer." << endl;
			break;
		default:
			cerr << "WARNING: audio::stream: Decode error: " << MadStream->error << "." << endl;
		}

		return MAD_FLOW_CONTINUE;
	}

	stream::stream(const char* FileName)
	{
		ifstream Input(FileName);
		
		Input.seekg(0, ios::end);

		BufferSize = streamoff(Input.tellg());
		BufferPos = 0;
		Buffer = new char[BufferSize];

		Input.seekg(0, ios::beg);
		
		cerr << "INFO: audio::stream: Loading '" << FileName << "'..." << endl;

		Input.read(Buffer, BufferSize);

		mad_decoder_init(&Decoder, this,
			input,
			NULL, // header
			NULL, // filter
			output,
			error,
			NULL); // message

		sndInit(44100, 16, 2);
	}

	stream::~stream()
	{
		sndClose();

		mad_decoder_finish(&Decoder);

		delete [] Buffer;
	}

	void stream::play()
	{
		mad_decoder_run(&Decoder, MAD_DECODER_MODE_ASYNC);
	}
};

