#include <math.h>
#include <iostream.h>
#include "states.h"
#include "3dengine.h"

all::all()
{
	Name = "all";

	Manager.load_map("data/ball.ase");
	Ball = Manager.Maps.back();
	Manager.load_map("data/box.ase");
	Box = Manager.Maps.back();
	Vertices = new vertex[Box->VertexCount];
	memcpy(Vertices, Box->Vertices, Box->VertexCount * sizeof(vertex));

}

all::~all()
{
}

void all::on_enter(void* Parameter)
{
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_CULL_FACE);
	glDisable(GL_DEPTH_TEST);
}

void all::on_leave()
{
}

void all::display_func()
{
	float Time = sys_timer() - TIME(89);

	if(Time >= TIME(16))
		leave();

	glClear(GL_COLOR_BUFFER_BIT);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(90, 4.0 / 3.0, 10, 10000);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	bil::vector Pos = bil::vector(cos(Time) + 0.1, sin(Time * 1.1), sin(Time * 0.9));
	Pos.normalize();
	Pos *= 250;
	gluLookAt(Pos.x, Pos.y, Pos.z, 0, 0, 0, 0, 1, 0);


	END(16)
	{
		for(size_t VertexIndex = 0; VertexIndex < Box->VertexCount; VertexIndex++)
		{
			float Angle = 0.3 * cos(Vertices[VertexIndex].x / 100 + Time * 9);
			float x, y, z;
			x = Vertices[VertexIndex].x * cos(Angle)
			  + Vertices[VertexIndex].y * sin(Angle);
			y = Vertices[VertexIndex].y * cos(Angle)
			  - Vertices[VertexIndex].x * sin(Angle);
			z = Vertices[VertexIndex].z;

			Angle = 0.3 * cos(Vertices[VertexIndex].y / 100 * Time * 7);
			Box->Vertices[VertexIndex].x = x;
			Box->Vertices[VertexIndex].y = cos(Angle) * y + sin(Angle) * z;
			Box->Vertices[VertexIndex].z = cos(Angle) * z - sin(Angle) * y;
		}
		glColor4f(0.5, 0.25, 1.0, 0.5);
		Box->render();
		glMatrixMode(GL_MODELVIEW);
		glScaled(1.1, 1.1, 1.1);
		glColor4f(1, 0.5, 0.25, 0.5);
		Box->render();

		for(size_t VertexIndex = 0; VertexIndex < Ball->VertexCount; VertexIndex++)
		{
			vertex& Vertex = Ball->Vertices[VertexIndex];

			bil::vector Normal = bil::vector(Vertex.x, Vertex.y, Vertex.z).normalize();

			Vertex.u = sin(Normal.x * 3 * sin(Time * 0.29) + Normal.y * 3 * cos(Time * 0.45) + Normal.z * 3 * sin(Time * 0.19));
			Vertex.v = sin(Normal.x * 3 * sin(Time * 0.42) + Normal.y * 3 * cos(Time * 0.33) + Normal.z * 3 * cos(Time * 0.35));
		}
		glScaled(10, 10, 10);
		Ball->render();
		glScaled(10, 10, 10);
		Ball->render();
	}
	else
		leave();

	glRotatef(90, 0, 0, 1);
	glColor4f(0.5, 0.25, 1, 0.5f);

	END(1)
	{
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		glBegin(GL_QUADS);
		glVertex3f(-1, -1, 0.5f);
		glVertex3f( 1, -1, 0.5f);
		glVertex3f( 1,  1, 0.5f);
		glVertex3f(-1,  1, 0.5f);
		glEnd();
	}
}

