#define HAS_SINTAB
#include "pwpdemo.h"

#ifdef USE_SINTAB
signed int sintab16[256]={
0, 804, 1607, 2410, 3211, 4011, 4807, 5601, 6392, 7179, 7961, 8739,
9511, 10278, 11038, 11792, 12539, 13278, 14009, 14732, 15446, 16150,
16845, 17530, 18204, 18867, 19519, 20159, 20787, 21402, 22004, 22594,
23169, 23731, 24278, 24811, 25329, 25831, 26318, 26789, 27244, 27683,
28105, 28510, 28897, 29268, 29621, 29955, 30272, 30571, 30851, 31113,
31356, 31580, 31785, 31970, 32137, 32284, 32412, 32520, 32609, 32678,
32727, 32757, 32767, 32757, 32727, 32678, 32609, 32520, 32412, 32284,
32137, 31970, 31785, 31580, 31356, 31113, 30851, 30571, 30272, 29955,
29621, 29268, 28897, 28510, 28105, 27683, 27244, 26789, 26318, 25831,
25329, 24811, 24278, 23731, 23169, 22594, 22004, 21402, 20787, 20159,
19519, 18867, 18204, 17530, 16845, 16150, 15446, 14732, 14009, 13278,
12539, 11792, 11038, 10278, 9511, 8739, 7961, 7179, 6392, 5601, 4807,
4011, 3211, 2410, 1607, 804, 0, -805, -1608, -2411, -3212 ,-4012, -4808,
-5602, -6393, -7180, -7962, -8740, -9512, -10279, -11039, -11793,
-12540, -13279, -14010, -14733, -15447, -16151, -16846, -17531, -18205,
-18868, -19520, -20160, -20788, -21403, -22005, -22595, -23170, -23732,
-24279, -24812, -25330, -25832, -26319, -26790, -27245, -27684, -28106,
-28511, -28898, -29269, -29622, -29956, -30273, -30572, -30852, -31114,
-31357, -31581, -31786, -31971, -32138, -32285, -32413, -32521, -32610,
-32679, -32728, -32758, -32767, -32758, -32728, -32679, -32610, -32521,
-32413, -32285, -32138, -31971, -31786, -31581, -31357, -31114, -30852,
-30572, -30273, -29956, -29622, -29269, -28898, -28511, -28106, -27684,
-27245, -26790, -26319, -25832, -25330, -24812, -24279, -23732, -23170,
-22595, -22005, -21403, -20788, -20160, -19520, -18868, -18205, -17531,
-16846, -16151, -15447, -14733, -14010, -13279, -12540, -11793, -11039,
-10279, -9512, -8740, -7962, -7180, -6393, -5602, -4808, -4012, -3212,
-2411, -1608, -805 };
#endif

u8 psychtab0[64]=
{
  0x00,0x00,0x01,0x01,0x10,0x10,0x11,0x11,0x13,0x13,0x31,0x31,0x33,0x33,
  0x3b,0x3b,0xb3,0xbb,0xbf,0xfb,0xff,0xfb,0xbb,0xb3,0x3b,0x33,0x31,0x13,
  0x11,0x10,0x01,0x00,0x00,0x01,0x01,0x10,0x10,0x11,0x11,0x19,0x19,0x91,
  0x91,0x91,0x99,0x99,0x99,0x99,0x91,0x91,0x91,0x19,0x19,0x11,0x11,0x10,
  0x10,0x01,0x01,0x00,0x00,0x00,0x01
};

/*
u8 psychtab0[64]=
{
  0x00,0x00,0x00,0x04,0x04,0x40,0x40,0x44,0x44,0x4c,0xc4,0xc4,0xcc,0xcc,
  0xca,0xac,0xfa,0xef,0xec,0xce,0xcc,0xc4,0x4c,0x44,0x40,0x04,0x00,0x00,
  0x00,0x04,0x06,0x60,0x66,0x6e,0xe6,0xee,0xef,0xfe,0xaf,0xfa,0xaa,0xea,
  0xee,0xea,0xae,0xaa,0xa3,0x3a,0x33,0x32,0x23,0x22,0x20,0x02,0x08,0x00,
  
  0x08,0x07,0x77,0x78,0x08,0x00,0x01
};
*/

u8 psychtab1[64]=
{
  0x04,0x06,0x0e,0x6e,0xe6,0xee,0xe6,0x6e,0x60,0x06,0x00,0x01,0x10,0x15,
  0x51,0x55,0x5d,0xd5,0xdd,0xd5,0x5d,0x55,0x51,0x15,0x11,0x1e,0xe1,0xee,
  0xef,0xfe,0xff,0xfe,0xef,0xee,0xea,0xae,0xaa,0xa2,0x2a,0x20,0x02,0x00,
  0x00,0x02,0x20,0x22,0x2e,0xe2,0xee,0xea,0xaa,0xa2,0x2a,0x20,0x02,0x01,
  0x03,0x30,0x31,0x35,0x53,0x50,0x05
};

u8 psychtab2[64]=
{
  0x00,0x08,0x07,0x87,0x78,0x87,0x88,0x07,0x08,0x08,0x00,0x00,0x00,0x00,
  0x01,0x03,0x30,0x33,0x03,0x03,0x01,0x09,0x19,0x19,0x91,0x91,0x99,0x99,
  0x9c,0x99,0x91,0x19,0x1c,0x13,0x31,0x33,0x31,0x03,0x03,0x00,0x00,0x00,
  0x04,0x40,0x44,0x04,0x04,0x04,0x00,0x04,0x40,0x4e,0x40,0x04,0x00,0x04,
  0x05,0x05,0x04,0x04,0x00,0x00,0x00
};

void planes_draw(u8*map,int angle,int midpt)
{
   register u8*d=pwplib_buf;

   register int x;

   register int du=(SIN(angle)*MIN(pwplib_bufw,pwplib_bufh))/4096;

   int dv=(COS(angle)*pwplib_bufh)/6666;

   register int i=midpt*256-(pwplib_bufh>>1)*dv
                  -(pwplib_bufw>>1)*du;

   int y=pwplib_bufh;

   dv-=du*pwplib_bufw;

   for(;y;y--)
   {
      for(x=pwplib_bufw;x;x--)
      {
         *d++=map[(i>>8)&255];
         i+=du;
      }
      i+=dv;
   }
}

void xorplanes_draw(u8*map,int angle,int angle2,int midpt,int midpt2)
{
   register u8*d=pwplib_buf;

   register int x;

   register int du=(SIN(angle)*MIN(pwplib_bufw,pwplib_bufh))/4096,
                du2=(SIN(angle2)*MIN(pwplib_bufw,pwplib_bufh))/4096;

   int dv=(COS(angle)*pwplib_bufh)/6666,
       dv2=(COS(angle2)*pwplib_bufh)/6666;

   register int i=midpt*256-(pwplib_bufh>>1)*dv
                  -(pwplib_bufw>>1)*du,
                j=midpt2*256-(pwplib_bufh>>1)*dv2
                  -(pwplib_bufw>>1)*du2;

   int y=pwplib_bufh;

   for(;y;y--)
   {
      int ii=i,jj=j;
      for(x=pwplib_bufw;x;x--)
      {
         *d++=map[(ii>>8)&255]^map[(jj>>8)&255];
         ii+=du;jj+=du2;
      }
      i+=dv;j+=dv2;
   }
}


void planes_do(int t,int m)
{
   u8*tabbu[3]={psychtab0,psychtab1,psychtab2};
   u8 map[256];
   u8*tabu=tabbu[m&15];

   int step=1024,i,j=-t*80;

   for(i=0;i<128;i++)
   {
      map[i]=map[255-i]=tabu[(j>>8)&63];
      j+=step;

      step-=(step>>4);
   }

   if(m&16)
   planes_draw(map,t*3,SIN(t)/512);else
   xorplanes_draw(map,t,t*3/11,
     SIN(t)/512,
     SIN(((long int)t*(608/16))/(1024*16)) );
}

