import java.applet.*;
import java.awt.*;
import java.awt.event.*;

public class Sinus3 extends Applet implements Runnable, KeyListener
{
	Image osi;
	Graphics osi_g;
	int antal = 128, k, xtilt, xstart = 10, table = 0, lsd = 0;
	double[] y = new double[128], x = new double[128], y2 = new double[128];
	boolean leftDown= false, rightDown= false, upDown= false, downDown= false;

	public void init()
	{
		osi = createImage( 640,480);
		osi_g = osi.getGraphics();
		for( int i = 0; i < 450; i += 10)
			x[(i/10)] = i;
		sinus();
		addKeyListener( this);
		requestFocus();
	}

	public void paint( Graphics g)
	{
		osi_g.setColor( Color.black);
		osi_g.fillRect( 0,0, 640,480);
		osi_g.setColor( Color.white);
		xtilt= xstart;
		table= 0;
		for( int ytilt = 0; ytilt < 80; ytilt += 6)
		{
			for( int i = 0; i < 50; i++)
			{	
				osi_g.fillOval((int)x[i] + xtilt, (int)(y[i] + ytilt + y2[table] + 200), 4, 4);
			}
			xtilt += 6;
			table++;
		}
		g.drawImage( osi, 0, 0, this);
	}
	
	public void start()
	{
		Thread ny= new Thread( this);
		ny.start();
	}
	
	public void update( Graphics g)
	{
	paint( g);
	}
	
	void sinus()
	{
		table = 0;
		for( int i = 0; i < antal; i++)
		{
			y2[i] = (k*Math.sin(0.05*x[i]));
		}
		
		for( int i = 0; i < antal; i++)
		{
			y[i] = (k*Math.sin(0.05 * x[i]));
		}
	}
		
	public void run()
	{
		while ( true)
		{
			k= 20;
			while (k >= -20)
			{
				k--;
				sinus();
			
				repaint();
		
				if( leftDown) xstart -= 1;
				if( rightDown) xstart += 1;
		
				try{ Thread.sleep( 100);} catch( InterruptedException ie) {}
			}
			
			k= -20;
			while (k <= 20)
			{
				k++;
				sinus();
			
				repaint();
		
				try{ Thread.sleep( 100);} catch( InterruptedException ie) {}
			}
		}
	}
	
	public void keyTyped( KeyEvent ke) {}
	
	public void keyPressed( KeyEvent ke)
	{
		if( ke.getKeyCode() == KeyEvent.VK_LEFT) 	leftDown= 	true;
		if( ke.getKeyCode() == KeyEvent.VK_RIGHT) rightDown= 	true;
		if( ke.getKeyCode() == KeyEvent.VK_UP) 		upDown= 		true;
		if( ke.getKeyCode() == KeyEvent.VK_DOWN) 	downDown= 	true;
	}
	
	public void keyReleased( KeyEvent ke)
	{
		if( ke.getKeyCode() == KeyEvent.VK_LEFT) 	leftDown= 	false;
		if( ke.getKeyCode() == KeyEvent.VK_RIGHT) rightDown= 	false;
		if( ke.getKeyCode() == KeyEvent.VK_UP) 		upDown= 		false;
		if( ke.getKeyCode() == KeyEvent.VK_DOWN) 	downDown= 	false;
	}
}
