import java.applet.*;
import java.awt.*;
import java.awt.event.*;

public class KeyApp5 extends Applet implements Runnable, KeyListener
{
	int RADIE=20, width= 400, height= 400;
	double bilx=200, bily=200;
	double vx=2, vy=2;
	double targetx = RADIE+(width-2*RADIE)*Math.random(), targety= RADIE+(height-2*RADIE)*Math.random();
	boolean leftDown= false, rightDown= false, upDown= false, downDown= false;

	public void init()
	{
		addKeyListener( this);
		requestFocus();
	}

	public void paint( Graphics g)
	{
		g.setColor( Color.white);
		g.fillOval( (int)(bilx-RADIE), (int)(bily-RADIE), 2*RADIE, 2*RADIE);
		g.fillOval( (int)(targetx-RADIE), (int)(targety-RADIE), 2*RADIE, 2*RADIE);
	}
	
	public void start()
	{
		Thread ny= new Thread( this);
		ny.start();
	}
	
	public void run()
	{
		while( true)
		{
			double dx= targetx- bilx;
			double dy= targety- bily;
			double distSqr= dx*dx + dy*dy;
			if( distSqr < 4*RADIE*RADIE)
			{
				targetx= RADIE+(width-2*RADIE)*Math.random();
				targety= RADIE+(height-2*RADIE)*Math.random();
			}
		
			if( leftDown) 	bilx -= vx;
			if( rightDown) bilx += vx;
			if( upDown) 	bily -= vy;
			if( downDown) 	bily += vy;
		
			repaint();
				
			try{ Thread.sleep( 10);} catch( InterruptedException ie) {}
		}
	}
	
	public void keyTyped( KeyEvent ke) {}
	
	public void keyPressed( KeyEvent ke)
	{
		if( ke.getKeyCode() == KeyEvent.VK_LEFT) 	leftDown= 	true;
		if( ke.getKeyCode() == KeyEvent.VK_RIGHT) rightDown= 	true;
		if( ke.getKeyCode() == KeyEvent.VK_UP) 	upDown= 		true;
		if( ke.getKeyCode() == KeyEvent.VK_DOWN) 	downDown= 	true;
	}
	
	public void keyReleased( KeyEvent ke)
	{
		if( ke.getKeyCode() == KeyEvent.VK_LEFT) 	leftDown= 	false;
		if( ke.getKeyCode() == KeyEvent.VK_RIGHT) rightDown= 	false;
		if( ke.getKeyCode() == KeyEvent.VK_UP) 	upDown= 		false;
		if( ke.getKeyCode() == KeyEvent.VK_DOWN) 	downDown= 	false;
	}
}
