#include <windows.h>

/* We use DirectInput 5 */
#ifndef DIRECTINPUT_VERSION
#define DIRECTINPUT_VERSION	0x0500
#endif
#include <dinput.h>

#include "ll.h"			/* Also includes gl.h */

/* Used to handle things windows send to our window. */
LRESULT CALLBACK wndProc(HWND windowH, UINT msg, WPARAM wParam, LPARAM lParam);

HDC dc;				/* Device Context */
HGLRC rc;			/* Rendering Context */
HWND windowH;		/* Window Handle */
HINSTANCE instance;	/* Instance Handle */

LPDIRECTINPUT directI;			/* DirectInput object. */
LPDIRECTINPUTDEVICE KBDevice;	/* Device attached to SYS Keyboard. */
unsigned char *llKeyTable;		/* Will hold state of keys. */

/* Some info we need about the window. */
int winWidth,winHeight,winXPos,winYPos,winFullscreen;

short int mouseX,mouseY,mouseHomeX,mouseHomeY;
unsigned char mouseButtons, oldMouseButtons;
LPDIRECTINPUTDEVICE mouseDevice;	/* Device attached to SYS Mouse. */

#define MOUSE_INPUT_BUFFER_SIZE		16

/* Prepare for keyboard handling. Return 1 on OK. 0 on error.*/
int setupLL(){

	/* Descriptoion of buffered mouse input. It look cryptic i know! 
	   Look in MSDN if you want (doubt it) to know how it works. */
	DIPROPDWORD dipw={{sizeof(DIPROPDWORD),sizeof(DIPROPHEADER),0,DIPH_DEVICE},MOUSE_INPUT_BUFFER_SIZE};

	llKeyTable=NULL;
	/* Direct Input stuff. */
	if(DirectInputCreate(instance,DIRECTINPUT_VERSION,&directI,NULL)!=DI_OK){
		return LL_ERROR;
	}

	/* Keyboard */
	if(directI->CreateDevice(GUID_SysKeyboard,&KBDevice,NULL)!=DI_OK){
		return LL_ERROR;
	}
	if(KBDevice->SetDataFormat(&c_dfDIKeyboard)!=DI_OK){
		return LL_ERROR;
	}
	if(KBDevice->SetCooperativeLevel(windowH,DISCL_BACKGROUND | DISCL_NONEXCLUSIVE)){
		return LL_ERROR;
	}
	if(KBDevice->Acquire()!=DI_OK){
		return LL_ERROR;
	}

	/* An array storing status on all keys. */
	llKeyTable=(unsigned char *)malloc(256);
	if(llKeyTable==NULL){
		return LL_ERROR;
	}

	/* Prepare bufferd input from mouse using DirectInput. */
	if(directI->CreateDevice(GUID_SysMouse,&mouseDevice,NULL)!=DI_OK){
		return LL_ERROR;
	}
	if(mouseDevice->SetDataFormat(&c_dfDIMouse)!=DI_OK){
		return LL_ERROR;
	}
	if(mouseDevice->SetCooperativeLevel(windowH,DISCL_FOREGROUND | DISCL_NONEXCLUSIVE)!=DI_OK){
		return LL_ERROR;
	}

	/* WARNING. DI_OK is not the only thing returned for success. */
	if(mouseDevice->SetProperty(DIPROP_BUFFERSIZE,&dipw.diph)!=DI_OK){
		return LL_ERROR;
	}
	if(mouseDevice->Acquire()!=DI_OK){
		return LL_ERROR;
	}

	/* Zero mouse stats! */
	mouseHomeX=mouseHomeY=-1;
	mouseX=(winWidth>>1)+1;
	mouseY=(winHeight>>1);
	oldMouseButtons=mouseButtons=0;

	return LL_OK;
}

/* Here we'll try to free things we got in setupLL(). */
void freeLL(){

	/* Get ridth of KB handler. */
	if(KBDevice){
		KBDevice->Unacquire();
		KBDevice->Release();
	}
	/* Get ridth of mouse device. */
	if(mouseDevice!=NULL){
		mouseDevice->Unacquire();
		mouseDevice->Release();
	}

	if(directI)directI->Release();
	if(llKeyTable)free(llKeyTable);
}

/* 0==ERROR */
int llCreateOpenGLWindow(char *name,unsigned char mask,int xPos,int yPos,int width,int height){

	WNDCLASS wc;
	RECT wRect;
	DEVMODE lpdm;
	
	/* Setup the pixel format we want. Try to get it later. */
	PIXELFORMATDESCRIPTOR pfd={
		sizeof(PIXELFORMATDESCRIPTOR),
		1,
		PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | ((mask & LL_DOUBLEBUFFER)?PFD_DOUBLEBUFFER:0),
		PFD_TYPE_RGBA,
		24,			/* Color buffer bits */
		0, 0, 0, 0, 0, 0,
		0,			/* Alpha buffer bits */
		0,
		((mask & LL_ACCUMULATIONBUFFER)?24:0),	/* Accumulator buffer bits */
		0, 0, 0, 0, 
		((mask & LL_DEPTHBUFFER)?16:0),		/* Depth buffer bits */
		((mask & LL_STENCILBUFFER)?24:0),	/* Stencil buffer bits */
		0,			/* Auxiliary buffer bits */
		PFD_MAIN_PLANE,
		0, 0, 0, 0
	};	
	int pixelFormat;

	/* The style of the window used with CreateWindowEx(). */
	DWORD wStyleEx;
	DWORD wStyle;

	/* Setup our windows with following properties and try to register it: 
	   - Redraw window if coverd and we use our own DeviceContext
	   - Use 'wndProc' for handling window messages.
       - No extra bytes.
	   - Standard incon and coursor.
	   - No menus
	*/
	wc.style=CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc=(WNDPROC) wndProc;
	wc.cbClsExtra=0;
	wc.cbWndExtra=0;
	instance=GetModuleHandle(NULL);
	if(instance==NULL){
		MessageBox(NULL,"Was not able to get instance handle.","Error",MB_OK);
		return LL_ERROR;
	}
	wc.hInstance=instance;
	wc.hIcon=LoadIcon(NULL,IDI_WINLOGO);
	wc.hCursor=LoadCursor(NULL,IDC_ARROW);
	if(wc.hIcon==NULL || wc.hCursor==NULL){
		MessageBox(NULL,"Cursor and/or Icon not loaded properly.","Error",MB_OK);
		return LL_ERROR;
	}
	wc.hbrBackground=NULL;
	wc.lpszMenuName=NULL;
	wc.lpszClassName="OpenGL";
	if(RegisterClass(&wc)==0){
		MessageBox(NULL,"Wasn't able to regiser windowclass.","Error",MB_OK);
		return LL_ERROR;
	}

	/* Check if we gona run in fullscreen. Sett screenmode and decide window type. */
	if(mask & LL_FULLSCREEN){
		memset(&lpdm,0,sizeof(DEVMODE));
		lpdm.dmSize=sizeof(DEVMODE);
		lpdm.dmBitsPerPel=32;
		lpdm.dmPelsWidth=width;
		lpdm.dmPelsHeight=height;
		lpdm.dmFields=DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT;
		if(ChangeDisplaySettings(&lpdm,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL){
			MessageBox(NULL,"Wasn't able to change screen mode.","Error",MB_OK);
			return LL_ERROR;
		}
		wStyleEx=WS_EX_APPWINDOW;
		wStyle=WS_POPUP;
	}else{
		wStyleEx=WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;
		wStyle=WS_OVERLAPPEDWINDOW;
	}

	/* Setup a rectangle for our window. */
	wRect.left=(long)0;
	wRect.right=(long)width;
	wRect.top=(long)0;
	wRect.bottom=(long)height;
	if(AdjustWindowRectEx(&wRect,wStyle,FALSE,wStyleEx)==0){
		MessageBox(NULL,"Was not able to calculate proper size of window.","Error",MB_OK);
		return LL_ERROR;
	}

	/* Create the window with right title, style, size and position. No menus. */
	windowH=CreateWindowEx(wStyleEx,"OpenGL",name,wStyle | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,xPos,yPos,wRect.right-wRect.left,wRect.bottom-wRect.top,NULL,NULL,instance,NULL);
	if(windowH==NULL){
		MessageBox(NULL,"Could not create window.","Error",MB_OK);
		llKillOpenGLWindow();
		return LL_ERROR;
	}

	dc=GetDC(windowH);
	if(dc==NULL){
		MessageBox(NULL,"Could not get the device context for window.","Error",MB_OK);
		llKillOpenGLWindow();
		return LL_ERROR;
	}

	/* Try to set the pixelformat we want. */	
	pixelFormat=ChoosePixelFormat(dc,&pfd);
	if(pixelFormat==0){
		MessageBox(NULL,"Could not find a good pixel format.","Error",MB_OK);
		llKillOpenGLWindow();
		return LL_ERROR;
	}
	if(!SetPixelFormat(dc,pixelFormat,&pfd)){
		MessageBox(NULL,"Could not set pixel format.","Error",MB_OK);
		llKillOpenGLWindow();
		return LL_ERROR;
	}

	/* Try to create and acticate a rendering context. */
	rc=wglCreateContext(dc);
	if(rc==NULL){
		MessageBox(NULL,"Wasn't able to create rendering context.","Error",MB_OK);
		llKillOpenGLWindow();
		return LL_ERROR;
	}
	if(!wglMakeCurrent(dc,rc)){
		MessageBox(NULL,"Could not activate rendering context.","Error",MB_OK);
		llKillOpenGLWindow();
		return LL_ERROR;
	}

	/* Make our window in the front. */
	ShowWindow(windowH,SW_SHOW);
	if(SetForegroundWindow(windowH)==0){
/*		MessageBox(NULL,"Wasn't able to move window to foreground.","Error",MB_OK);
		llKillOpenGLWindow();
		exit(1);
*/	}
	if(SetFocus(windowH)==NULL){
/*		MessageBox(NULL,"Could not focus on window.","Error",MB_OK);
		llKillOpenGLWindow();
		exit(1);
*/	}

	/* Setup other stuff such as DirectInput. */
	if(setupLL()==LL_ERROR){
		llKillOpenGLWindow();
		MessageBox(NULL,"setupLL fucked!!","Error",MB_OK);
		return LL_ERROR;
	}

	/* Save some information. */
	winWidth=width;
	winHeight=height;
	winXPos=xPos;
	winYPos=yPos;
	winFullscreen=mask & LL_FULLSCREEN;

	return LL_OK;
}


void llKillOpenGLWindow(){
	/* Remove as much as possible. */
	if(winFullscreen!=0)ChangeDisplaySettings(NULL,0);
	wglMakeCurrent(NULL,NULL);
	if(rc)wglDeleteContext(rc);
	if(dc)ReleaseDC(windowH,dc);
	if(windowH)DestroyWindow(windowH);
	UnregisterClass("OpenGL",instance);

	freeLL();
}

/* Handle messages to window. */
LRESULT CALLBACK wndProc(HWND windowH, UINT msg, WPARAM wParam, LPARAM lParam){
	if(msg==WM_CREATE)return 0;
	if(msg==WM_CLOSE){
		llKillOpenGLWindow();
		exit(0);
	}
	return DefWindowProc(windowH,msg,wParam,lParam);
}


void llSwapBuffers(){
	SwapBuffers(dc);
}

/* Get messages sent to our app. Update KB-table.*/
/* Return 0 if time to quit else 1. */
int llHandleEvents(int mode){
	DIDEVICEOBJECTDATA data;
	DWORD num=1;
	int retval=LL_OK;
	MSG msg;
	POINT mpos;

	/* Handle window events. */
	if(mode!=LL_EVENT_WAIT){
		while(PeekMessage(&msg,NULL,0,0,PM_REMOVE)!=0){
			if(msg.message==WM_QUIT){
				retval=LL_QUIT;
				continue;
			}
			DispatchMessage(&msg);
		}
	}else{
		if(GetMessage(&msg,NULL,0,0)==0){
			retval=LL_QUIT;
		}else{
			DispatchMessage(&msg);
		}
	}

	/* Update KB. */
	KBDevice->GetDeviceState(256,(LPVOID)llKeyTable);

	/* Get mouse state. Loop until no mouse events left in buffer. */
	if(mouseHomeX!=-1){
		mouseX=mouseHomeX; mouseY=mouseHomeY;
	}
HRESULT hr;
	oldMouseButtons=mouseButtons;
	while((hr=mouseDevice->GetDeviceData(sizeof(DIDEVICEOBJECTDATA),&data,&num,0))==DI_OK && num!=0){
		switch(data.dwOfs){
			case DIMOFS_BUTTON0:	/* Left button. */
				if(data.dwData & 0x80){
					mouseButtons|=LL_MOUSE_BUTTON_LEFT;
				}else{
					mouseButtons&=~LL_MOUSE_BUTTON_LEFT;
				}
			break;
			case DIMOFS_BUTTON1:	/* Right button. */
				if(data.dwData & 0x80){
					mouseButtons|=LL_MOUSE_BUTTON_RIGHT;
				}else{
					mouseButtons&=~LL_MOUSE_BUTTON_RIGHT;
				}
			break;
			case DIMOFS_X:	/* Horizontal motion. */
				GetCursorPos(&mpos);
				mouseX=mpos.x;
				mouseY=mpos.y;
			break;
			case DIMOFS_Y:	/* Vertical motion. */
				GetCursorPos(&mpos);
				mouseX=mpos.x;
				mouseY=mpos.y;
			break;
		}
//MessageBox(NULL,"Mouse event!",NULL,MB_OK);
	}
switch(hr){
case DIERR_INPUTLOST: /*MessageBox(NULL,"INPUT",NULL,MB_OK);*/ mouseDevice->Acquire(); break;
/*case DIERR_INVALIDPARAM: MessageBox(NULL,"INVALIED",NULL,MB_OK); break;
case DIERR_NOTACQUIRED: MessageBox(NULL,"NOTACQUEIRED",NULL,MB_OK); break;
case DIERR_NOTBUFFERED: MessageBox(NULL,"NOTBUFFERED",NULL,MB_OK); break;
case DIERR_NOTINITIALIZED: MessageBox(NULL,"NOTINITILIZED",NULL,MB_OK); break;
*/}
	if(mouseHomeX!=-1 && !(mouseX==mouseHomeX && mouseY==mouseHomeY))llMouseSetPosition(mouseHomeX-(winWidth>>1),mouseHomeY-(winHeight>>1));

	return retval;
}

/* Mouse handling. Get state last time llHandleEvents() was called. */
short int llMouseGetXPos(){
	return mouseX-(winWidth>>1);
}
short int llMouseGetYPos(){
	return mouseY-(winHeight>>1);
}

/* Set mouse position (0,0) is middle of window. */
void llMouseSetPosition(short int x,short int y){
	SetCursorPos(x+winXPos+(winWidth>>1),y+winYPos+(winHeight>>1));
}
void llMouseSetHome(short int x,short int y){
	mouseHomeX=x+(winWidth>>1);
	mouseHomeY=y+(winHeight>>1);
	if(mouseHomeX>winWidth || mouseHomeX<0 || mouseHomeY>winHeight || mouseHomeY<0)mouseHomeX=mouseHomeY=-1;
}
/* Some functions for retrieveing mouse button status. */
unsigned char llMouseButtonDown(unsigned char button){
	return (mouseButtons & button);
}
unsigned char llMouseButtonPressed(unsigned char button){
	return ((oldMouseButtons & button)?!((mouseButtons) & button):0);
}

/* Get time in milliseconds. */
unsigned long llGetTime(){
	return timeGetTime();
}
/* Wait if needed. */
void llBrake(unsigned long time){
	static unsigned long lastTime=0;
	if(lastTime==0){
		lastTime=llGetTime();
		return;
	}
	while(llGetTime()-time<lastTime);
	lastTime=llGetTime();
}
