
////////////////////////////////////////////////////////
// Includes.
////////////////////////////////////////////////////////

#include <windows.h>
#include <stdio.h>

#include "llgl.h"
#include "ll.h"


////////////////////////////////////////////////////////
// Defines. 
////////////////////////////////////////////////////////

#define MAX_LEN		9
#define TEXTURES	13
#define N_WIDTH		0.2f
#define N_HEIGHT	0.5f
#define N_SPACE		0.01f
#define N_WIDTH2	0.1f
#define N_HEIGHT2	0.4f
#define N_SPACE2	0.005f

/* Animation states. */
#define N_NOTHING		0
#define N_IN			1
#define N_OUT			2
#define N_ROTATING		4
#define N_IMPLODE		8

#define SPEED		0.02f


////////////////////////////////////////////////////////
// Prototypes.
////////////////////////////////////////////////////////

char *base3(long dec,char *buffer,void (*callback)(void));	/* Conver 'dev' to a string with number in base3. */
long getNumber(void);				/* Lets user write a number. */
int checkKB(void);				/* Check kb input. Returns: -1==Backspace. -2==Enter. -3==-. 0-9==Key 0-9. */
void renderNumber(int num,float *pos);		/* Draw one number to screen on pos. */
void clearPositions(void);			/* Reset position for numbers. */
float getPos(float step);			/* Step is 0 to 1. Return is 0-1. */
int loadTextures(char *fileList,short int num,GLuint tex);	/* Get textures. */
void renderTexture(int tex);		/* Put texture on screen. */
void calcCallback(void);		/* Will update screen and poll events. */
void showResult(char *text);	/* Show number in text. */
void renderNumber2(int num,float x,float y,float z);	/* Render numbers. */


////////////////////////////////////////////////////////
// Globals.
////////////////////////////////////////////////////////

GLuint texture[TEXTURES];
int numTex;
float tpos[3*MAX_LEN];
unsigned char info[MAX_LEN];
float data[MAX_LEN];
int lastKey;


////////////////////////////////////////////////////////
// Da Main!
////////////////////////////////////////////////////////

int main();
/* Winmain stuff. */
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd){
	return main();
}

int main(){
	long number;
	int i;
	char buff[33];
	char *fname;

	llCreateOpenGLWindow("Base33D  By: Kirkov  DH01",LL_DOUBLEBUFFER | LL_DEPTHBUFFER,100,100,300,300);

	for(i=0;i<10;i++){
		memset(buff,0,13);
		fname=(char *)itoa(i,buff,10);
		strcat(fname,".ktf");
		if(loadTextures(fname,1,i+1)!=1){
			MessageBox(NULL,"Could not find textures!",NULL,MB_OK);
			llKillOpenGLWindow();
			exit(1);
		}
		texture[i]=i+1;
	}
	if(loadTextures("main.ktf",1,11)!=1){
		MessageBox(NULL,"Could not find textures!",NULL,MB_OK);
		llKillOpenGLWindow();
		exit(1);
	}
	texture[10]=11;
	if(loadTextures("calc.ktf",1,12)!=1){
		MessageBox(NULL,"Could not find textures!",NULL,MB_OK);
		llKillOpenGLWindow();
		exit(1);
	}
	texture[11]=12;
	if(loadTextures("end.ktf",1,13)!=1){
		MessageBox(NULL,"Could not find textures!",NULL,MB_OK);
		llKillOpenGLWindow();
		exit(1);
	}
	texture[12]=13;

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glFrustum(0.0,1.0,0.0,1.0,0.5,2.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	glColor3f(0.0,0.0,0.0);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);
	glEnable(GL_BLEND);
	glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_DECAL);
	glEnable(GL_TEXTURE_2D);
	glClearColor(0.0f,0.0f,0.0f,0.0f);

	number=getNumber();	

	glClear(GL_COLOR_BUFFER_BIT);
	llBrake(0);
	base3(number,buff,calcCallback);
	llBrake(3000);

	showResult(buff);

	return 0;
}


////////////////////////////////////////////////////////
// Functions.
////////////////////////////////////////////////////////

/* Conver 'dev' to a string with number in base3. */
char *base3(long dec,char *buffer,void (*callback)(void)){
	int len, i, cbCount=0;
	long tmp, num;
	char *buff=buffer;

	/* Convert 'dec' to base3 and put in buffer. */
	while(dec>0){
		/* Get number of 3s 'dec' consists of. */
		num=0;
		tmp=dec;
		while(tmp>2){
			num++;
			tmp-=3;
			if(cbCount<10){ (*callback)(); cbCount++; }
		}
		dec=num;

		/* Put in buffert. */
		*buff=tmp+48;
		buff++;
	}

	/* Reverse order of buff. */
	len=buff-buffer;
	for(i=0;i<(len>>1);i++){
                tmp=buffer[i];
		buffer[i]=buffer[len-i-1];
                buffer[len-i-1]=(char)tmp;
	}
	buffer[len]='\0';

	return buffer;
}

/* Lets user write a number. */
long getNumber(){
	int key,pos=0,i;
	char text[MAX_LEN+1];
	char *tmp;
	int done=0;
	memset(text,0,MAX_LEN+1);
	glClearColor(0.0,0.0,0.0,0.0);
	llHandleEvents(LL_EVENT_CHECK);
	while(!done && llHandleEvents(LL_EVENT_CHECK)!=LL_QUIT){	/* While enter not pressed. */

		key=checkKB();

		/* Handle kb. */
		if(lastKey!=key){
			if(info[pos]!=N_OUT){
				if(key==-1){	/* Backspace. */
					if(pos>0 && info[pos-1]!=N_OUT){ 
						info[pos-1]=N_OUT;
						data[pos-1]=1.0f;
					}
				}else{			/* Number. */
					if(key==-3 && pos==0){
						text[pos]='-';
						info[pos]=N_IN;
						data[pos++]=0;
					}else if(key==-2 && pos>0){
						for(i=0;i<MAX_LEN;i++){
							info[i]=N_IMPLODE;
							data[i]=0;
						}
					}else if(key!=-4){
						if(pos<MAX_LEN){
							text[pos]=key+48;
							info[pos]=N_IN;
							data[pos++]=0;
						}
					}
				}
			}
		}
		lastKey=key;

		/* Move things. */
		for(i=0;i<MAX_LEN;i++){
			if(info[i]==N_IN){
				tpos[i*3]=(float)(i*(N_WIDTH+N_SPACE))*getPos(data[i]);
				tpos[i*3+1]=(float)(1.0f)*getPos(data[i])-0.25f;
				tpos[i*3+2]=(float)data[i]*(-1.0f);
				data[i]+=SPEED;
				if(data[i]>1.0f){ data[i]=0; info[i]=N_NOTHING; }	/* Stop moving. */
			}else if(info[i]==N_OUT){
				tpos[i*3]=(float)(i*(N_WIDTH+N_SPACE))*getPos(data[i]);
				tpos[i*3+1]=(float)(1.0f)*getPos(data[i])-0.25f;
				tpos[i*3+2]=(float)data[i]*(-1.0f);
				data[i]-=SPEED;
				if(data[i]<0.0f){ data[i]=0; info[i]=N_NOTHING; text[--pos]='\0'; }	/* Stop moving. */
			}else if(info[i]==N_IMPLODE){
				tpos[i*3]=1.0f+((float)(i*(N_WIDTH+N_SPACE))-1.0f)*(1.0f-data[i]);
				data[i]+=SPEED;
				if(data[i]>1.0f){ data[i]=0; info[i]=N_NOTHING; done=1; }	/* Stop moving. */
			}
		}

		/* Draw stuff. */
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		renderTexture(10);
		tmp=text; i=0;
		while(*tmp!='\0'){
			renderNumber(*tmp-48,&tpos[i*3]);
			tmp++;
			i++;
		}
		llSwapBuffers();

		llBrake(20);
	}

	return atol(text);
}

/* Check kb input. */
/* Bad way but had no time to figure out how to do it good, platform independent! */
/* Returns: -1==Backspace. -2==Enter. -3==-. 0-9==Key 0-9. -4==None. */
int checkKB(){
	/* Check numbers. */
	if(llKeyDown(LL_KEY_0) || llKeyDown(LL_KEY_KP_0))return 0;
	if(llKeyDown(LL_KEY_1) || llKeyDown(LL_KEY_KP_1))return 1;
	if(llKeyDown(LL_KEY_2) || llKeyDown(LL_KEY_KP_2))return 2;
	if(llKeyDown(LL_KEY_3) || llKeyDown(LL_KEY_KP_3))return 3;
	if(llKeyDown(LL_KEY_4) || llKeyDown(LL_KEY_KP_4))return 4;
	if(llKeyDown(LL_KEY_5) || llKeyDown(LL_KEY_KP_5))return 5;
	if(llKeyDown(LL_KEY_6) || llKeyDown(LL_KEY_KP_6))return 6;
	if(llKeyDown(LL_KEY_7) || llKeyDown(LL_KEY_KP_7))return 7;
	if(llKeyDown(LL_KEY_8) || llKeyDown(LL_KEY_KP_8))return 8;
	if(llKeyDown(LL_KEY_9) || llKeyDown(LL_KEY_KP_9))return 9;

	/* Check backspace. */
	if(llKeyDown(LL_KEY_BACKSPACE))return -1;

	/* Check enter. */
	if(llKeyDown(LL_KEY_ENTER) || llKeyDown(LL_KEY_KP_ENTER))return -2;

	/* Check minus. */
	if(llKeyDown(LL_KEY_MINUS) || llKeyDown(LL_KEY_KP_MINUS))return -3;

	return -4;
}

/* Draw one number to screen on pos. */
void renderNumber(int num,float *pos){
	glBindTexture(GL_TEXTURE_2D,texture[num]);
	glBegin(GL_QUADS);
		glTexCoord2f(0.0,0.0);
		glVertex3f(pos[0],pos[1],pos[2]);
		glTexCoord2f(1.0,0.0);
		glVertex3f(pos[0]+N_WIDTH,pos[1],pos[2]);
		glTexCoord2f(1.0,1.0);
		glVertex3f(pos[0]+N_WIDTH,pos[1]+N_HEIGHT,pos[2]);
		glTexCoord2f(0.0,1.0);
		glVertex3f(pos[0],pos[1]+N_HEIGHT,pos[2]);
	glEnd();
}

/* Reset position for numbers. */
void clearPositions(void){
	memset(tpos,0,sizeof(float)*3*MAX_LEN);
	memset(info,0,MAX_LEN);
	memset(data,0,sizeof(float)*MAX_LEN);
}

/* Step is 0 to 1. Return is 0-1. */
float getPos(float step){
	return (1.0f-(step-1.0f)*(step-1.0f));
}

/* Load and setup num textures from .KTF files. Filenames are strings 
   following each other in memory separeted by 1 char (wich one is irrelevant).
   First filename is located at 'fileList'.
   Return 1 on success. 0 on any error. */
int loadTextures(char *fileList,short int num,GLuint tex){

	int i;

	char *filename=fileList;

	FILE *ktf;
	unsigned short width, height;
	unsigned char alpha;
	unsigned long imageSize;
	unsigned char *data;

	/* Load and setup all textures. */
	for(i=0;i<num;i++){
		ktf=fopen(filename,"rb");
		if(ktf==NULL)return 0;

		/* Gerneral image info. Size. Alpha buffer or not. */
		fread(&width,2,1,ktf);
		fread(&height,2,1,ktf);
		fread(&alpha,1,1,ktf);

		imageSize=width*height* (alpha==0x00 ? 3 : 4);
		data=(unsigned char *)malloc(imageSize);
		if(data==NULL){
			fclose(ktf);
			return 0;
		}
		if(fread(data,1,imageSize,ktf)!=imageSize){
			fclose(ktf);
			free(data);
			return 0;
		}

		/* Bind the new image in a new GL texture. */
		glBindTexture(GL_TEXTURE_2D,tex);
		glTexImage2D(GL_TEXTURE_2D,0,(alpha==0x00?3:4),width,height,0,(alpha==0x00?GL_RGB:GL_RGBA),GL_UNSIGNED_BYTE,data);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);

		free(data);
		fclose(ktf);

		/* Next filename should follow. Point at it. If last, dont care we wont use it then. */
		filename+=strlen(filename)+1;
	}
	return 1;
}

void renderTexture(int tex){
	glBindTexture(GL_TEXTURE_2D,texture[tex]);
	glBegin(GL_QUADS);
		glTexCoord2f(0.0,0.0);
		glVertex3f(0.0,0.0,-1.0);
		glTexCoord2f(1.0,0.0);
		glVertex3f(2.0,0.0,-1.0);
		glTexCoord2f(1.0,1.0);
		glVertex3f(2.0,2.0,-1.0);
		glTexCoord2f(0.0,1.0);
		glVertex3f(0.0,2.0,-1.0);
	glEnd();
}

void calcCallback(){
	static unsigned long lastTime=0;
	static float angle=0;
	float time;
	if(lastTime!=0)time=(float)(llGetTime()-lastTime);
	if(llHandleEvents(LL_EVENT_CHECK)==LL_QUIT){
		llKillOpenGLWindow();
		exit(1);
	}

	angle+=time/100;
	if(angle>360)angle-=360;

	glBindTexture(GL_TEXTURE_2D,texture[11]);
	glBegin(GL_QUADS);
		glTexCoord2f(0.0,0.0);
		glVertex3f(0.5,0.9f,-1.0);
		glTexCoord2f(1.0,0.0);
		glVertex3f(1.5,0.9f,-1.0);
		glTexCoord2f(1.0,1.0);
		glVertex3f(1.5,1.1f,-1.0);
		glTexCoord2f(0.0,1.0);
		glVertex3f(0.5,1.1f,-1.0);
	glEnd();
	renderTexture(10);
	llSwapBuffers();

	lastTime=llGetTime();
}

void showResult(char *text){
	int len=strlen(text);
	int i;
	float explode=0.0;
	while(llHandleEvents(LL_EVENT_CHECK)!=LL_QUIT && !llKeyDown(LL_KEY_ESC)){

		/* Draw stuff. */
		glClear(GL_COLOR_BUFFER_BIT);
		renderTexture(12);
		for(i=0;i<len;i++){
			renderNumber2(text[i]-48,1.0f+(i*(N_WIDTH2+N_SPACE2)-1.0f)*explode,0.8f,-1.0);
		}
		llSwapBuffers();
		if(explode<1.0f)explode+=SPEED;

		llBrake(20);
	}
}

/* Draw one number to screen on pos. */
void renderNumber2(int num,float x,float y,float z){
	glBindTexture(GL_TEXTURE_2D,texture[num]);
	glBegin(GL_QUADS);
		glTexCoord2f(0.0,0.0);
		glVertex3f(x,y,z);
		glTexCoord2f(1.0,0.0);
		glVertex3f(x+N_WIDTH2,y,z);
		glTexCoord2f(1.0,1.0);
		glVertex3f(x+N_WIDTH2,y+N_HEIGHT2,z);
		glTexCoord2f(0.0,1.0);
		glVertex3f(x,y+N_HEIGHT2,z);
	glEnd();
}
