/*
        
   "Meditating"     
        
   by uncle-x/mfx (niko leskinen) 
        
   
   
   Shows an amiga 500 crashing... whee!!
   
   History & Inspiration:
   
   My original project for this years assembly got too complicated and had no idead...
   My 2nd project would not have been allowed in the compo...
   My 3rd project got even more complicated than the first one
   So this is it, the 4th project started inside 1.5 months...
   
   Made in quite a hurry but atleast the subject is more scene related than usual:   
   
   Tools used:
   
   - MegaPov 0.7 for rendering
   
   - A ruler for measuring various pieces of hardware
   
   - Paint Shop Pro 5 for signing and texture maps
   
 
         
        
   Disclaimer and copyright:

   _Everything_ in the image has been done by me. (except the lapin kulta label which is severly  edited from a photo taken
   by someone else)

   If you (meaning you or someone else) will use this data file and claim it their own, then i will be pretty pissed off.
    
   This image is not an advertisement of Amiga or Lapin Kulta. :)
      

   Technical detail:
   
   - Final rendering took about 14 hours on a 200mhz mmx pentium.
   
   To render this file properly you need:
   
   - Povray 3.1g (http://www.povray.org)
   
   - MegaPov 0.7 (http://nathan.kopp.com/patched.htm)
   
   - Everything in the same zip file you found this file.
   
   - timesbd.ttf, timesbi.ttf & arialbd.ttf true type fonts in the same directory as this pov file. (included in the zip file)
   
   Contact:
   
   naleskin@cs.helsinki.fi
   
   
   
   btw. the source code is full of stupid things and unremoved unused code... sorry. too much in a hurry...
   
   
         
 */


#version unofficial MegaPov 0.7;
#declare Rad=off;//off;
#declare high_quality=no;
//#declare RadBr=3.25;//normal is 1... dont see much then tho...
#declare RadBr=1.5;//normal is 1... dont see much then tho...
#declare lightpower=1.75;

#if(Rad=on)
  #declare Amb = 0.0;
#else
  #declare Amb = 0.000725;
#end
#declare Amb1 = Amb*0.75;
#declare Amb2 = Amb+Amb/3;
#declare Amb3 = Amb-Amb/4;
#declare Amb4 = Amb+Amb/4;
#declare Amb5 = Amb*1.125;
#declare Amb_Lite = 0.95;
#declare Reflection = 0; // 1 = On, 0 = Off
#declare BReflection = 1; // 1 = On, 0 = Off
#declare Specularmultiplier = 1.0;
#if(Rad=on)
  #declare Filter_Multiplier = 3.0;
#else
  #declare Filter_Multiplier = 0.0;
#end

#if(Rad=on)
  #declare Light_Multiplier = 1.125;
#else                                
  #declare Light_Multiplier = 1.250;
#end

#include "colors.inc"
//#include "metals_oma.inc"
//#include "tyre.inc"

#declare K=30.00;
#declare C=clock;

#declare Ground_dec = false; //
#declare    Sky_dec = true;
#declare    Sea_dec = false;
#declare    Fog_dec = true;
#declare   Area_dec = false;
#declare Trees=off;
#declare detail=off;

#declare SpotLights=on;

#declare GroundLevel=0;


#declare Rez=0.5145;
#include "a500_global_settings.inc"

#declare Cam_Loc = <-15, 67.0, -125.010>;
#declare Cam_Look_At = <-3, 26, -15>;
//#declare Cam_Loc = <0, 37.0, -40.010>;
//#declare Cam_Look_At = <-0, 12, -15>;
//#declare Cam_Loc = <60, 77.0, -70.010>;
//#declare Cam_Look_At = <25, 12, 5>;

//#declare Cam_Loc = <30, 40, -50>;
//#declare Cam_Look_At = <0, 1, 0>;
#declare Cam_Angle = 50


//#declare Cam_Loc = <0.0, 70, -0.01>;
//#declare Cam_Look_At = <0, 30, 0>;

/*
#declare Light_Loc=<45000,107500,-115001>;
#declare Light_Color = rgb (<1.00, 0.875 0.65>)*Light_Multiplier;//normal
*/
#declare Light_Loc=<350,100,251>;
#declare Light_Color = rgb <0.50, 0.5 0.5>*2.2;


camera {
  
//  orthographic
  location Cam_Loc 
  up    <0.00,1.0,0.0> 
  right <2.35,0.0,0.0> 

//  up    <0.0,1.0*160,0.0> 
//  right <2.35*160,0.0,0.0> 
  angle Cam_Angle
  look_at Cam_Look_At
}

/*
//outside light... 
light_source {
//  <-100,60,70>
  <-90,120,-40>
  color rgb<1,1,1.0>*0.8*lightpower
//  color rgb<0.2,0.5,1.0>*0.8*lightpower
  #if(Area_dec=true)
    area_light <6.0,0,0>, <0,6.0,0>, 5, 5 // normal
    adaptive 1
    jitter
    circular
  #else
  #end
  fade_distance 80/(lightpower*0.85)
  fade_power 2
  media_interaction on
  media_attenuation on
}
*/
//outside light... 
light_source {
//  <-100,60,70>
  <-100,50,-90>
//  color rgb<1,1,1.0>*1.3
//  color rgb<0.2,0.5,1.0>*0.8*lightpower
  color rgb<1,1,1.0>*0.8*lightpower
  #if(Area_dec=true)
    area_light <6.0,0,0>, <0,6.0,0>, 5, 5 // normal
    adaptive 1
    jitter
    circular
  #else
  #end
  fade_distance 80/(lightpower*0.85)
  fade_power 2
  media_interaction on
  media_attenuation on
}


//soft top
light_source {
  <-30,150,-70>
  color rgb<0.7,0.85,1.0>*0.2*1.5*lightpower*2
  #if(Area_dec=true)
    area_light <30.0,0,0>, <0,30.0,0>, 13, 13 // normal
    adaptive 1
    jitter
    circular
  #else
  #end
  fade_distance 175/(lightpower*0.85)
  fade_power 3
} 
   
light_source {
  <120,50,-39+80-0>
  color rgb<1.0,1.0,1.0>*0.2*3.5*lightpower*3
  #if(Area_dec=true)
    area_light <20.0,0,0>, <0,20.0,0>, 10, 10 // normal
    adaptive 1
    jitter
    circular
  #else
  #end
  fade_distance 175/(lightpower*0.85)
  fade_power 3
}    



//fog {color rgb<.1, .175, .35> fog_type 2 fog_offset 5 fog_alt 750 distance 10000}

//box {<-100,-3,-25>,<100,0,75> pigment {color rgb<0.4,0.4,0.4>} finish {specular 0.1 diffuse 0.5 ambient Amb} normal {granite 0.1 bump_size 0.075 scale <5,1.5,2> rotate <0,33.54,9> scale <1,1,1.3>}}
//floor
plane {y,0 hollow pigment {color rgb<0.5,0.5,0.5>} finish {specular 0.1 diffuse 0.4 ambient Amb} normal {wrinkles 0.1 bump_size 0.075 scale <5,1.5,2> rotate <0,33.54,9> scale <3,1,4>} translate <0,-100,0>}
//back wall
plane {z,0 hollow pigment {color rgb<0.4,0.4,0.4>} finish {specular 0.1 diffuse 0.4 ambient Amb} translate <0,0,-200>}
//front wall
plane {z,0 hollow pigment {color rgb<0.24,0.24,0.24>} finish {specular 0.1 diffuse 0.3 ambient Amb} translate <0,0,100>}
//roof
plane {y,0 hollow pigment {color rgb<0.25,0.25,0.25>} finish {specular 0.1 diffuse 0.4 ambient Amb} normal {wrinkles 0.1 bump_size 0.075 scale <5,1.5,2> rotate <0,33.54,9> scale <3,1,4>} translate <0,150,0>}


//--------------begin amiga 500--------------------------------------------------------------------------

// textures
//
//
//

#declare normals=true;

#declare Key_Mid = //for numpad, arrows and space bar
texture {
  pigment {color rgb<228/225,214/225,180/225>*0.575*0.9}
//  pigment {color rgb<148/255,134/255,78/255>*0.5+<123/255,124/255,118/255>*0.5}
  finish {diffuse 0.6 specular 0.175 roughness 0.4 phong 0.4 phong_size 100 crand 0.001 ambient Amb}
  #if(normals) normal {granite 0.08 bump_size 0.03 scale 1}#end
}

#declare Key_Beige = //for qwerty
texture {
  pigment {color rgb<230/225,206/225,170/225>*0.575}
//  pigment {color rgb<148/255,134/255,78/255>*0.75+<123/255,124/255,118/255>*0.25}
  finish {diffuse 0.6 specular 0.25 roughness 0.3 phong 0.45 phong_size 100 crand 0.001 ambient Amb}
  #if(normals) normal {granite 0.08 bump_size 0.03 scale 1}#end
}

#declare Key_Dark = //for parts of numpad, del & help
texture {
  pigment {color rgb<160/255,155/255,133/255>*0.575*0.4}
//  pigment {color rgb<148/255,134/255,78/255>*0.35+<72/255,73/255,75/255>*0.5}
  finish {diffuse 0.6 specular 0.2 roughness 0.4 phong 0.45 phong_size 100 crand 0.001 ambient Amb}
  #if(normals) normal {granite 0.08 bump_size 0.03 scale 1}#end
}

#declare AmiPlastic_x =
texture {
//  pigment {color rgb<123/255,124/255,118/255>*0.25+<128/255,124/255,98/255>*0.75}

//  pigment {color rgb<123/255,124/255,118/255>*0.25+<148/255,134/255,78/255>*0.75}
  pigment {color rgb<227/225,220/225,180/225>*0.575}

//  finish {diffuse 0.6 specular 0.075 roughness 0.3 phong 0.4 phong_size 100 crand 0.001 ambient Amb}
  finish {diffuse 0.6 specular 0.075 roughness 0.5 phong 0.2 phong_size 10 crand 0.001 ambient Amb}
  #if(normals) normal {granite 0.1 bump_size 0.05 scale 1}#end
} 

#declare Ami_Stained_Plastic =
texture {
  pigment {
    bozo
    pigment_map {
      [0.2 color rgb<217/225,210/225,170/225>*0.575]
      [0.7 color rgb<207/225,180/225,160/225>*0.575]
    }
    scale 0.05
    turbulence <0.3,0.4,02>
  }
  finish {specular 0.4 roughness 0.1 phong 0.25 phong_size 100 diffuse 0.45 ambient Amb metallic 0.16 reflection 0.0}
  normal {granite 0.3 bump_size 0.1 scale <0.25,0.25,0.25> scale 0.1}
}

#declare AmiPlastic =
texture {
  wrinkles
  texture_map {
    [0.0 AmiPlastic_x scale 0.2]
    [0.5 AmiPlastic_x scale 0.2]
    [0.8 Ami_Stained_Plastic scale 0.2]
    [1.0 Ami_Stained_Plastic scale 0.2]
  }
  turbulence<0.1,0.2,0.4>
  scale <5,3,5>
}

#declare Monitordarkplastic_x =
texture {
  pigment {color rgb<227/225,230/225,180/225>*0.4*0.575}

//  pigment {color rgb(<123/255,124/255,118/255>*0.25+<148/255,134/255,78/255>*0.6)*0.75}

//  finish {diffuse 0.6 specular 0.075 roughness 0.3 phong 0.4 phong_size 100 crand 0.001 ambient Amb}
//  finish {diffuse 0.6 specular 0.075 roughness 0.5 phong 0.2 phong_size 10 crand 0.001 ambient Amb}
  finish {diffuse 0.6 specular 0.15 roughness 0.4 phong 0.45 phong_size 100 crand 0.001 ambient Amb}
  #if(normals) normal {granite 0.1 bump_size 0.05 scale 1}#end
}
#declare Monitordarkplastic_s =
texture {
  pigment {
    bozo
    pigment_map {
      [0.2 color rgb<217/225,210/225,170/225>*0.4*0.575]
      [0.7 color rgb<177/225,150/225,130/225>*0.4*0.575]
    }
    scale 0.05
    turbulence <0.3,0.4,02>
  }
//  pigment {color rgb<227/225,230/225,180/225>*0.4*0.575}
//  finish {diffuse 0.6 specular 0.075 roughness 0.5 phong 0.2 phong_size 10 crand 0.001 ambient Amb}
  finish {diffuse 0.6 specular 0.15 roughness 0.4 phong 0.45 phong_size 100 crand 0.001 ambient Amb}
  #if(normals) normal {granite 0.1 bump_size 0.05 scale 1}#end
}

#declare Monitordarkplastic =
texture {
  wrinkles
  texture_map {
    [0.0 Monitordarkplastic_x scale 0.2]
    [0.5 Monitordarkplastic_x scale 0.2]
    [0.8 Monitordarkplastic_s scale 0.2]
    [1.0 Monitordarkplastic_s scale 0.2]
  }
  turbulence<0.1,0.2,0.4>
  scale <5,5,2>
}


#declare RedPlastic =
texture {
  pigment {color rgbf<1.1,0.05,0.025,0.8>}
  finish {diffuse 0.7 specular 0.2 roughness 0.4 phong 0.5 phong_size 300 ambient Amb}
}
#declare GreenPlastic =
texture {
  pigment {color rgbf<0.05,1.1,0.025,0.8>}
  finish {diffuse 0.7 specular 0.2 roughness 0.4 phong 0.5 phong_size 300 ambient Amb}
}
#declare diskblueplastic =
texture {
  pigment {color rgb<0.05,0.15,0.7>}
  finish {diffuse 0.6 specular 0.2 roughness 0.4 phong 0.5 phong_size 300 ambient Amb}
  #if(normals) normal {granite 0.08 bump_size 0.1 scale 0.05}#end
}
#declare diskgreyplastic =
texture {
  pigment {color rgb<0.5,0.5,0.5>}
  finish {diffuse 0.6 specular 0.1 roughness 0.4 phong 0.5 phong_size 300 ambient Amb}
  #if(normals) normal {granite 0.08 bump_size 0.1 scale 0.05}#end
}
#declare diskblackplastic =
texture {
  pigment {color rgb<0.05,0.05,0.05>}
  finish {diffuse 0.6 specular 0.1 roughness 0.4 phong 0.5 phong_size 300 ambient Amb}
  #if(normals) normal {granite 0.08 bump_size 0.1 scale 0.05}#end
}
#declare diskgreenplastic =
texture {
  pigment {color rgb<0.1,0.6,0.2>}
  finish {diffuse 0.6 specular 0.2 roughness 0.4 phong 0.5 phong_size 300 ambient Amb}
  #if(normals) normal {granite 0.08 bump_size 0.1 scale 0.05}#end
}

#declare Label_Texture =
texture {
  pigment {
    average
    pigment_map {
      [0.8 image_map{iff "bcan.iff" map_type 2}]
      [0.2 color rgb<0.65,0.40,0.225>]
    }
  }
  finish {reflection 0.3 reflect_metallic 0.5 diffuse 0.6 specular 0.97*1.2 roughness 0.01 phong 0.9 phong_size 800 ambient Amb metallic 0.8 crand 0.03}
  normal {dents 0.5 bump_size 0.5 scale <1,3,1> scale 0.5}
}
#declare CanAluminum =
texture {
//  pigment {color rgb<0.6,0.66,0.7>}
//  pigment {color rgb<0.7,0.5,0.3>}
//  pigment {color rgb<0.65,0.40,0.225>}
  pigment {color rgb<190/255,158/255*0.9,101/255*0.8>}
  finish {reflection 0.30 reflect_metallic 0.75 brilliance 2 diffuse 0.436 specular 0.97*1.25 roughness 0.01 phong 0.9 phong_size 400 ambient Amb metallic 1.0 crand 0.02}
  normal {dents 0.5 bump_size 0.3 scale <1,0.5,1> scale 0.5}
}
#declare DiskAluminum =
texture {
  pigment {color rgb<0.6,0.66,0.7>}
  finish {reflection 0.20 reflect_metallic 0.75 brilliance 1.5 diffuse 0.436 specular 0.97*1.2 roughness 0.01 phong 0.9 phong_size 400 ambient Amb metallic 1.0 crand 0.02}
  normal {dents 0.5 bump_size 0.3 scale <1,0.5,1> scale 0.5}
}

#declare ScrewTexture =
texture {
  pigment {color rgb<0.4,0.52,0.6>}
  finish {reflection 0.2 reflect_metallic 0.75 diffuse 0.48 specular 0.77*1.1 roughness 0.01 phong 0.9 phong_size 1200 ambient Amb metallic 0.8 crand 0.02}
  normal {dents 0.5 bump_size 0.3 scale <1,0.5,1> scale 0.5}
}

#declare TableLegChrome =
texture {
  pigment {color rgb<0.5,0.62,0.7>}
  finish {reflection 0.6 reflect_metallic 0.75 diffuse 0.5 specular 0.97*1.2 roughness 0.01 phong 0.9 phong_size 1200 ambient Amb metallic 0.998 crand 0.02}
  normal {dents 0.5 bump_size 0.3 scale <1,50,1> scale 0.5}
}

#declare DLabelTexture_1 =
texture {
  pigment {color rgb<0.98,0.97,0.96> translate <-0.5,0,-0.5> rotate x*90}
  finish {diffuse 0.6 specular 0.097 roughness 0.51 phong 0.1 phong_size 120 ambient Amb crand 0.05}
  normal {wrinkles 0.5 bump_size 0.3 scale <2,0.3,2> scale 0.25}
}

#declare BlackWood =
texture {
  pigment {
    granite
    pigment_map {
      [0.0 color rgb<0.1,0.1,0.1>]
      [1.0 color rgb<0.15,0.15,0.15>]
    }
    scale 0.5
  }
  finish {specular 0.1 roughness 0.08 phong 0.3 phong_size 100 diffuse 0.55 ambient Amb /*reflection 0.02*/} 
  normal {granite 0.1 bump_size 0.150 scale 0.25}
}
#declare DarkWood =
texture {
  pigment {
    granite
    pigment_map {
      [0.0 color rgb<0.06,0.06,0.06>]
      [1.0 color rgb<0.08,0.08,0.08>]
    }
    scale 0.5
  }
  finish {specular 0.2 roughness 0.1 phong 0.5 phong_size 400 diffuse 0.65 ambient Amb /*reflection 0.05*/}
  normal {granite 0.1 bump_size 0.075 scale <0.5,0.5,0.5>}
} 
#declare BlackPlastic =
texture {
  pigment {
    granite
    pigment_map {
      [0.0 color rgb<0.01,0.01,0.01>]
      [1.0 color rgb<0.015,0.015,0.015>]
    }
    scale 0.5
  }
  finish {specular 0.4*3 roughness 0.08 phong 0.3*4 phong_size 100 diffuse 0.5 ambient Amb metallic 0.96 reflection 0.005} 
  normal {granite 0.01 bump_size 0.0150 scale 0.25}
}
#declare DarkPlastic =
texture {
  pigment {
    granite
    pigment_map {
      [0.0 color rgb<0.012,0.012,0.014>]
      [1.0 color rgb<0.016,0.016,0.018>]
    }
    scale 0.5
  }
  finish {specular 0.8*2 roughness 0.01 phong 0.5*3 phong_size 200 diffuse 0.5 ambient Amb metallic 0.76 reflection 0.01}
  normal {granite 0.01 bump_size 0.0075 scale <0.5,0.5,0.5>}
} 
#declare DarkPlastic2 =
texture {
  pigment {
    granite
    pigment_map {
      [0.0 color rgb<0.012,0.012,0.014>]
      [1.0 color rgb<0.016,0.016,0.018>]
    }
    scale 0.5
  }
  finish {specular 0.8*2 roughness 0.01 phong 0.5*3 phong_size 200 diffuse 0.5 ambient Amb metallic 0.16 reflection 0.0}
  normal {granite 0.1 bump_size 0.1 scale <0.25,0.25,0.25>}
}                   

#declare Green_Plastic_x =
texture {
  pigment {
    granite
    pigment_map {
      [0.0 color rgb<0.112,0.412,0.114>]
      [1.0 color rgb<0.116,0.416,0.118>]
    }
    scale 0.05
  }
  finish {specular 0.8 roughness 0.01 phong 0.5 phong_size 200 diffuse 0.5 ambient Amb metallic 0.16 reflection 0.0}
  normal {granite 0.1 bump_size 0.5 scale <0.25,0.25,0.25> scale 0.05}
}

#declare Green_Stained_Plastic =
texture {
  pigment {
    bozo
    pigment_map {
      [0.2 color rgb<0.112,0.312,0.114>]
      [0.7 color rgb<0.416,0.316,0.158>]
    }
    scale 0.05
    turbulence <0.3,0.4,02>
  }
  finish {specular 0.4 roughness 0.1 phong 0.25 phong_size 100 diffuse 0.45 ambient Amb metallic 0.16 reflection 0.0}
  normal {granite 0.3 bump_size 0.925 scale <0.25,0.25,0.25> scale 0.1}
}

#declare Green_Plastic =
texture {
  wrinkles 
  texture_map {
    [0.3 Green_Plastic_x]
    [0.6 Green_Stained_Plastic]
  }
  scale <10,1,20>
  rotate y*33
} 

#declare Element_MembraneTexture =
texture {
  pigment {
    gradient z
    pigment_map {
      [0.1 color rgb<0.04,0.04,0.04>]
      [0.5 color rgb<0.12,0.12,0.12>*1.2]
      [0.9 color rgb<0.04,0.04,0.04>]
    }
    scale <1,1,0.3333>
  }
  finish {specular 0.1 roughness 0.1 phong 0.2 phong_size 200 diffuse 0.60 ambient Amb reflection 0.1}
  normal {granite 0.1 bump_size 0.075 scale <0.5,0.5,0.2>}
} 
#declare Element_RimTexture =
texture {
  pigment {color rgb<0.11,0.11,0.11>}
  finish {specular 0.15 roughness 0.08 phong 0.2 phong_size 300 diffuse 0.625 ambient Amb reflection 0.05}
  normal {granite 0.1 bump_size 0.075 scale <0.5,0.5,0.2>}
} 

#declare Black_Rubber =
texture {
  pigment {
    granite
    pigment_map {
      [0.5 color rgb<0.04,0.04,0.04>]
      [0.9 color rgb<0.10,0.10,0.10>]
    }
    turbulence 0.3
  }
  finish {specular 0.2 roughness 0.1 phong 0.2 phong_size 400 diffuse 0.60 ambient Amb crand 0.1}
  normal {granite 0.1 bump_size 0.075 scale <0.5,0.5,0.2>}
} 
#declare Red_Rubber =
texture {
  pigment {
    granite
    pigment_map {
      [0.5 color rgb<0.54,0.04,0.02>]
      [0.9 color rgb<0.50,0.10,0.05>]
    }
    turbulence 0.3
  }
  finish {specular 0.2 roughness 0.1 phong 0.2 phong_size 400 diffuse 0.50 ambient Amb crand 0.1}
  normal {granite 0.1 bump_size 0.075 scale <0.5,0.5,0.2>}
} 

#declare Grey_Fabric_x =
texture {
  pigment {
    granite
    pigment_map {
      [0.1 color rgb<0.25,0.275,0.3>]
      [0.9 color rgb<0.45,0.50,0.575>]
    }
    turbulence 0.7
    scale <10,1,1>
  }
  finish {specular 0.1 roughness 0.5 phong 0.2 phong_size 100 diffuse 0.55 ambient Amb crand 0.1}
  normal {granite 0.1 bump_size 0.075 scale <0.5,0.5,0.2>}
} 
#declare Grey_Stained_Fabric =
texture {
  pigment {
    granite
    pigment_map {
      [0.1 color rgb<0.25,0.275,0.2>]
      [0.9 color rgb<0.45,0.30,0.175>]
    }
    turbulence 0.7
    scale <10,1,1>
  }
  finish {specular 0.05 roughness 0.8 phong 0.3 phong_size 50 diffuse 0.515 ambient Amb crand 0.1}
  normal {granite 0.1 bump_size 0.025 scale <0.5,0.5,0.2>}
} 

#declare Grey_Fabric =
texture {
  wrinkles 
  texture_map {
    [0.5 Grey_Fabric_x]
    [0.8 Grey_Stained_Fabric]
  }
  scale <20,1,20>
} 


#declare White_Paper1 =
texture {
  pigment {
    granite
    pigment_map {
      [0.1 color rgb<0.994,0.9945,0.995>]
      [0.9 color rgb<0.995,0.995,0.995>]
    }
    turbulence 0.7
    scale <0.51,0.4,0.51>  
    scale 0.5
  }
  finish {specular 0.1 roughness 0.5 phong 0.05 phong_size 50 diffuse 0.45 ambient Amb crand 0.02}
  normal {
    average
    normal_map {
      [0.5 granite 0.01 bump_size 0.005 scale <0.25,0.25,0.2> scale 0.1]
      [0.5 crackle 0.09 bump_size 0.099 scale <20,71,30> scale <1,1,1> turbulence 1.27 octaves 7 lambda 3.2]
    }
  }
} 

#declare White_Paper2 =
texture {
  pigment {
    granite
    pigment_map {
      [0.1 color rgb<0.994,0.9945,0.995>]
      [0.9 color rgb<0.995,0.995,0.995>]
    }
    turbulence 0.7
    scale <0.51,0.4,0.51>  
    scale 0.5
  }
  finish {specular 0.1 roughness 0.5 phong 0.05 phong_size 50 diffuse 0.45 ambient Amb crand 0.02}
  normal {
    average
    normal_map {
      [0.5 granite 0.01 bump_size 0.005 scale <0.25,0.25,0.2> scale 0.1]
      [0.5 crackle 0.09 bump_size 0.099 scale <20,71,30> scale <1,3,4> turbulence 1.27 octaves 7 lambda 3.2]
    }
  }
} 
#declare PizzaBoxTexture =
texture {
  pigment {
    granite
    pigment_map {
      [0.1 color rgb<0.994,0.9945,0.995>]
      [0.9 color rgb<0.995,0.995,0.995>]
    }
    turbulence 0.7
    scale <0.51,0.4,0.51>  
    scale 0.5
  }
  finish {specular 0.5 roughness 0.2 phong 0.35 phong_size 150 diffuse 0.75 ambient Amb crand 0.02}
  normal {
    average
    normal_map {
      [0.5 bumps 0.01 bump_size 0.005 scale <0.25,0.25,0.2>]
      [0.5 crackle 0.09 bump_size 0.099 scale <20,71,30> scale <1,1,4> turbulence 1.27 octaves 7 lambda 3.2]
    }
  }
//  normal {bumps 0.01 bump_size 0.0005 scale <0.925,0.025,0.92>}
} 
#declare PizzaBoxTexture_Yellow =
texture {
  pigment {
    granite
    pigment_map {
      [0.1 color rgb<0.994,0.9945,0.095>]
      [0.9 color rgb<0.995,0.995,0.095>]
    }
    turbulence 0.7
    scale <0.51,0.4,0.51>  
    scale 0.5
  }
  finish {specular 0.5 roughness 0.02 phong 0.95 phong_size 350 diffuse 0.65 ambient Amb crand 0.02}
  normal {
    average
    normal_map {
      [0.5 bumps 0.01 bump_size 0.005 scale <0.25,0.25,0.2>]
      [0.5 crackle 0.09 bump_size 0.099 scale <20,71,30> scale <1,1,4> turbulence 1.27 octaves 7 lambda 3.2]
    }
  }
//  normal {bumps 0.01 bump_size 0.0005 scale <0.925,0.025,0.92>}
} 


#declare Black_Paper =
texture {
  pigment {
    granite
    pigment_map {
      [0.1 color rgb<0.0994,0.09945,0.0995>]
      [0.9 color rgb<0.0995,0.0995,0.0995>]
    }
    turbulence 0.7
    scale <0.51,0.4,0.51>  
    scale 0.5
  }
  finish {specular 0.1 roughness 0.5 phong 0.05 phong_size 50 diffuse 0.45 ambient Amb crand 0.02}
  normal {
    average
    normal_map {
      [0.5 granite 0.01 bump_size 0.005 scale <0.25,0.25,0.2> scale 0.1]
      [0.5 crackle 0.09 bump_size 0.099 scale <20,71,30> scale <1,1,4> turbulence 1.27 octaves 7 lambda 3.2]
    }
  }
//  normal {granite 0.01 bump_size 0.005 scale <0.25,0.25,0.2> scale 0.1}
} 


#declare MouseMat_Texture =
texture {
  gradient y
  texture_map {
    [0.00 Black_Rubber]
    [0.90 Black_Rubber]
    [0.95 Grey_Fabric]
    [1.00 Grey_Fabric]
  }
}
#declare AmyMat_Texture =
texture {
  gradient y
  texture_map {
    [0.000 Black_Rubber]
    [0.475 Black_Rubber]
    [0.525 Green_Plastic]
    [1.000 Green_Plastic]
  }
}




#declare SmallLight1 =
light_source {
  <0,0,0>
  color rgb<2,2,2>*2*lightpower
  fade_distance 0.5/(lightpower*0.85)
  fade_power 3
}
#declare SmallLight2 =
light_source {
  <0,0,0>
  color rgb<2,2,2>*1*lightpower
  fade_distance 0.75/(lightpower*0.85)
  fade_power 3
}
#declare SmallLight2gr =
light_source {
  <0,0,0>
  color rgb<0.5,1,0.35>*2*lightpower
  fade_distance 0.75/(lightpower*0.85)
  fade_power 3
}
#declare SmallLight2rd =
light_source {
  <0,0,0>
  color rgb<1.0,0.1,0.05>*2*lightpower
  fade_distance 0.75/(lightpower*0.85)
  fade_power 3
}





///////////////////////

/*Beercan*/

#declare BeerCan_Flap =
difference {
  union {  
    cone {<0.25,0,0>,0.5<1.25,0,0>,0.75 scale <1,0.1,1>}
    sphere {<0,0,0>,0.5 scale <0.5,1,1> translate <0.25,0,0> scale <1,0.1,1>}
    sphere {<0,0,0>,0.75 scale <0.40,1,1> translate <1.25,0,0> scale <1,0.1,1>}
    sphere {<0,0,0>,0.15 scale <1,0.66666,1>}
  }
  sphere {<0,0,0>,0.4 scale <0.5,1,1> translate <0.3,0,0>}
  sphere {<0,0,0>,0.6 scale <0.5,1,0.9> translate <1.0,0,0>}
  texture {CanAluminum}
}

#declare BeerCan_Base =
union {
  cylinder {<0,0.2,0>,<0,12.6,0>,2.5 open texture {Label_Texture scale <1,12.8,1>}}//main can
  union {//top+bottom
    cone {<0,0.20001,0>,2.45<0,0.025,0>,2.25}
    difference {
      union {
        cone {<0,12.60001,0>,2.45<0,13.00,0>,2.15}
        cone {<0,12.99999,0>,0.75<0,13.05,0>,0.70}
      }
      cone {<0,12.59998,0>,2.40<0,12.95,0>,2.10}
      sphere {<0,0.0,0>,0.75 scale <1,0.25,1.4> translate <-0.9,13.05,0>}
/*
      union {
        cone {<1.5,0,0>,0.75<0.25,0,0>,0.2}
        sphere {<0,0,0>,0.75 scale <0.3333,0,0> translate <1.5,0,0>}
        scale y*20
        translate <0,12.775,0>
      }
*/      
    }
    sphere {<0,0.0,0>,0.2 scale <1,0.5,1> translate y*13.05}
    torus {2.25,0.075 translate y*0.04999}
    torus {2.10,0.1 translate y*13.0}

    torus {2.40,0.1 translate y*12.6}
    texture {CanAluminum}
  }
}

#declare BeerCan_1 =
union {
  object {BeerCan_Base}
  object {BeerCan_Flap rotate z*15 translate <0,13.1250,0>}
  scale 1.25
}
#declare BeerCan_2 =
union {
  object {BeerCan_Base}
  object {BeerCan_Flap rotate z*21 translate <0,13.1250,0>}
  scale 1.25
}
#declare BeerCan_3 =
union {
  object {BeerCan_Base}
  object {BeerCan_Flap rotate z*24 rotate y*-1 translate <0,13.1250,0>}
  scale 1.25
}
#declare BeerCan_4 =
union {
  object {BeerCan_Base}
  object {BeerCan_Flap rotate z*12 rotate y*5 translate <0,13.1250,0>}
  scale 1.25
}

#declare Beercans1 =
union {
//  object {BeerCan_1 rotate y*44 translate <0,0,-0>}
  object {BeerCan_2 rotate y*124 translate <1*1.25,0,-8*1.25>}
  object {BeerCan_3 rotate y*-14 translate <7.5*1.25,0,-6*1.25>}
  object {BeerCan_4 rotate y*-254 translate <6*1.25,0,0.5*1.25>}
}
#declare Beercans2 =
union {
  object {BeerCan_1 rotate y*44 translate <0,0,-0>}
  object {BeerCan_2 rotate y*124 translate <1*1.25,0,-8*1.25>}
  object {BeerCan_3 rotate y*-14 translate <7.5*1.25,0,-6*1.25>}
  object {BeerCan_4 rotate y*-254 translate <6*1.25,0,0.5*1.25>}
}


///////////////////////

/*
    stuph
*/

#include "woods.inc"
#declare T_Wood34_x =
//texture {
  texture { 
    pigment { P_WoodGrain1A  color_map { M_Wood1A }}
    finish {diffuse 0.5 specular 0.05 roughness 0.28 phong 0.070 phong_size 48 crand 0.01 ambient Amb}
    normal {average normal_map{[0.5 crackle 0.88 scale <0.07,0.07,0.3> bump_size 0.4*2][0.5 granite 0.22 scale 0.14 bump_size 0.4*1.7]} scale<0.5,0.5,1>}
    scale 1.22
  }
  texture { 
    pigment { P_WoodGrain1B  color_map { M_Wood1B }}
    finish {diffuse 0.5 specular 0.05 roughness 0.28 phong 0.070 phong_size 48 crand 0.01 ambient Amb}
    normal {average normal_map{[0.5 crackle 0.88 scale <0.07,0.07,0.3> bump_size 0.4*2][0.5 granite 0.22 scale 0.14 bump_size 0.4*1.7]} scale<0.5,0.5,1>}
    scale 1.22
  }
//}
/*
texture { T_Wood32 rotate x*-0}
texture  {
  pigment {
    onion
    turbulence 0.2125
    colour_map {
      [0.225 colour rgbf <1.000000*0.5, 0.53333*0.5, 0.11767*0.5, 0.4875>]
      [0.350 colour rgbf <0.662750*0.5, 0.28617*0.5, 0.00001*0.5, 0.7250>]
      [0.500 colour rgbf <1.000100*0.5, 0.53333*0.5, 0.11765*0.5, 0.5745>]
      [0.625 colour rgbf <0.662775*0.5, 0.28627*0.5, 0.00005*0.5, 0.6875>]
      [0.750 colour rgbf <1.000200*0.5, 0.53333*0.5, 0.11755*0.5, 0.5275>]
      [0.875 colour rgbf <0.662755*0.5, 0.28629*0.5, 0.00001*0.5, 0.3795>]
      [1.000 colour rgbf <1.000000*0.5, 0.53333*0.5, 0.11665*0.5, 0.6165>]
    }
    scale <0.225, 0.20, 1.15>
    scale 0.5
  }
  /*rotate y*-1*/ rotate x*1
}
*/
#declare Darkpt = texture {
  pigment {color rgb<0.1,0.1,0.1>} 
  finish {diffuse 0.05 specular 0.01 roughness 0.38 phong 0.030 phong_size 48 crand 0.01 ambient Amb}
}
#declare WboardWood_1b =
texture {
  gradient x
  texture_map {
    [0.000 Darkpt]
    [0.001 T_Wood34_x scale 0.125 translate x*-0.05 rotate x*+1.6 translate <-0,+0,+3>]
    [0.099 T_Wood34_x scale 0.125 translate x*-0.05 rotate x*+1.6 translate <-0,+0,+3>]
    [0.100 Darkpt]
    [0.101 T_Wood34_x scale 0.125 translate x*-0.15 rotate x*-1.3 translate <+0,-0,-4>]
    [0.199 T_Wood34_x scale 0.125 translate x*-0.15 rotate x*-1.3 translate <+0,-0,-4>]
    [0.200 Darkpt]
    [0.201 T_Wood34_x scale 0.125 translate x*-0.25 rotate x*-1.1 translate <+0,+0,+1>]
    [0.299 T_Wood34_x scale 0.125 translate x*-0.25 rotate x*-1.1 translate <+0,+0,+1>]
    [0.300 Darkpt]
    [0.301 T_Wood34_x scale 0.125 translate x*-0.35 rotate x*+1.3 translate <-0,+0,+3>]
    [0.399 T_Wood34_x scale 0.125 translate x*-0.35 rotate x*+1.3 translate <-0,+0,+3>]
    [0.400 Darkpt]
    [0.401 T_Wood34_x scale 0.125 translate x*-0.45 rotate x*-1.2 translate <+0,-0,-7>]
    [0.499 T_Wood34_x scale 0.125 translate x*-0.45 rotate x*-1.2 translate <+0,-0,-7>]
    [0.500 Darkpt]
    [0.501 T_Wood34_x scale 0.125 translate x*-0.55 rotate x*+1.5 translate <-0,+0,-2>]
    [0.599 T_Wood34_x scale 0.125 translate x*-0.55 rotate x*+1.5 translate <-0,+0,-2>]
    [0.600 Darkpt]
    [0.601 T_Wood34_x scale 0.125 translate x*-0.65 rotate x*+1.3 translate <+0,-0,+1>]
    [0.699 T_Wood34_x scale 0.125 translate x*-0.65 rotate x*+1.3 translate <+0,-0,+1>]
    [0.700 Darkpt]
    [0.701 T_Wood34_x scale 0.125 translate x*-0.75 rotate x*-1.4 translate <+0,+0,+6>]
    [0.799 T_Wood34_x scale 0.125 translate x*-0.75 rotate x*-1.4 translate <+0,+0,+6>]
    [0.800 Darkpt]
    [0.801 T_Wood34_x scale 0.125 translate x*-0.85 rotate x*-1.7 translate <-0,+0,+2>]
    [0.899 T_Wood34_x scale 0.125 translate x*-0.85 rotate x*-1.7 translate <-0,+0,+2>]
    [0.900 Darkpt]
    [0.901 T_Wood34_x scale 0.125 translate x*-0.95 rotate x*+1.5 translate <+0,-0,+7>]
    [0.999 T_Wood34_x scale 0.125 translate x*-0.95 rotate x*+1.5 translate <+0,-0,+7>]
    [1.000 Darkpt]
  }
//  finish {diffuse 0.5 specular 0.05 roughness 0.28 phong 0.070 phong_size 48 crand 0.01 ambient Amb}
//  normal {average normal_map{[0.5 crackle 0.88 scale <0.07,0.07,0.3> bump_size 0.4*9][0.5 granite 0.22 scale 0.14 bump_size 0.4*7]} scale<0.5,0.5,1>}
}
#declare WboardWood_2b =
texture {
  T_Wood32
  finish {diffuse 0.5 specular 0.065 roughness 0.31 phong 0.084 phong_size 47 crand 0.01 ambient Amb}
  normal {average normal_map{[0.5 crackle 0.87 scale <0.073,0.073,0.3> bump_size 0.4*9][0.5 granite 0.23 scale 0.15 bump_size 0.4*7]} scale<0.5,0.5,1>}
}


#declare Table =
union {
  union {
    box {<-75,-3,-50>,<75,0,50>}
    cylinder {<-75,-1.5,-0>,<75,-1.5,0>,1.500001 scale <1,1,0.5> translate <0,0,-50>}
    cylinder {<-75,-1.5,-0>,<75,-1.5,0>,1.500001 scale <1,1,0.5> translate <0,0,+50>}
    cylinder {<-50,-1.5,-0>,<50,-1.5,0>,1.500001 scale <1,1,0.5> rotate y*90 translate <-75,0,0>}
    cylinder {<-50,-1.5,-0>,<50,-1.5,0>,1.500001 scale <1,1,0.5> rotate y*90 translate <+75,0,0>}
    sphere {<0,-1.5,0>,1.500002 scale <0.5,1,0.5> translate <-75,0,-50>}
    sphere {<0,-1.5,0>,1.500002 scale <0.5,1,0.5> translate <+75,0,-50>}
    sphere {<0,-1.5,0>,1.500002 scale <0.5,1,0.5> translate <+75,0,+50>}
    sphere {<0,-1.5,0>,1.500002 scale <0.5,1,0.5> translate <-75,0,+50>}
    texture {
      WboardWood_1b rotate y*90 scale 100 /*translate x*75 */
/*      
      pigment {color rgb<0.4,0.4,0.4>} 
      finish {specular 0.1 diffuse 0.5 ambient Amb} 
      normal {granite 0.1 bump_size 0.075 scale <5,1.5,2> rotate <0,33.54,9> scale <1,1,1.3>}
*/      
    }
  }
  union {
    cylinder {<-65,-1,-40>,<-65,-100,-40>,2}
    cylinder {<+65,-1,-40>,<+65,-100,-40>,2}
    cylinder {<+65,-1,+40>,<+65,-100,+40>,2}
    cylinder {<-65,-1,+40>,<-65,-100,+40>,2}
    texture {TableLegChrome}
  }
}

#declare GlassT = texture {pigment {color rgbt<1,1,1,1>} finish {diffuse 1.0}}
#declare Beer = 
texture {
  pigment {color rgbf<0.4,0.27,0.05,0.875>}
  finish {specular 0.9 roughness 0.091 phong 0.9 phong_size 200 diffuse 0.5 ambient Amb metallic 0.4 reflection 0.6 reflect_metallic 0.6}
/*
  normal {
    average
    normal_map {
      [0.5 bozo 0.6 bump_size 1.0 scale <1.0,1.5,1.0>]// turbulence <0.056,0.1,0.055>+<0.36,0.1,0.45>]
//      [0.5 bumps 0.36 bump_size 0.8 scale <0.90,0.5,0.90> turbulence <0.056,0.1,0.055>+<0.36,0.1,0.45>]
    }  
    scale <0.8,1,0.8>
  }  
*/  
}
  
#declare BeerSpillText_x =
texture {
  wrinkles
  texture_map {
    [0.00 Beer]
    [0.39 Beer]
    [0.43 GlassT]
    [1.00 GlassT]
  }
  scale 0.5
  turbulence <0.156,0.1,0.155>
}

#declare BeerSpillText =
texture {
  spherical
  texture_map {
    [0.00 GlassT]
    [0.09 GlassT]
    [0.18 BeerSpillText_x]
    [1.00 BeerSpillText_x]
  }
//  turbulence <0.36,0.1,0.45>
}

#declare BeerSpill =
box {<-15,-1,-15>,<15,0.05,15> hollow /*no_shadow*/ texture {BeerSpillText scale <20,1,20> translate <-4,0,0>}}





#declare Screw =
union {
  difference {
    cone {<0,0,-0.125>,0.225<0,0,0>,0.25}
    box {<-0.3,-0.065,-0.2>,<0.3,0.065,-0.001>}
  }
  cylinder {<0,0,0>,<0,0,0.75>,0.1125}
}

#declare Bass_Element =
union {
  union {
    cone {<0,0,0>,6.01<0,0,2.5>,1.49 open}
    sphere {<0,0,0>,1.5 scale <1,1,0.5> translate <0,0,2.5>}
    texture {Element_MembraneTexture}
  }
  difference {
    cylinder {<0,0,-0.20>,<0,0,0.25>,7.0}
    cylinder {<0,0,-0.35>,<0,0,0.35>,6.0}
    texture {Element_RimTexture}
  }
  union {
    object {Screw rotate z*+131 translate <-6.725,0,-0.21> rotate z*000}
    object {Screw rotate z*+252 translate <-6.725,0,-0.21> rotate z*045}
    object {Screw rotate z*-312 translate <-6.725,0,-0.21> rotate z*090}
    object {Screw rotate z*+473 translate <-6.725,0,-0.21> rotate z*135}
    object {Screw rotate z*-543 translate <-6.725,0,-0.21> rotate z*180}
    object {Screw rotate z*-612 translate <-6.725,0,-0.21> rotate z*225}
    object {Screw rotate z*+753 translate <-6.725,0,-0.21> rotate z*270}
    object {Screw rotate z*-867 translate <-6.725,0,-0.21> rotate z*315}  
    texture {ScrewTexture}
  }
}
#declare Mid_Element =
union {
  union {
    cone {<0,0,0>,3.01<0,0,1.75>,0.99 open}
    sphere {<0,0,0>,1.0 scale <1,1,0.5> translate <0,0,1.75>}
    texture {Element_MembraneTexture}
  }
  difference {
    cylinder {<0,0,-0.15>,<0,0,0.25>,3.75}
    cylinder {<0,0,-0.35>,<0,0,0.35>,3.0}
    texture {Element_RimTexture}
  }  
  union {
    object {Screw rotate z*+0142 translate <-3.425,0,-0.16> rotate z*045}
    object {Screw rotate z*-251 translate <-3.425,0,-0.16> rotate z*135}
    object {Screw rotate z*+325 translate <-3.425,0,-0.16> rotate z*225}
    object {Screw rotate z*-441 translate <-3.425,0,-0.16> rotate z*315}  
    texture {ScrewTexture}   
  }
}
#declare Hi_Element =
union {
  union {
    cone {<0,0,0>,1.51<0,0,1.0>,0.49 open}
    sphere {<0,0,0>,0.5 scale <1,1,0.5> translate <0,0,1.0>}
    texture {Element_MembraneTexture}
  }
  difference {
    cylinder {<0,0,-0.15>,<0,0,0.25>,2.0}
    cylinder {<0,0,-0.35>,<0,0,0.35>,1.5}
    texture {Element_RimTexture}
  }  
  union {
    object {Screw rotate z*-178 translate <-1.75,0,-0.16> rotate z*000}
    object {Screw rotate z*+223 translate <-1.75,0,-0.16> rotate z*090}
    object {Screw rotate z*-363 translate <-1.75,0,-0.16> rotate z*180}
    object {Screw rotate z*+486 translate <-1.75,0,-0.16> rotate z*270}
    texture {ScrewTexture}
  }
}
   
   
#declare Speaker =
union {
  difference {
    box {<-12.5,1,0>,<12.5,39,1>}
    cylinder {<0,12,-1>,<0,12,2>,6}
    cylinder {<0,26,-1>,<0,26,2>,3}
    cylinder {<0,34,-1>,<0,34,2>,1.5}
    texture {BlackWood}
  }
  difference {
    box {<-13,0,-1>,<13,40,20>}
    box {<-12.25,1.25,-2>,<12.25,38.75,19>}
    texture {DarkWood}
  }
  object {Bass_Element translate <0,12,0>}
  object {Mid_Element translate <0,26,0>}
  object {Hi_Element translate <0,34,0>}
  union {
    object {Screw rotate z*-143 scale 1.5 translate <-11.5,2.5,-0.0>}
    object {Screw rotate z*+434 scale 1.5 translate <+11.5,2.5,-0.0>}
    object {Screw rotate z*-263 scale 1.5 translate <-11.5,37.5,-0.0>}
    object {Screw rotate z*+393 scale 1.5 translate <+11.5,37.5,-0.0>}
    texture {ScrewTexture}
  }
}

#declare Potikkah =
union {
  cylinder {<0,0,0>,<0,0,-1.5>,0.75}
  cylinder {<0,0,0>,<0,0,-1.6>,0.65}
  torus {0.65,0.1 rotate x*90 translate <0,0,-1.5>}
  sphere {<0,0,0>,0.65 scale <1,1,0.05> translate <0,0,-1.6>}
  texture {BlackPlastic}
}
#declare Potikkah2 =
union {
  cylinder {<0,0,0>,<0,0,-1.5>,2.25}
  cylinder {<0,0,0>,<0,0,-1.6>,2.15}
  torus {2.15,0.1 rotate x*90 translate <0,0,-1.5>}
  sphere {<0,0,0>,2.15 scale <1,1,0.05> translate <0,0,-1.6>}
  texture {BlackPlastic}
}

//something similar to a Yamaha AX-380

#declare Amplifier =
union {
  difference {
    box {<-4.9,0.1,0.5>,<4.9,39.9,30>}
    texture {DarkPlastic}
  }
  difference {
    union {
      cylinder {<-1.5,0,0>,<-1.5,40,0>,3.45 scale <1,1,0.05>}
      cylinder {<+3.5,0,0>,<+3.5,40,0>,1.45 scale <1,1,0.05>}
      box {<-4.95,0,0>,<1.95,40,3>}
      box {<+4.95,0,0>,<2.05,40,3>}
    }
    //potikka holes
    cylinder {<0,0,-1.0>,<0,0,1>,2.35 translate <-1.5,5,0>}
    cylinder {<0,0,-1.0>,<0,0,1>,0.85 translate <-3.0,10,0>}
    cylinder {<0,0,-1.0>,<0,0,1>,0.85 translate <-3.0,15,0>}
    cylinder {<0,0,-1.0>,<0,0,1>,0.85 translate <-3.0,20,0>}
    cylinder {<0,0,-1.0>,<0,0,1>,0.85 translate <-3.0,25,0>}
    //button holes
    //speaker buttons
    box {<-3.2,33,-1>,<-2.8,36,1>}
    //power switch
    box {<2.0,36,-1>,<3.0,37.5,1>}
    //other buttons
    box {<2.0,9.25,-1>,<2.75,21.25,1>}
    //mute
    box {<2.0,4.00,-1>,<2.75,6.0,1>}
    
    //light holes for other buttons
    box {<3.0,11.0,-0.25>,<3.25,11.25,0.5>}
    box {<3.0,13.0,-0.25>,<3.25,13.25,0.5>}
    box {<3.0,15.0,-0.25>,<3.25,15.25,0.5>}
    box {<3.0,17.0,-0.25>,<3.25,17.25,0.5>}
    box {<3.0,19.0,-0.25>,<3.25,19.25,0.5>}
    box {<3.0,21.0,-0.25>,<3.25,21.25,0.5>}
    //light hole for power switch
    box {<3.25,37.25,-0.25>,<3.50,37.5,0.5>}
    
    texture {BlackPlastic}
  }
  intersection {
    difference {
      union {      
        cylinder {<+3.5,0,0>,<+3.5,40,0>,1.45 scale <1,1,0.05>}
        box {<+4.95,0,0>,<2.05,40,3>}
       translate <0,0,0.05>
      }
      box {<2.0,36,-1>,<3.05,37.5,1>}
    }
    box {<2.99,5,-2>,<3.51,38,0.5>}
    texture {RedPlastic}
  }
  union {//bogusbuttons
    //speakerbuttons
    box {<-3.15,33.05,-0.25>,<-2.85,34.45,0.25>}    
    box {<-3.15,34.55,-0.25>,<-2.85,35.95,0.25>}
    //power switch
    box {<2.05,36.05,-0.25>,<2.95,37.45,0.25>}
    //mute
    box {<2.05,4.05,-0.45>,<2.70,5.95,0.5>}
    //other buttons, 6
    box {<2.05,9.30,-0.25>,<2.70,11.20,0.5>}
    box {<2.05,11.30,-0.25>,<2.70,13.20,0.5>}
    box {<2.05,13.30,-0.25>,<2.70,15.20,0.5>}
    box {<2.05,15.30,-0.25>,<2.70,17.20,0.5>}
    box {<2.05,17.30,-0.25>,<2.70,19.20,0.5>}
    box {<2.05,19.30,-0.25>,<2.70,21.20,0.5>}
    texture {BlackPlastic}
  } 
  
  object {Potikkah2 translate <-1.5,5,0>}
  object {Potikkah translate <-3.0,10,0>}
  object {Potikkah translate <-3.0,15,0>}
  object {Potikkah translate <-3.0,20,0>}
  object {Potikkah translate <-3.0,25,0>}
  //power light
  object {SmallLight1 translate <3.375,37.375,0.1>}
  object {SmallLight2rd translate <3.375,37.375,-0.1>}
  //aux light
  object {SmallLight1 translate <3.125,17.125,0.1>}
  object {SmallLight2rd translate <3.125,17.125,-0.1>}

}
















//////////////////////

#declare MouseMat =
intersection {
  superellipsoid {<0.15,0.15> scale <12,0.3,10.5> translate y*0.0}
  box {<-15.25,-0.25,-15.75>,<15.25,0.275,15.75>}
  texture {MouseMat_Texture scale 0.51 translate y*-0.225}
  translate y*0.25
}
#declare MatUnderAmy =
difference {
  intersection {
    superellipsoid {<0.05,0.05> scale <28,0.3,20> translate y*0.0}
    box {<-37.75,-0.25,-21.75>,<37.75,0.275,21.75>}
  }
  superellipsoid {<0.05,0.05> scale <27.25,0.3,19.25> translate y*0.275}
  texture {Green_Plastic scale 1.0 translate y*-0.650}
  translate y*0.25
}

/////////////////////////

//mouse

//11 cm long, 6.75 cm wide, 3.25cm tall (at tallest)

#declare AmigaMouse =
union {
  difference {//top part
    union {
      box {<-2.975,0,-5.5>,<2.975,3,5.5>}
      box {<-3.375,0,-5.1>,<3.375,3,5.1>}
      cylinder {<-2.975,0,-5.1>,<-2.975,3,-5.1>,0.400001}
      cylinder {<+2.975,0,-5.1>,<+2.975,3,-5.1>,0.400001}
      cylinder {<+2.975,0,+5.1>,<+2.975,3,+5.1>,0.400001}
      cylinder {<-2.975,0,+5.1>,<-2.975,3,+5.1>,0.400001}
    }
    box {<-20,0,-20>,<20,20,20> rotate z*+45 rotate x*7 translate <-2.375,2.5,0>}//side
    box {<-20,0,-20>,<20,20,20> rotate z*-45 rotate x*7 translate <+2.375,2.5,0>}//side
    box {<-20,0,-20>,<20,20,20> rotate x*-16.25 translate <0,3,-2.5>}//back
    box {<-20,0,-20>,<20,20,20> rotate x*28.00 translate <0,1.675,4.0>}//front
    box {<-20,0,-20>,<20,20,20> rotate x*10.0 translate <0,3,-2.5>}//top
    box {<-20,-2,-20>,<20,0,20> rotate x*6.0 translate <0,1.7,-5.5>}//bottom
    //keys
    box {<-0.8,0,-1.4>,<0.8,5,1.4> translate <-3.375+2.1,0.5,5.5-(0.75+1.4)>}
    box {<-0.8,0,-1.4>,<0.8,5,1.4> translate <+3.375-2.1,0.5,5.5-(0.75+1.4)>}   
    texture {AmiPlastic}
  }
  difference {//mid part
    union {
      box {<-2.975,0,-5.5>,<2.975,3,5.5>}
      box {<-3.375,0,-5.1>,<3.375,3,5.1>}
      cylinder {<-2.975,0,-5.1>,<-2.975,3,-5.1>,0.400001}
      cylinder {<+2.975,0,-5.1>,<+2.975,3,-5.1>,0.400001}
      cylinder {<+2.975,0,+5.1>,<+2.975,3,+5.1>,0.400001}
      cylinder {<-2.975,0,+5.1>,<-2.975,3,+5.1>,0.400001}
    }
    box {<-20,+0,-20>,<20,20,20> rotate x*6.0 translate <0,1.6,-5.5>}//top
    box {<-20,-2,-20>,<20,0,20> rotate x*5.0 translate <0,1.1,-5.5>}//bottom
    texture {AmiPlastic}
  }
  difference {//inside part
    union {
      box {<-2.975,0,-5.5>,<2.975,3,5.5>}
      box {<-3.375,0,-5.1>,<3.375,3,5.1>}
      cylinder {<-2.975,0,-5.1>,<-2.975,3,-5.1>,0.400001}
      cylinder {<+2.975,0,-5.1>,<+2.975,3,-5.1>,0.400001}
      cylinder {<+2.975,0,+5.1>,<+2.975,3,+5.1>,0.400001}
      cylinder {<-2.975,0,+5.1>,<-2.975,3,+5.1>,0.400001}
      scale <0.985,1,0.985>
    }
    box {<-20,+0,-20>,<20,20,20> rotate x*6.0 translate <0,1.8,-5.5>}//top
    box {<-20,-2,-20>,<20,0,20> rotate x*5.0 translate <0,1.2,-5.5>}//bottom
    texture {AmiPlastic}
  }
  difference {//bottom part
    union {
      box {<-2.675,0,-5.5>,<2.675,1.5,5.5>}
      box {<-3.375,0,-4.8>,<3.375,1.5,4.8>}
      cylinder {<-2.675,0,-4.8>,<-2.675,1.5,-4.8>,0.700001}
      cylinder {<+2.675,0,-4.8>,<+2.675,1.5,-4.8>,0.700001}
      cylinder {<+2.675,0,+4.8>,<+2.675,1.5,+4.8>,0.700001}
      cylinder {<-2.675,0,+4.8>,<-2.675,1.5,+4.8>,0.700001}
      scale <0.975,1,0.975>
    }
    box {<-20,-20,-20>,<20,20,0> rotate x*-22.5 translate <0,1.5,-5.5>}//back
    box {<-20,+0,-20>,<20,20,20> rotate x*6.0 translate <0,1.4,-5.5>}//top
    texture {AmiPlastic}
  }
  difference {//keys
    union {
      box {<-0.75,-5,-1.35>,<0.75,0.3,1.35> rotate x*17 translate <-3.375+2.1,1.75,5.5-(0.75+1.4)>}
      box {<-0.75,-5,-1.35>,<0.75,0.3,1.35> rotate x*17 translate <+3.375-2.1,1.75,5.5-(0.75+1.4)>}   
    }
    box {<-20,-20,-20>,<20,20,0.05> rotate x*33 translate <0,1.75,5.5-(2.8+0.75)>}
    box {<-20,-20,-0.05>,<20,20,20> rotate x*-5 translate <0,1.75,5.5-0.75>}
    box {<-20,-20,-21>,<20,20,0.05> translate <0,1.75,5.5-(2.8+0.75)>}
    texture {Key_Dark}
  }
}


///tha joystick

#declare AtariJoy =
union {
  //le box
  difference {
    union {
      box {<-3.875,0,-4.75>,<3.875,3.5,4.75>}
      box {<-4.375,0,-4.25>,<4.375,3.5,4.25>}
      cylinder {<-3.875,0,-4.25>,<-3.875,3.5,-4.25>,0.5}
      cylinder {<+3.875,0,-4.25>,<+3.875,3.5,-4.25>,0.5}
      cylinder {<+3.875,0,+4.25>,<+3.875,3.5,+4.25>,0.5}
      cylinder {<-3.875,0,+4.25>,<-3.875,3.5,+4.25>,0.5}
    }           
    box {<-40,0.1,-40>,<40,40,40> rotate x*-33.333 translate <0,3.25,-4.5> rotate y*000.000}
    box {<-40,0.1,-40>,<40,40,40> rotate x*-33.333 translate <0,3.25,-4.5> rotate y*180.000}
    box {<-40,0.1,-40>,<40,40,40> rotate x*-33.333 rotate y*90 translate <-3.625,3.25,0> rotate y*000.000}
    box {<-40,0.1,-40>,<40,40,40> rotate x*-33.333 rotate y*90 translate <-3.625,3.25,0> rotate y*180.000}

    box {<-40,-40,-40>,<40,0,40> rotate x*85 translate <0,0,-4.25> rotate y*000}
    box {<-40,-40,-40>,<40,0,40> rotate x*85 translate <0,0,-4.25> rotate y*180}
    box {<-40,-40,-40>,<40,0,40> rotate x*85 rotate y*90 translate <-3.375,0,0> rotate y*000}
    box {<-40,-40,-40>,<40,0,40> rotate x*85 rotate y*90 translate <-3.375,0,0> rotate y*180}
    
    cylinder {<0,1,-0.75>,<0,4,-0.75>,2.20}
    cylinder {<-2.125,1,3.0>,<-2.125,4,3.0>,0.80}
    
    texture {DarkPlastic2}
  }
  //le stich
  union {     
    union {
      cylinder {<0,3.0,0>,<0,3.55,0>,2.25}
      cylinder {<0,3.1,0>,<0,3.60,0>,2.00}
      cylinder {<0,3.2,0>,<0,3.65,0>,1.75}
      cylinder {<0,3.3,0>,<0,3.75,0>,1.50}
      cylinder {<0,3.4,0>,<0,4.00,0>,1.25}
      cylinder {<0,3.5,0>,<0,4.25,0>,1.00}
      cylinder {<0,3.6,0>,<0,4.50,0>,0.75}
      translate <0,0,-0.75>
      texture {Black_Rubber}
    }
    
    difference {
      union {
        cylinder {<0,3,0>,<0,9,0>,0.875}
        sphere {<0,0,0>,0.875 scale <1,0.1,1> translate y*9}
      } 
      box {<-20,-20,-20>,<20,20,0> translate <0,0,-0.75> rotate y*000}
      box {<-20,-20,-20>,<20,20,0> translate <0,0,-0.75> rotate y*060}
      box {<-20,-20,-20>,<20,20,0> translate <0,0,-0.75> rotate y*120}
      box {<-20,-20,-20>,<20,20,0> translate <0,0,-0.75> rotate y*180}
      box {<-20,-20,-20>,<20,20,0> translate <0,0,-0.75> rotate y*240}
      box {<-20,-20,-20>,<20,20,0> translate <0,0,-0.75> rotate y*300}
      translate <0,0,-0.75>
      texture {DarkPlastic}
    }
  }
  difference {
    union {
      cylinder {<0,0,0>,<0,3.5,0>,0.75}
      sphere {<0,0,0>,0.75 scale <1,0.1,1> translate y*3.5}
    }
    sphere {<0,0,0>,0.7 scale <1,0.125,1> translate y*3.6}
    translate <-2.125,0,3.0>
    texture {Red_Rubber}
  }
}










//////////////////////
/*


Bogus computer monitor...


*/
/////////////////777//


#declare MonitorLight =
light_source {
  <0,0,0>
//  color rgb<0.7,0.85,1.0>*1.0
  color rgb<40/255,90/255,168/255>*1.25*lightpower
  #if(Area_dec=true)
    area_light <22.0,0,0>, <0,17.0,0>, 12, 9 // normal
    adaptive 1
    jitter
//    circular
  #else
  #end
  fade_distance 100/(lightpower*0.85)
  fade_power 2
  media_interaction off
  media_attenuation off
}
#declare MonitorLight_g =
light_source {
  <0,0,0>
  color rgb<1,0.05,0>*1.25*lightpower
  #if(Area_dec=true)
    area_light <22.0,0,0>, <0,4.0,0>, 12, 5 // normal
    adaptive 1
    jitter
  #else
  #end
  fade_distance 15/(lightpower*0.85)
  fade_power 3
  media_interaction off
  media_attenuation off
}
/*
#declare ScreenTexture =
texture {
  pigment {image_map{iff "wb13.iff"} translate <-0.5,-0.5,0> scale <25,18,0>}
  finish {diffuse 0.002 specular 0.7 roughness 0.0001 phong 0.9 phong_size 1200 ambient 1.0}
}
#declare ScreenTexture2 =
texture {
  pigment {image_map{iff "wb13.iff"} translate <-0.5,-0.5,0> scale <24.5,17.5,0>}
  finish {diffuse 0.002 specular 0.7 roughness 0.0001 phong 0.9 phong_size 1200 ambient 1.0}
} 
*/
#declare ScreenTexture3 =
texture {
  pigment {image_map{iff "gurumed.iff"} translate <-0.5,-0.5,0> scale <24.5,17.5,0>}
  finish {diffuse 0.09*2 specular 0.7 roughness 0.001*10 phong 0.9 phong_size 1200 metallic 0.6 ambient 1.0 reflection 0.3 reflect_metallic 0.9 }
}
/*
#declare BogusMonitor_x =
union {
  box {<-12.75,-9.25,-0.01>,<12.75,9.25,2> hollow no_shadow texture {ScreenTexture2}}
  union {
    box {<-15,-11.5,-1.00004>,<-12.5,11.5,15>}
    box {<+15,-11.5,-1.00003>,<+12.5,11.5,15>}
    box {<-14,-11.5,-1.00002>,<+14,-9,15>}
    box {<-14,11.5,-1.00001>,<+14,9,15>}
    box {<-14,-12,-0>,<14,11,16>}
    cone {<0,-12.001,8>,5<0,-18,8>,10}
    texture {AmiPlastic}
  }
}
#declare BogusMonitor =
union {
  object {BogusMonitor_x}
  object {MonitorLight translate<0,0,-1>}
}
*/


/////Monitor


//tries to resemble the 1084S, thats why its called it...

#declare PowerSwitch =
union {
  difference {
    box {<-0.75,-0.5,-0.01>,<0.75,0.5,1>}
    box {<-0.26,-0.1,-0.05>,<0.26,0.1,0.9>}
    texture {AmiPlastic}
  }
  box {<-0.25,-0.09,-0.025>,<0.25,0.09,0.5> texture {GreenPlastic}}
  object {SmallLight1 translate <0,0,0.2>}
  object {SmallLight2gr translate <0,0,-0.05>}
}


#declare CornerCutter =
difference {
  intersection {
    cylinder{<0,0,-10>,<0,0,10>,5} 
    box {<0,0,-11>,<10,10,11>}
  }
  cylinder{<0,0,-10>,<0,0,10>,0.75}  
}
#declare c1084S =
union {
  //base
  union {
    box {<-13,-14,1>,<13,5,31>}
    box {<-12,-15,1>,<12,4,31>}
    cylinder {<-12.0,0,1>,<-12.0,0,31>,1.0 translate y*-14.0}
    cylinder {<+12.0,0,1>,<+12.0,0,31>,1.0 translate y*-14.0}

    cylinder {<+12.0,0,31>,<+12.0,5,31>,1.0 translate y*-14.0}
    cylinder {<-12.0,0,31>,<-12.0,5,31>,1.0 translate y*-14.0}
    sphere {<-12.0,0,31>,1.0001 translate y*-14.0}
    sphere {<+12.0,0,31>,1.0001 translate y*-14.0}

    cone {<0,-12.001,16>,7.5<0,-18,16>,14}
    texture {AmiPlastic}
  }
  //back box
  union {
    difference {
      box {<-14,-8.0,3.00004>,<14,10.5,31>}
      box {<-20,0,-20>,<20,20,60> rotate x*7.5 translate y*9.5}
    }
    difference {
      box {<-13.0,-7.0,3.00004>,<13.0,11.5,31>}
      box {<-20,0,-20>,<20,20,60> rotate x*7.5 translate y*10.5}
    }
    difference {
      union {
        cylinder {<-13.0,0,3>,<-13.0,0,35>,1.0 rotate x*7.5 translate y*9.5}
        cylinder {<+13.0,0,3>,<+13.0,0,35>,1.0 rotate x*7.5 translate y*9.5}
      }
      box {<-20,-20,31>,<20,20,38>}
    }    
    texture {Monitordarkplastic}
  }
  difference {
    union {
      difference {
        box {<-15,-9.0,3.00004>,<15,11.5,32>}
        box {<-20,0,-20>,<20,20,60> rotate x*7.5 translate y*10.5}
      }
      difference {
        box {<-14.0,-10.0,3.00004>,<14.0,11.5,32>}
        box {<-20,0,-20>,<20,20,60> rotate x*7.5 translate y*11.5}
      }
      difference {
        union {
          cylinder {<-14.0,0,3>,<-14.0,0,35>,1.0 rotate x*7.5 translate y*10.5}
          cylinder {<+14.0,0,3>,<+14.0,0,35>,1.0 rotate x*7.5 translate y*10.5}
        }
        box {<-20,-20,32>,<20,20,38>}
      }    
      cylinder {<-14.0,0,3>,<-14.0,0,32>,1.0 translate y*-9.0}
      cylinder {<+14.0,0,3>,<+14.0,0,32>,1.0 translate y*-9.0}
    }
    #declare Ctr=0;
    #while (Ctr<15)
      box {<-16,-0.15,1>,<16,0.15,33.00> translate <0,-5.5+(Ctr*0.6),0>}
      #declare Ctr=Ctr+1;
    #end
    #declare Ctr=0;    
    #while (Ctr<12)
      box {<-16,0.0,-0.15>,<16,15,0.15> translate <0,7.5-(Ctr*0.075),22+(Ctr*0.6)>}
      #declare Ctr=Ctr+1;
    #end
    texture {AmiPlastic}
  }
  /*******************************************************************/
  //main box
  union {
    difference {
      union {
        box {<-16.5,-13.25,0>,<16.5,13.25,5>}
        intersection {
          union {
            cylinder {<-13,0,0>,<13,0,0>,5.0 scale <1,1,0.05> translate <0,10.25,0>}
            cylinder {<-13,0,0>,<13,0,0>,5.0 scale <1,1,0.05> translate <0,-10.25,0>}
            cylinder {<0,-9.75,0>,<0,9.75,0>,5.0 scale <1,1,0.05> translate <-13.5,0,0>}
            cylinder {<0,-9.75,0>,<0,9.75,0>,5.0 scale <1,1,0.05> translate <+13.5,0,0>}
            sphere {<0,0,0>,5 scale <1,1,0.05> translate <-13.5,-10.25,0>}
            sphere {<0,0,0>,5 scale <1,1,0.05> translate <+13.5,-10.25,0>}
            sphere {<0,0,0>,5 scale <1,1,0.05> translate <+13.5,+10.25,0>}
            sphere {<0,0,0>,5 scale <1,1,0.05> translate <-13.5,+10.25,0>}
          } 
          box {<-16.495,-13.225,-10>,<16.495,13.225,4.995>}
        }
      }
      box {<-13.5,-9.75,-5>,<13.5,9.75,6>}
      box {<-13.0,-10.25,-5.1>,<13.0,10.25,6>}
      cylinder {<-13.0,-9.75,-7>,<-13.0,-9.75,8.9>,0.50001}
      cylinder {<+13.0,-9.75,-7>,<+13.0,-9.75,8.9>,0.50001}
      cylinder {<+13.0,+9.75,-7>,<+13.0,+9.75,8.9>,0.50001}
      cylinder {<-13.0,+9.75,-7>,<-13.0,+9.75,8.9>,0.50001}        
      object {CornerCutter rotate z*000.0 translate <+15.75,+12.5,0>}
      object {CornerCutter rotate z*090.0 translate <-15.75,+12.5,0>}
      object {CornerCutter rotate z*180.0 translate <-15.75,-12.5,0>}
      object {CornerCutter rotate z*270.0 translate <+15.75,-12.5,0>}    
      box {<-0.9,-0.65,-1.05>,<0.9,0.65,1.2> translate <10,-12.0,-0.05>}
    }
    difference { 
      union {
        cylinder{<-15.750001,0,0>,<15.750001,0,0>,2.5 scale <1,0.05,1> translate <0,13.25,2.5>}
        cylinder{<-15.750001,0,0>,<15.750001,0,0>,2.5 scale <1,0.05,1> translate <0,-13.25,2.5>}
        cylinder{<0,-12.501,0>,<0,12.501,0>,2.5 scale <0.05,1,1> translate <-16.5,0,2.5>}
        cylinder{<0,-12.501,0>,<0,12.501,0>,2.5 scale <0.05,1,1> translate <+16.5,0,2.5>}      
        torus {0.75,0.125 rotate x*90 scale <1,1,20> translate <-15.75,-12.5,2.5>}
        torus {0.75,0.125 rotate x*90 scale <1,1,20> translate <+15.75,-12.5,2.5>}
        torus {0.75,0.125 rotate x*90 scale <1,1,20> translate <+15.75,+12.5,2.5>}
        torus {0.75,0.125 rotate x*90 scale <1,1,20> translate <-15.75,+12.5,2.5>}
      }
      box {<-0.91,-0.66,-0.9>,<0.91,0.66,1.5> translate <10,-12.0,-0.05>}
    }
    scale <1,1,0.75>
    texture {AmiPlastic}
  }
  //main box aft
  union {
    difference {
      union {
        box {<-16.5,-13.25,0>,<16.5,13.25,5>}
        intersection {
          union {
            cylinder {<-13,0,0>,<13,0,0>,5.0 scale <1,1,0.05> translate <0,10.25,0>}
            cylinder {<-13,0,0>,<13,0,0>,5.0 scale <1,1,0.05> translate <0,-10.25,0>}
            cylinder {<0,-9.75,0>,<0,9.75,0>,5.0 scale <1,1,0.05> translate <-13.5,0,0>}
            cylinder {<0,-9.75,0>,<0,9.75,0>,5.0 scale <1,1,0.05> translate <+13.5,0,0>}
            sphere {<0,0,0>,5 scale <1,1,0.05> translate <-13.5,-10.25,0>}
            sphere {<0,0,0>,5 scale <1,1,0.05> translate <+13.5,-10.25,0>}
            sphere {<0,0,0>,5 scale <1,1,0.05> translate <+13.5,+10.25,0>}
            sphere {<0,0,0>,5 scale <1,1,0.05> translate <-13.5,+10.25,0>}
          } 
          box {<-16.495,-13.225,-10>,<16.495,13.225,4.995>}
        }
      }
/*      
      box {<-13.5,-9.75,-5>,<13.5,9.75,6>}
      box {<-13.0,-10.25,-5.1>,<13.0,10.25,6>}
      cylinder {<-13.0,-9.75,-7>,<-13.0,-9.75,8.9>,0.50001}
      cylinder {<+13.0,-9.75,-7>,<+13.0,-9.75,8.9>,0.50001}
      cylinder {<+13.0,+9.75,-7>,<+13.0,+9.75,8.9>,0.50001}
      cylinder {<-13.0,+9.75,-7>,<-13.0,+9.75,8.9>,0.50001}        
*/      
      object {CornerCutter rotate z*000.0 translate <+15.75,+12.5,0>}
      object {CornerCutter rotate z*090.0 translate <-15.75,+12.5,0>}
      object {CornerCutter rotate z*180.0 translate <-15.75,-12.5,0>}
      object {CornerCutter rotate z*270.0 translate <+15.75,-12.5,0>}    
    } 
    cylinder{<-15.750001,0,0>,<15.750001,0,0>,2.5 scale <1,0.05,1> translate <0,13.25,2.5>}
    cylinder{<-15.750001,0,0>,<15.750001,0,0>,2.5 scale <1,0.05,1> translate <0,-13.25,2.5>}
    cylinder{<0,-12.501,0>,<0,12.501,0>,2.5 scale <0.05,1,1> translate <-16.5,0,2.5>}
    cylinder{<0,-12.501,0>,<0,12.501,0>,2.5 scale <0.05,1,1> translate <+16.5,0,2.5>}      
    torus {0.75,0.125 rotate x*90 scale <1,1,20> translate <-15.75,-12.5,2.5>}
    torus {0.75,0.125 rotate x*90 scale <1,1,20> translate <+15.75,-12.5,2.5>}
    torus {0.75,0.125 rotate x*90 scale <1,1,20> translate <+15.75,+12.5,2.5>}
    torus {0.75,0.125 rotate x*90 scale <1,1,20> translate <-15.75,+12.5,2.5>}
    rotate y*180 translate <0,0,9>
    texture {AmiPlastic}
  }
  /*******************************************************************/
  //crt rim
  union {
    difference {
      union {
        box {<-16.5,-13.25,0>,<16.5,13.25,5>}
        intersection {
          union {
            cylinder {<-13,0,0>,<13,0,0>,5.0 scale <1,1,0.05> translate <0,10.25,0>}
            cylinder {<-13,0,0>,<13,0,0>,5.0 scale <1,1,0.05> translate <0,-10.25,0>}
            cylinder {<0,-9.75,0>,<0,9.75,0>,5.0 scale <1,1,0.05> translate <-13.5,0,0>}
            cylinder {<0,-9.75,0>,<0,9.75,0>,5.0 scale <1,1,0.05> translate <+13.5,0,0>}
            sphere {<0,0,0>,5 scale <1,1,0.05> translate <-13.5,-10.25,0>}
            sphere {<0,0,0>,5 scale <1,1,0.05> translate <+13.5,-10.25,0>}
            sphere {<0,0,0>,5 scale <1,1,0.05> translate <+13.5,+10.25,0>}
            sphere {<0,0,0>,5 scale <1,1,0.05> translate <-13.5,+10.25,0>}
          } 
          box {<-16.495,-13.225,-10>,<16.495,13.225,4.995>}
        }
      }
      box {<-14.75,-11.0,-5>,<14.75,11.0,6>}
      box {<-14.25,-11.5,-5.1>,<14.25,11.5,6>}
      cylinder {<-14.0,-11.0,-7>,<-14.0,-11.0,8.9>,0.50001}
      cylinder {<+14.0,-11.0,-7>,<+14.0,-11.0,8.9>,0.50001}
      cylinder {<+14.0,+11.0,-7>,<+14.0,+11.0,8.9>,0.50001}
      cylinder {<-14.0,+11.0,-7>,<-14.0,+11.0,8.9>,0.50001}        
      object {CornerCutter rotate z*000.0 translate <+15.75,+12.5,0>}
      object {CornerCutter rotate z*090.0 translate <-15.75,+12.5,0>}
      object {CornerCutter rotate z*180.0 translate <-15.75,-12.5,0>}
      object {CornerCutter rotate z*270.0 translate <+15.75,-12.5,0>}    
    } 
    cylinder{<-15.750001,0,0>,<15.750001,0,0>,2.5 scale <1,0.05,1> translate <0,13.25,2.5>}
    cylinder{<-15.750001,0,0>,<15.750001,0,0>,2.5 scale <1,0.05,1> translate <0,-13.25,2.5>}
    cylinder{<0,-12.501,0>,<0,12.501,0>,2.5 scale <0.05,1,1> translate <-16.5,0,2.5>}
    cylinder{<0,-12.501,0>,<0,12.501,0>,2.5 scale <0.05,1,1> translate <+16.5,0,2.5>}      
    torus {0.75,0.125 rotate x*90 scale <1,1,20> translate <-15.75,-12.5,2.5>}
    torus {0.75,0.125 rotate x*90 scale <1,1,20> translate <+15.75,-12.5,2.5>}
    torus {0.75,0.125 rotate x*90 scale <1,1,20> translate <+15.75,+12.5,2.5>}
    torus {0.75,0.125 rotate x*90 scale <1,1,20> translate <-15.75,+12.5,2.5>}    
    texture {Monitordarkplastic}
    scale <0.83,0.77,1>
    translate <0,0,-0.3>
  }  
  box {<-12.25,-8.75,0.75>,<12.25,8.75,2> hollow /*no_shadow*/ texture {ScreenTexture3 scale 0.975}}
  object {MonitorLight_g translate<0,7,0.25>}
//  object {MonitorLight translate<0,0,0.25>}
  /*******************************************************************/
  //bogus powerswitch
  object {PowerSwitch translate <10,-12.0,-0.15>}
  translate y*18
}






//////////////////////////

#declare Diskette_Base = 
difference {
  box {<-4.5,0,-4.625>,<4.5,0.3,4.625>}
  box {<-0.2,-0.1,-0.175>,<0.2,0.4,0.175> translate <-0.5,0,-0.85> translate <4.5,0,4.625>}
  box {<-0.5,-0.5,-0.5>,<0.0,0.5,0.5> rotate y*-45 translate <-4.25,0,-4.375>}
  box {<-3.75,0.28,-4.625+3.8>,<3.75,0.4,4.7>}
  box {<-2.50,0.28,-4.625+3.1>,<3.75,0.4,-4.7>}
  box {<-2.50,0.02,-4.625+3.1>,<3.75,-0.1,-4.7>}
}

#declare Metal_Flaep =
difference {
  box {<0,-0.05,-3.11>,<4.75,0.305,0>}
  box {<0.75,-1,-2.6>,<1.9,1,-0.2>}
}

#declare Label_1 =
difference {
  box {<-3.1,0.279,-2.25>,<3.1,0.29,2.25>}
  box {<-0.5,-0.5,-0.5>,<0.0,0.5,0.5> rotate y*-45 translate <-2.9,0,-2.05>}
  box {<-0.5,-0.5,-0.5>,<0.0,0.5,0.5> rotate y*-45 translate <-2.9,0,-2.05> rotate y*90}
  box {<-0.5,-0.5,-0.5>,<0.0,0.5,0.5> rotate y*-45 translate <-2.9,0,-2.05> rotate y*180}
  box {<-0.5,-0.5,-0.5>,<0.0,0.5,0.5> rotate y*-45 translate <-2.9,0,-2.05> rotate y*270}
  texture {DLabelTexture_1 scale <6.2,0,4.5>}
}

#declare Diskette_1 =
union {
  object {Diskette_Base texture {diskblueplastic}}
  object {Metal_Flaep texture {DiskAluminum} translate <-2.5001,0,-4.625+3.1>}
  object {Label_1 rotate y*1 translate <0,0,1.8>}
}
#declare Diskette_2 =
union {
  object {Diskette_Base texture {diskgreyplastic}}
  object {Metal_Flaep texture {DiskAluminum} translate <-2.5001,0,-4.625+3.1>}
  object {Label_1 rotate y*1 translate <0,0,1.8>}
}
#declare Diskette_3 =
union {
  object {Diskette_Base texture {diskgreenplastic}}
  object {Metal_Flaep texture {DiskAluminum} translate <-2.5001,0,-4.625+3.1>}
  object {Label_1 rotate y*1 translate <0,0,1.8>}
}
#declare Diskette_4 =
union {
  object {Diskette_Base texture {diskblackplastic}}
  object {Metal_Flaep texture {DiskAluminum} translate <-2.5001,0,-4.625+3.1>}
  object {Label_1 rotate y*1 translate <0,0,1.8>}
}


//object {Diskette_1}

#declare PileOdisks1 =
union {
  object {Diskette_1 rotate y*+15 translate <0,0.0,0>}
  object {Diskette_2 rotate y*-21 translate <0,0.3,0>}
  object {Diskette_4 rotate y*+16 translate <0,0.6,0>}
  object {Diskette_1 rotate y*-274 translate <0,0.9,0>}
  object {Diskette_3 rotate y*+11 translate <0,1.2,0>}
  object {Diskette_2 rotate y*-22 translate <0,1.5,0>}
  object {Diskette_4 rotate y*-05 translate <0,1.8,0>}
  object {Diskette_2 rotate y*+182 translate <0,2.1,0>}
  object {Diskette_3 rotate y*-11 translate <0,2.4,0>}
  object {Diskette_1 rotate y*+12 translate <0,2.7,0>}
  object {Diskette_1 rotate y*+96 translate <0,3.0,0>}
}
#declare PileOdisks2 =
union {
  object {Diskette_2 rotate y*-12 translate <0,0.0,0>}
  object {Diskette_3 rotate y*+18 translate <0,0.3,0>}
  object {Diskette_3 rotate y*+26 translate <0,0.6,0>}
  object {Diskette_1 rotate y*+03 translate <0,0.9,0>}
  object {Diskette_2 rotate y*-26 translate <0,1.2,0>}
  object {Diskette_3 rotate y*+17 translate <0,1.5,0>}
  object {Diskette_2 rotate y*-95 translate <0,1.8,0>}
  object {Diskette_4 rotate y*-23 translate <0,2.1,0>}
  object {Diskette_1 rotate y*-202 translate <0,2.4,0>}
  object {Diskette_2 rotate y*+15 translate <0,2.7,0>}
  object {Diskette_3 rotate y*-11 translate <0,3.0,0>}
  object {Diskette_2 rotate y*+14 translate <0,3.3,0>}
  object {Diskette_1 rotate y*-97 translate <0,3.6,0>}
  object {Diskette_4 rotate y*+04 translate <0,3.9,0>}
  object {Diskette_4 rotate y*+22 translate <0,4.2,0>}
  object {Diskette_3 rotate y*-15 translate <0,4.5,0>}
  object {Diskette_3 rotate y*-07 translate <0,4.8,0>}
}


////////////////////
/*


a500 below

modelled using a 
ruler and an a500:)


*/
////////////////////



// keys
//
//

#declare KeyCorner =
union {
  difference {
    box {<-1,-1,-1>,<0,1,0>}
    box {<-2,-2,-2>,<0.0,5,0.0> rotate y*-45 rotate x*22.5 rotate y*45/*rotate z*-22.5*/ translate <-0.7,0,-0.7>}
    box {<-5,-5,-5>,<5,5,0> rotate x*22.5 translate z*-1}
    box {<-5,-5,-5>,<5,5,0> rotate x*22.5 translate z*-1 rotate y*90}
  }
  cone {<-0.0,-2,-0.0>,0.44<-0.0,1.0,-0.0>,0.1751 rotate x*22.5 rotate y*45/*rotate z*-22.5*/ translate <-0.7075,0,-0.7075>}
//  cylinder {<-0.0,-2,-0.0>,<-0.0,1.3,-0.0>,0.11001 rotate x*22.5 rotate y*45/*rotate z*-22.5*/ translate <-0.8,0,-0.8>}

//  cylinder {<-0.0,-1,-0.0>,<-0.0,1,-0.0>,0.27001 rotate x*-22.5 rotate z*+22.5 rotate y*180 translate <-0.8,0,-0.8>}
}


#declare KeyBase =
union {
  object {KeyCorner}
  object {KeyCorner rotate y*90}
  object {KeyCorner rotate y*180}
  object {KeyCorner rotate y*270}  
  translate y*-0.25
  scale <1,1.5,1>
}

#declare KeySide =
union {
  object {KeyCorner}
  object {KeyCorner rotate y*90}
  translate y*-0.25
  scale <1,1.5,1>
//  translate <0,0,-0.05>
}

#declare KeyCenter =
difference {

  box {<-1,-1,-2>,<1,1.2,2>}
  box {<-1.5,-8,-5.0005>,<1.5,8,0> rotate x*22.5 translate z*-1}
  box {<-1.5,-8,-5.0005>,<1.5,8,0> rotate x*22.5 translate z*-1 rotate y*180}

  translate y*-0.25
  scale <1,1.5,1>
}


#declare Key3cmBase =
union {
  object {KeySide translate x*-0.5}
  object {KeyCenter scale <0.5,1,1>}
  object {KeySide rotate y*180 translate x*+0.5}
}
#declare Key4cmBase =
union {
  object {KeySide translate x*-1.0}
  object {KeyCenter scale <1.0,1,1>}
  object {KeySide rotate y*180 translate x*+1.0}
}
#declare Key5andahalfcmBase =
union {
  object {KeySide translate x*-1.75}
  object {KeyCenter scale <1.75,1,1>}
  object {KeySide rotate y*180 translate x*+1.75}
}
#declare Key3andahalfcmBase =
union {
  object {KeySide translate x*-0.75}
  object {KeyCenter scale <0.75,1,1>}
  object {KeySide rotate y*180 translate x*+0.75}
}
#declare Key2andahalfcmBase =
union {
  object {KeySide translate x*-0.25}
  object {KeyCenter scale <0.25,1,1>}
  object {KeySide rotate y*180 translate x*+0.25}
}

#declare KeySpacebarBase =
union {
  object {KeySide translate x*-7.5}
  object {KeyCenter scale <7.5,1,1>}
  object {KeySide rotate y*180 translate x*+7.5}  
}



#declare ReturnBase =
union {
  object {Key3cmBase translate <0,0,0>}
  object {Key2andahalfcmBase translate <0.25,0,-1>}
  object {Key2andahalfcmBase translate <0.25,0,-2>}
}

#declare Return =   
difference {          
  object {ReturnBase}
  sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.5,1,1> translate y*1.5}
  sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.5 translate z*-1}
  sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.5 translate z*-2}
  sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,2> translate y*1.5 translate z*-1}
  box {<-4,-4,-4>,<4,-0,4>}
  scale <1,1.5,1>
}
#declare Return_ =
union {
  object {Return texture {Key_Dark}}
  difference {
    union {
      text {ttf "arialbd.ttf","_|", 0.02, 0 align_center scale <0.675,1.65,1.0> rotate x*90 scale <1,120,1> translate <-0.0,1.5,-0.001>}             
      text {ttf "arialbd.ttf","<", 0.02, 0  align_center scale 0.75 rotate x*90 scale <1,120,1> translate <-0.3,1.5,-0.501>}             
      translate <0,0,-1.75>
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.5,1,1> translate y*1.51}
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.51 translate z*-1}
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.51 translate z*-2}
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,2> translate y*1.51 translate z*-1}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}


#declare KeySquare =
difference {
  object {KeyBase}
  sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.5}
  box {<-4,-4,-4>,<4,-0,4>}
  scale <1,1.5,1>
}

#declare Key_spacebar =
union {
  difference {
    object {KeySpacebarBase}
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <17,1,1> translate y*1.5}
    box {<-49,-4,-4>,<49,-0,4>}
  }
  scale <1,1.5,1>
}
#declare Key_3cm =
union {
  difference {
    object {Key3cmBase}
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.5,1,1> translate y*1.5}
    box {<-49,-4,-4>,<49,-0,4>}
//    scale <0.8,1.0,0.8>
//    translate <0,0.15,0>
  }
  scale <1,1.5,1>
}
#declare Key_4cm =
union {
  difference {
    object {Key4cmBase}
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <2.0,1,1> translate y*1.5}
    box {<-49,-4,-4>,<49,-0,4>}
//    scale <0.8,1.0,0.8>
//    translate <0,0.15,0>
  }
  scale <1,1.5,1>
}
#declare Key_5andahalfcm =
union {
  difference {
    object {Key5andahalfcmBase}
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <2.75,1,1> translate y*1.5}
    box {<-49,-4,-4>,<49,-0,4>}
//    scale <0.8,1.0,0.8>
//    translate <0,0.15,0>
  }
  scale <1,1.5,1>
}
#declare Key_3andahalfcm =
union {
  difference {
    object {Key3andahalfcmBase}
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.75,1,1> translate y*1.5}
    box {<-49,-4,-4>,<49,-0,4>}
//    scale <0.8,1.0,0.8>
//    translate <0,0.15,0>
  }
  scale <1,1.5,1>
}
#declare Key_2andahalfcm =
//union {
  difference {
    object {Key2andahalfcmBase}
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.5}
    box {<-49,-4,-4>,<49,-0,4>}
//    scale <0.8,1.0,0.8>
//    translate <0,0.15,0>
//  }
  scale <1,1.5,1>
}







/***************************************************************************************************************************/
/**********************Regular alphabet keys********************************************************************************/
/***************************************************************************************************************************/


#declare Q_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","Q", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare W_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","W", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare E_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","E", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare R_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","R", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare T_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","T", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare Y_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","Y", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare U_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","U", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare I_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","I", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare O_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","O", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare P_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","P", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare A_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","A", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare S_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","S", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare D_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","D", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare F_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","F", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare G_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","G", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare H_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","H", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare J_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","J", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare K_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","K", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare L_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","L", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare Z_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","Z", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare X_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","X", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare C_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","C", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare V_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","V", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare B_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","B", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare N_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","N", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare M_ = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    text {ttf "arialbd.ttf","M", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}


#declare kp0 = 
union {
  object {Key_3cm texture {Key_Dark}}
  difference {
    union {
      text {ttf "arialbd.ttf","~", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-1.00,1.5,+0.251>}             
      text {ttf "arialbd.ttf","\'", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-1.00,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.5,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}

#declare kp1 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","!", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","1", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp2 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","\"", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","2", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp3 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","p", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}//<<--this should be  but povray has a bug which does not allow that character to be used in truetype objects
      text {ttf "arialbd.ttf","3", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp4 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","$", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","4", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp5 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","%", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","5", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp6 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","^", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","6", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp7 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","&", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","7", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp8 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","*", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","8", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp9 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","(", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","9", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp10 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf",")", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","0", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp11 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","_", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","-", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp12 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","+", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","=", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp13 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","|", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","\\", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}


#declare kp14 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","{", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","[", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp15 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","}", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","]", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp16 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf",":", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf",";", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp17 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","@", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","#", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp18 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","<", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf",",", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp19 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf",">", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf",".", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare kp20 = 
union {
  object {KeySquare texture {Key_Beige}}
  difference {
    union {
      text {ttf "arialbd.ttf","?", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","/", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}



/***************************************************************************************************************************/
/**********************Numpad keys******************************************************************************************/
/***************************************************************************************************************************/

#declare _1 = 
union {
  object {KeySquare texture {Key_Mid}}
  difference {
    text {ttf "arialbd.ttf","1", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare _2 = 
union {
  object {KeySquare texture {Key_Mid}}
  difference {
    text {ttf "arialbd.ttf","2", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare _3 = 
union {
  object {KeySquare texture {Key_Mid}}
  difference {
    text {ttf "arialbd.ttf","3", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare _4 = 
union {
  object {KeySquare texture {Key_Mid}}
  difference {
    text {ttf "arialbd.ttf","4", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare _5 = 
union {
  object {KeySquare texture {Key_Mid}}
  difference {
    text {ttf "arialbd.ttf","5", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare _6 = 
union {
  object {KeySquare texture {Key_Mid}}
  difference {
    text {ttf "arialbd.ttf","6", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare _7 = 
union {
  object {KeySquare texture {Key_Mid}}
  difference {
    text {ttf "arialbd.ttf","7", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare _8 = 
union {
  object {KeySquare texture {Key_Mid}}
  difference {
    text {ttf "arialbd.ttf","8", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare _9 = 
union {
  object {KeySquare texture {Key_Mid}}
  difference {
    text {ttf "arialbd.ttf","9", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare _0 = 
union {
  object {Key_4cm texture {Key_Mid}}
  difference {
    text {ttf "arialbd.ttf","0", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-1.50,1.5,-0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <2.0,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare Tab = 
union {
  object {Key_4cm texture {Key_Dark}}
  difference {
    union {
      text {ttf "arialbd.ttf","|<-", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-1.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","->|", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-1.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <2.0,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}

#declare np1 = 
union {
  object {KeySquare texture {Key_Dark}}
  difference {
    union {
      text {ttf "arialbd.ttf","{", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","[", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare np2 = 
union {
  object {KeySquare texture {Key_Dark}}
  difference {
    union {
      text {ttf "arialbd.ttf","}", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
      text {ttf "arialbd.ttf","]", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.451>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare np3 = 
union {
  object {KeySquare texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","/", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare np4 = 
union {
  object {KeySquare texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","*", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare np5 = 
union {
  object {KeySquare texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","-", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare np6 = 
union {
  object {KeySquare texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","+", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare np7 = 
union {
  object {KeySquare texture {Key_Mid}}
  difference {
    text {ttf "arialbd.ttf",".", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}

#declare npRet = 
union {
  object {Key_4cm texture {Key_Mid}}
  difference {
    union {
      text {ttf "arialbd.ttf","E", 0.02, 0 align_left scale 0.45 rotate x*90 rotate y*90 scale <1,120,1> translate <+1.50,1.5,0.501>}             
      text {ttf "arialbd.ttf","n", 0.02, 0 align_left scale 0.45 rotate x*90 rotate y*90 scale <1,120,1> translate <+1.00,1.5,0.501>}             
      text {ttf "arialbd.ttf","t", 0.02, 0 align_left scale 0.45 rotate x*90 rotate y*90 scale <1,120,1> translate <+0.50,1.5,0.501>}             
      text {ttf "arialbd.ttf","e", 0.02, 0 align_left scale 0.45 rotate x*90 rotate y*90 scale <1,120,1> translate <+0.00,1.5,0.501>}             
      text {ttf "arialbd.ttf","r", 0.02, 0 align_left scale 0.45 rotate x*90 rotate y*90 scale <1,120,1> translate <-0.50,1.5,0.501>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <2.0,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}

/***************************************************************************************************************************/
/**********************Function keys and other special**********************************************************************/
/***************************************************************************************************************************/

//cheap arrow keys
#declare up_arrow = 
union {
  object {KeySquare texture {Key_Mid}}
  difference {
    text {ttf "arialbd.ttf","|", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.0>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare left_arrow = 
union {
  object {KeySquare texture {Key_Mid}}
  difference {
    text {ttf "arialbd.ttf","_", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,0.2501>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}

#declare npleft_arrow = 
union {
  object {KeySquare texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","_", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,0.2501>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}

#declare right_arrow = 
union {
  object {KeySquare texture {Key_Mid}}
  difference {
    text {ttf "arialbd.ttf","_", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,0.2501>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare down_arrow = 
union {
  object {KeySquare texture {Key_Mid}}
  difference {
    text {ttf "arialbd.ttf","|", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.0>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}


#declare capslock = 
union {
  difference {
    object {KeySquare} 
    cylinder {<0.35,0,0.35>,<0.35,10,0.35>,0.125}
    texture {Key_Dark}
  }
  difference {
    union {
      text {ttf "arialbd.ttf","Caps", 0.02, 0 align_left scale 0.35 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.101>}             
      text {ttf "arialbd.ttf","Lock", 0.02, 0 align_left scale 0.35 rotate x*90 scale <1,120,1> translate <-0.50,1.5,-0.490>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
  difference {
    box {<-0.5,0,-0.5>,<0.5,1.55,0.5>}
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.48}
    scale <1,1.5,1> texture {RedPlastic}
  }
}

#declare esc = 
union {
  object {KeySquare texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","Esc", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.50,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare f1 =
union {
  object {Key_2andahalfcm texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","F1", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.75,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare f2 =
union {
  object {Key_2andahalfcm texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","F2", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.75,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare f3 =
union {
  object {Key_2andahalfcm texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","F3", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.75,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare f4 =
union {
  object {Key_2andahalfcm texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","F4", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.75,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare f5 =
union {
  object {Key_2andahalfcm texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","F5", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.75,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare f6 =
union {
  object {Key_2andahalfcm texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","F6", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.75,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare f7 =
union {
  object {Key_2andahalfcm texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","F7", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.75,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare f8 =
union {
  object {Key_2andahalfcm texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","F8", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.75,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare f9 =
union {
  object {Key_2andahalfcm texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","F9", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.75,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare f10 =
union {
  object {Key_2andahalfcm texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","F10", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.75,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare ctrl =
union {
  object {Key_2andahalfcm texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","Ctrl", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.75,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare alt =
union {
  object {Key_2andahalfcm texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","alt", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-0.75,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare Amiga =
union {
  object {Key_2andahalfcm texture {Key_Dark}}
  difference {
    text {ttf "timesbi.ttf","A", 0.02, 0 align_left scale 0.75 rotate x*90 scale <1,120,1> translate <-0.75,1.5,+0.001>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.25,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}

#declare del =
union {
  object {Key_3andahalfcm texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","Del", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-1.00,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.75,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare help =
union {
  object {Key_3andahalfcm texture {Key_Dark}}
  difference {
    text {ttf "arialbd.ttf","Help", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-1.00,1.5,+0.251>}             
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.75,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare lshift =
union {
  object {Key_3andahalfcm texture {Key_Dark}}
  difference {
    union {
      text {ttf "arialbd.ttf","^", 0.02, 0 align_left scale 0.65 rotate x*90 scale <1,120,1> translate <-1.10,1.5,+0.00>}             
      text {ttf "arialbd.ttf","I", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-1.00,1.5,-0.05>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <1.75,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}
#declare rshift =
union {
  object {Key_5andahalfcm texture {Key_Dark}}
  difference {
    union {
      text {ttf "arialbd.ttf","^", 0.02, 0 align_left scale 0.65 rotate x*90 scale <1,120,1> translate <-2.10,1.5,+0.00>}             
      text {ttf "arialbd.ttf","I", 0.02, 0 align_left scale 0.45 rotate x*90 scale <1,120,1> translate <-2.00,1.5,-0.05>}             
    }
    sphere {<0,0,0>,2 scale <1.5,0.325,1.5> scale <2.75,1,1> translate y*1.51}
    scale <1,1.5,1> texture {BlackPlastic}
  }
}








/*
//various keys
#declare Key_3cm = object {KeySquare scale <1.5,1,1>}//"tilde", del, help
#declare Key_4cm = object {KeySquare scale <2.0,1,1>}//numpad enter (rotated y*90), tab
#declare Key_5andahalfcm = object {KeySquare scale <2.75,1,1>}//right shift
#declare Key_2andahalfcm = object {KeySquare scale <1.25,1,1>} //ctrl. alt, fuction keys and A
#declare Key_3andahalfcm = object {KeySquare scale <1.75,1,1>} //left shift

#declare Key_spacebar = object {KeySquare scale <8.5,1,1>}//space bar. needs special add-ons!
*/

//object {KeySquare pigment {color rgb<0.6,0.575,0.55>}finish {diffuse 0.6 ambient Amb} translate y*2 rotate y*0}
//box {<-1,-1,-1>,<1,1.5,1> pigment {color rgb<1,0,0>} finish {ambient 1}}






#declare keycutter =
union {
  box {<-1.05,0,-1.05>,<1.05,1,1.05> translate <1.0,0,3>}//ESCAPE

  box {<-6.25,0,-1.05>,<6.15,1,1.05> translate <9.00,0,3>}//F1-F5
  box {<-6.25,0,-1.05>,<6.15,1,1.05> translate <22.25,0,3>}//F6-F10

  box {<-15.60,0,-4.05>,<14.80,1,4.05> translate <15.55,0,-3>}//MAIN KEYBD
  box {<-14.00,0,-1.05>,<12.80,1,1.05> translate <15.50,0,-8>}//MAIN KEYBD 2

  box {<-3.00,0,-1.05>,<3.00,1,1.05> translate <34.0,0,0>}//DEL HELP
  box {<-3.00,0,-1.05>,<3.00,1,1.05> translate <34.0,0,-6>}//ARROWS 1
  box {<-1.00,0,-1.05>,<1.00,1,1.05> translate <34.0,0,-4>}//ARROWS 2

  box {<-4.05,0,-5.05>,<4.05,1,5.05> translate <41.75,0,-4>}//NUMPAD
  translate <0,0,-3>
}



#declare AmikbdAngle=14;


//starts from <0,0,0>... extends to <46,0,-12>
#declare keys =
union {
  //starts at x=0
  
  //esc, f1, f2, f3
  union {
    object {esc translate <1.0,0,0>} //ESCAPE Stylee! greets to pHN
    union {
      object {f1  translate <4.25,0,0>} 
      object {f2  translate <6.70,0,0>} 
      object {f3  translate <9.15,0,0>} 
      object {f4  translate <11.60,0,0>} 
      object {f5  translate <14.05,0,0>} 
      translate <-0.25,0,0>
    }
    union {
      object {f6  translate <17.75,0,0>} 
      object {f7  translate <20.20,0,0>} 
      object {f8  translate <22.65,0,0>} 
      object {f9  translate <25.10,0,0>} 
      object {f10 translate <27.55,0,0>} 
      translate <-0.45,0,0>
    }
    translate <0,5,3>
  }
  
  object {Return_ rotate x*-AmikbdAngle rotate x*5  translate <28.80,3.25,-2>} 

  //12345....
  union {
    object {kp0 translate <1.5,0,0>}
    object {kp1 translate <3.95,0,0>}
    object {kp2 translate <5.90,0,0>}
    object {kp3 translate <7.85,0,0>}
    object {kp4 translate <9.80,0,0>}
    object {kp5 translate <11.75,0,0>}
    object {kp6 translate <13.70,0,0>}
    object {kp7 translate <15.65,0,0>}
    object {kp8 translate <17.60,0,0>}
    object {kp9 translate <19.55,0,0>}
    object {kp10 translate <21.50,0,0>}
    object {kp11 translate <23.45,0,0>}
    object {kp12 translate <25.40,0,0>}
    object {kp13 translate <27.35,0,0>}
    object {npleft_arrow translate <29.30,0,0>}  
    translate <0,4.0,0>
  }
  //qwerty...
  //starts at x=0
  union {
    object {Tab translate <2.0,0,0>} 
    object {Q_ translate <4.95,0,0>}
    object {W_ translate <6.90,0,0>}
    object {E_ translate <8.85,0,0>}
    object {R_ translate <10.80,0,0>}
    object {T_ translate <12.75,0,0>}
    object {Y_ translate <14.70,0,0>}
    object {U_ translate <16.65,0,0>}
    object {I_ translate <18.60,0,0>}
    object {O_ translate <20.55,0,0>}
    object {P_ translate <22.50,0,0>}
    object {kp14 translate <24.45,0,0>}
    object {kp15 translate <26.40,0,0>}
    translate <0,3.5,-2>
  }
  //asdf...
  //starts at x=0
  union {
//    object {Key_2andahalfcm texture {Key_Dark} translate <1.25,0,0>} 
    object {ctrl texture {Key_Dark} translate <1.5,0,0>} 
    object {capslock translate <3.70,0,0>}
    object {A_ translate <5.65,0,0>}
    object {D_ translate <7.60,0,0>}
    object {S_ translate <9.55,0,0>}
    object {F_ translate <11.50,0,0>}
    object {G_ translate <13.45,0,0>}
    object {H_ translate <15.40,0,0>}
    object {J_ translate <17.35,0,0>}
    object {K_ translate <19.30,0,0>}
    object {L_ translate <21.25,0,0>}
    object {kp16 translate <23.20,0,0>}
    object {kp17 translate <25.15,0,0>}
    object {KeySquare texture {Key_Beige} translate <27.10,0,0>}//empty key in my amiga
//    translate <0,0,-4>
    translate <-0.25,3.0,-4>
  }
  //zxcv...
  //starts at x=0
  union {
    object {lshift translate <1.75,0,0>} //left shift
    object {KeySquare texture {Key_Beige} translate <4.45,0,0>}//empty key in my amiga
    object {Z_ translate <6.40,0,0>}
    object {X_ translate <8.35,0,0>}
    object {C_ translate <10.30,0,0>}
    object {V_ translate <12.25,0,0>}
    object {B_ translate <14.20,0,0>}
    object {N_ translate <16.15,0,0>}
    object {M_ translate <18.10,0,0>}
    object {kp18 translate <20.05,0,0>}
    object {kp19 translate <22.00,0,0>}
    object {kp20 translate <23.95,0,0>}
    object {rshift translate <2.75,0,0> translate <24.85,0,0>} 
    translate <0,2.5,-6>
  }    
  //alt, A, space, A, alt
  //starts at x=1.5
  union {
    object {alt translate x*1.5 translate <1.25,0,0>} 
    object {Amiga translate x*1.5 translate <3.70,0,0>} 
    object {Key_spacebar texture {Key_Mid} translate x*1.5 translate x*8.5 translate <4.90,0,0>} 
    object {Amiga translate x*1.5 translate x*17 translate <6.10,0,0>} 
    object {alt translate x*1.5 translate x*17 translate <8.55,0,0>} 
    translate <0,2.0,-8>
  }  
  
  
  //arrows and others
  
  union {
    object {del  translate <1.5,4,0>}//del
    object {help translate <4.5,4,0>}//help
    translate <31.0,0,0>
  }

  //arrows
  union {
    object {up_arrow translate <3.0,3.0,2>}//up
    object {left_arrow translate <1.0,2.5,0>}//left
    object {down_arrow translate <3.0,2.5,0>}//down
    object {right_arrow translate <5.0,2.5,0>}//right
    translate <31.0,0,-6>
  }
  
  //numpad
  union {
    object {np1 translate <1.0,4.0,0>}
    object {np2 translate <3.0,4.0,0>}
    object {np3 translate <5.0,4.0,0>}
    object {np4 translate <7.0,4.0,0>}
    object {_7  translate <1.0,3.5,-2>}
    object {_8  translate <3.0,3.5,-2>}
    object {_9  translate <5.0,3.5,-2>}
    object {np5 translate <7.0,3.5,-2>}
    object {_4  translate <1.0,3.0,-4>}
    object {_5  translate <3.0,3.0,-4>}
    object {_6  translate <5.0,3.0,-4>}
    object {np6 translate <7.0,3.0,-4>}
    object {_1  translate <1.0,2.5,-6>}
    object {_2  translate <3.0,2.5,-6>}
    object {_3  translate <5.0,2.5,-6>}
    object {_0  translate <2.0,2.0,-8>}
    object {np7 translate <5.0,2.0,-8>}
    object {npRet translate <2,0,0.0> rotate y*-90 rotate x*-AmikbdAngle rotate x*5 translate <7.0,2,-9>}
//    object {Key_4cm   texture {Key_Dark} translate <2,0,0.0> rotate y*-90 rotate x*-AmikbdAngle rotate x*5 translate <7.0,2,-9>}
    translate <37.75,0,0>
  }


  translate <0,0,-3>
}

#declare C_Logo =
height_field {tga "clogo.tga" translate <-0.5,0,-0.5> scale <1.5,0.075,1.5>}

#declare kbdbase =
union {

  union {
    difference {
      box {<-23.5,-1,16.5>,<23.5,2,19.5> rotate x*-1 rotate x*-AmikbdAngle}
      box {<-40,0,-40>,<40,40,40> rotate x*-1 rotate x*-AmikbdAngle translate <0,0.6,0>}
      //C= logo
      box {<-0.7,-1,-0.7>,<0.7,19,0.7> translate <24-2.8,0,18.0> rotate x*-1 rotate x*-AmikbdAngle}
      
    }
    difference {
      box {<-23.999,-1,16.5>,<23.999,2,20.0> rotate x*-1 rotate x*-AmikbdAngle}
      box {<-40,0,-40>,<40,40,40> rotate x*-1 rotate x*-AmikbdAngle translate <0,0.1,0>}
    }
//    cylinder {<-23.999,0,19.5>,<23.999,0,19.5>,0.1 rotate x*-1 rotate x*-AmikbdAngle translate <0,0.5,0> translate <0,0.1,0>}
    union {
      cylinder {<-23.5,0.0,19.5>,<23.5,0.0,19.5>,0.5  rotate x*-1 rotate x*-AmikbdAngle}
      cylinder {<0,0.0,16.5>,<0,0.0,19.5>,0.5 rotate x*-1 translate <-23.5,0.1,0> rotate x*-AmikbdAngle }
      cylinder {<0,0.0,16.5>,<0,0.0,19.5>,0.5 rotate x*-1 translate <+23.5,0.1,0> rotate x*-AmikbdAngle }
      sphere {<-23.5,0.0,19.5>,0.50001 rotate x*-1 translate y*0.1 rotate x*-AmikbdAngle}
      sphere {<+23.5,0.0,19.5>,0.50001 rotate x*-1 translate y*0.1 rotate x*-AmikbdAngle}
    }
    object {C_Logo translate <24-2.8,0.55,18.0> rotate x*-1 rotate x*-AmikbdAngle}
    translate <0,0.15,0>
  }

  difference {
    union {
      difference {
        box {<-23.5,0.1,0.5>,<23.5,2,17> rotate x*-AmikbdAngle}
        box {<-40,0,-40>,<40,40,40> rotate x*-1 rotate x*-AmikbdAngle translate <0,0.5,0>}
      }
      difference {
        box {<-24.0,0.1,0.5>,<24.0,2,17> rotate x*-AmikbdAngle}
        box {<-40,0,-40>,<40,40,40> rotate x*-1 rotate x*-AmikbdAngle translate <0,0.1,0>}
      }
      difference {
        box {<-24.0,-2,0.5>,<24.0,-0.1,17> rotate x*-AmikbdAngle}
        box {<-40,-40,-40>,<40,0,40> rotate x*1 rotate x*-AmikbdAngle translate <0,-0.6,0>}
      }   
      difference {
        box {<-23.9,-2,0.5>,<23.9,-0.1,17> rotate x*-AmikbdAngle}
        box {<-40,-40,-40>,<40,0,40> rotate x*1 rotate x*-AmikbdAngle translate <0,-0.5,0>}
      }
      box {<-23.75,-0.21,0.35>,<23.75,0.21,17.5001> rotate x*-AmikbdAngle}
    }                                      

    object {keycutter scale <1,30,1> translate <-22.875,-1,14.6>}

    difference {
      box {<-23.15,0.1,0.0>,<23.15,2,16.9> rotate x*-AmikbdAngle}
      box {<-40,0,-40>,<40,40,40> rotate x*-1 rotate x*-AmikbdAngle translate <0,0.45,0>}
    }
    //disk & power lights
    box {<-0.75,-1,-0.1>,<0.75,19,0.1> translate <24-2.75,0,15.6-0.6>}
    box {<-0.75,-1,-0.1>,<0.75,19,0.1> translate <24-2.75,0,15.6-1.4>}
    
  } 

      intersection {
        union {
          cylinder {<-23.5,0.1,0>,<23.5,0.1,0>,0.5 rotate x*-AmikbdAngle}
          cylinder {<0,0.0,0>,<0,0.0,17>,0.5 rotate x*-1 translate <-23.5,0.1,0> rotate x*-AmikbdAngle }
          cylinder {<0,0.0,0>,<0,0.0,17>,0.5 rotate x*-1 translate <+23.5,0.1,0> rotate x*-AmikbdAngle }
          sphere {<-23.5,0.1,0>,0.50001 rotate x*-AmikbdAngle}
          sphere {<+23.5,0.1,0>,0.50001 rotate x*-AmikbdAngle}
        }
        box {<-24.2,0.1,-1.55>,<24.2,2.7,16.5001> rotate x*-AmikbdAngle}
        translate <0,0,0.5>
      }
      intersection {
        union {
          cylinder {<-23.9,-0.1,0>,<23.9,-0.1,0>,0.5 rotate x*-AmikbdAngle}
          cylinder {<-24.0,-0.1,0>,<24.0,-0.1,0>,0.4 rotate x*-AmikbdAngle}
          torus {0.4,0.1001 rotate z*90 translate <-23.9,-0.1,0> rotate x*-AmikbdAngle}
          torus {0.4,0.1001 rotate z*90 translate <+23.9,-0.1,0> rotate x*-AmikbdAngle}
          cylinder {<0,0.0,0>,<0,0.0,17>,0.10001 rotate x*1 translate <-23.9,-0.5,0> rotate x*-AmikbdAngle }
          cylinder {<0,0.0,0>,<0,0.0,17>,0.10001 rotate x*1 translate <+23.9,-0.5,0> rotate x*-AmikbdAngle }
          sphere {<-23.5,-0.1,0>,0.50001 rotate x*-AmikbdAngle}
          sphere {<+23.5,-0.1,0>,0.50001 rotate x*-AmikbdAngle}
        }
        box {<-24.1,-0.1,-1.55>,<24.1,-2.0,16.5> rotate x*-AmikbdAngle}
        translate <0,0,0.5>
      }
  
}

#declare AmigaLogo =
height_field {tga "amiga_hf.tga" translate <-0.5,0,-0.5> scale <10.5,0.15,2.25>}


#declare BackBox =
union {
  object {AmigaLogo translate <(23.5-6.5),5.85,2.25>}
  difference {
    union {
      box {<-23.5,0.3,0>,<23.5,6,14.25>}
      box {<-24,0.3,0>,<24,3.75,15.5>} 
    }
    
    //slot for amigalogo
    box {<-5.25,0,-1.125>,<5.25,1,1.125> translate <(23.5-6.5),5.85,2.25>}
    
    box {<-40,-40,0>,<40,40,40> rotate x*-22.5 translate <0,6,12.25>}
    #declare Ctr=0;
    #while (Ctr<9)
      box {<-27,5.75,0>,<22.25,6.25,0.3> translate <0,0,5+(Ctr*0.6)>}
      #declare Ctr=Ctr+1;
    #end
    #declare Ctr=0;    
  
    //top and bottom cuts of diskdrive
    box {<23.0001,4,4.25>,<25,8,7.25>}
    box {<23,3,4.5>,<26,8,7.0>}
    //diskdrive
    box {<8,3.75,1.25>,<26,4.25,10.25>}
    box {<9,3.5,4.75>,<27,4.5,6.75>}
    //disk button hole
    box {<20,-0.325,-0.825>,<28,0.325,0.825> translate <0,3,9.475>}
  }
  
  //disk button
  box {<20,-0.25,-0.75>,<24.15,0.25,0.75> translate <0,3,9.475> translate <0.5,0,0>}
  
  difference {
    union {
      #while (Ctr<75)
        box {<-0,0.75,-1>,<0.3,5.75,3.00> translate <-23+(Ctr*0.6),0,12.25>}
        #declare Ctr=Ctr+1;
      #end
      #declare Ctr=0;    
    }
    box {<-40,-40,0>,<40,40,40> rotate x*-11.25 translate <0,5.75,15.00>}
  }
  difference {
    box {<-23.3,0.75,-1>,<23.3,5.5,3.00> translate <0,0,12.0>}
    box {<-40,-40,0>,<40,40,40> rotate x*-11.25 translate <0,5.5,14.75>}
  }
  //bottom of keyboard
  difference {
    box {<-23.5,0.3,0.5>,<23.5,6,19.5001> }
    box {<-40,0,-40>,<40,40,40> rotate x*-AmikbdAngle translate <0,0.5,0>}
    box {<-23.25,0.7,0.75>,<23.25,7,18>}
    translate <0,0,-19.5>
  }
}

#declare Amiga500 =
union {

  object {kbdbase texture {AmiPlastic} translate <0,1,0>}

  object {keys translate <-22.875,-0.25,14.6>}//2.6 away from base

  object {BackBox texture {AmiPlastic} translate <0,0,19.5>}

  //lights
  box {<-0.74,-1,-0.09>,<0.74,4.525,0.09> translate <24-2.75,1,15.6-0.6> texture {RedPlastic}}
  box {<-0.74,-1,-0.09>,<0.74,4.300,0.09> translate <24-2.75,1,15.6-1.4> texture {GreenPlastic}}
  object {SmallLight1 translate <24-2.75,5.52-0.2,15.6-0.6>}
  object {SmallLight2 translate <24-2.75,5.52,15.6-0.6>}
  //inside drive
  object {Diskette_1 rotate y*90 translate <19.1,4,5.75> translate <0,0,19.5>}
  //on top
  object {Diskette_1 rotate y*95 translate <18,6,8> translate <0,0,19.5>}

  rotate y*0
  translate <0,-0.3,0>
}

////////////////////////////////////////

#declare CornerPiece =
union {
  box {<0,0,0>,<0.2,3.5,3> rotate y*-1}
  box {<0,0,0>,<3,3.5,0.2> rotate y*+1}
  intersection {
    union {
      cylinder {<0.001,0,3>,<0.199,0,3>,3.5 rotate y*-1}
      cylinder {<0.001,0,3>,<0.199,0,3>,3.5 rotate y*91}
    }
    box {<-0.1,0.0001,-0.1>,<6.6,3.51,6.6>}
  }
}

#declare PizzaBoxLogo =
union {
  text {
    ttf "arialbd.ttf",  
    "Pizza Inferiore",
    0.02,              
    0                  
    align_center
    scale 2.0     
    rotate x*0
    translate <0,1.2,-0.001>
  }
  difference {
    box {<-8,0.5,-0.001>,<8,3.0,0.001>}
    box {<-7.80,0.65,-0.1>,<7.80,2.85,0.1>}
  }
  texture {PizzaBoxTexture_Yellow}
}

#declare PizzaBox_x =
union {  
  union {
    box {<-16.5,0,-16.5>,<16.5,0.2,16.5>}//bottom
    box {<-16.55,0.1,-0.1>,<16.55,3.6,0.1> rotate x*-4 translate <0,0,-16.5>}
    box {<-16.55,0.1,-0.1>,<16.55,3.6,0.1> rotate x*-4 translate <0,0,-16.5> rotate y*90}
    box {<-16.55,0.1,-0.1>,<16.55,3.6,0.1> rotate x*-4 translate <0,0,-16.5> rotate y*180}
    box {<-16.55,0.1,-0.1>,<16.55,3.6,0.1> rotate x*-4 translate <0,0,-16.5> rotate y*270}
    object {CornerPiece translate <-16.55,0.15,-16.55> rotate y*000}
    object {CornerPiece translate <-16.55,0.15,-16.55> rotate y*090}
    object {CornerPiece translate <-16.55,0.15,-16.55> rotate y*180}
    object {CornerPiece translate <-16.55,0.15,-16.55> rotate y*270}  
    texture {PizzaBoxTexture}
  }
  object {PizzaBoxLogo rotate x*-4 translate <0,0,-16.6>}
  object {PizzaBoxLogo rotate x*-4 translate <0,0,-16.6> rotate y*90}
  object {PizzaBoxLogo rotate x*-4 translate <0,0,-16.6> rotate y*180}
  object {PizzaBoxLogo rotate x*-4 translate <0,0,-16.6> rotate y*270}
}

#declare PizzaBox =
union {
  object {PizzaBox_x}
  object {PizzaBox_x /*translate <+16.5,0,-16.5> rotate x*-1.0 rotate z*-0.7 translate <-16.5,0,+16.5>*/ scale <0.97,1,0.97> translate y*0.2}
}


// 68000 programming for lamers

#declare book =
union { 
  #declare Pages=200;
  #declare P_Thickness=0.01;
  union {//pages of book
    #declare Ctr=0;
    #while(Ctr<Pages)
      box {<-10.5,0,-15>,<10.5,P_Thickness,15> rotate y*3*rand(seed(Ctr*Ctr*0.3)) translate <0,Ctr*(P_Thickness+0.0025),0>}
      #declare Ctr=Ctr+1;
    #end
    texture {White_Paper1}
  }  
  
  //staples
  union {
    cylinder {<0,0,-0.65>,<0,0,0.65>,0.0975 translate <-9.75,160*0.01+0.01,-10>}
    cylinder {<0,0,-0.65>,<0,0,0.65>,0.0975 translate <-9.75,160*0.01+0.01,-00>}
    cylinder {<0,0,-0.65>,<0,0,0.65>,0.0975 translate <-9.75,160*0.01+0.01,+10>}
    texture {CanAluminum}
  }
  //cover of book
  union {
    box {<-10.5,0,-15>,<10.5,0.0075,15> translate <0,Pages*(P_Thickness+0.0025),0> texture {White_Paper2}}
    union {
      text {
        ttf "timesbd.ttf",  
        "68000",         
        0.02,              // the extrusion depth
        0                  // inter-character spacing
        align_center
        scale 3.5      
        rotate x*90
        translate <0,0.005,4>
      }
      text {
        ttf "timesbd.ttf",  
        "Programming",         
        0.01,              // the extrusion depth
        0                  // inter-character spacing
        align_center
        scale 2.75      
        rotate x*90
        translate <0,0.005,0>
      }
      text {
        ttf "timesbd.ttf",  
        "for Lamers",         
        0.01,              // the extrusion depth
        0                  // inter-character spacing
        align_center
        scale 2.65      
        rotate x*90
        translate <0,0.005,-4>
      }
      texture {Black_Paper}
      translate y*Pages*(P_Thickness+0.0025)+0.005
    }
  }
}

























//locations of objects

#declare MouseLoc = <40,0.5,-3>;
#declare JoyLoc = <42,0.0,10>;
#declare AmigaLoc = <0,0,-15>;
#declare PowerLoc = <-45,-20.5,78>;

///////////////Wires to connect all dem stuph

//mouse wire
#declare Mws = MouseLoc+<0,0.5,5.5>;
#declare Mwe = AmigaLoc+<20,1.0,19.5+15>;
#init_3d_spline {
  "spline_mousewire",natural, 
  Mws,
  Mws+<0,0.25,1.0>,
  <(Mws.x*0.90+Mwe.x*0.10)*0.9+(Mws.x*0.75+Mwe.x*0.25)*rand(seed(8754))*0.1-4, Mws.y-0.25,(Mws.z*0.90+Mwe.z*0.10)*0.9+(Mws.z*0.75+Mwe.z*0.25)*rand(seed(4213))*0.1+7>,
  <(Mws.x*0.75+Mwe.x*0.25)*0.7+(Mws.x*0.75+Mwe.x*0.25)*rand(seed(4033))*0.3-5, 0.75,      (Mws.z*0.75+Mwe.z*0.25)*0.8+(Mws.z*0.75+Mwe.z*0.25)*rand(seed(6433))*0.2+15>,
  <(Mws.x*0.50+Mwe.x*0.50)*0.6+(Mws.x*0.50+Mwe.x*0.50)*rand(seed(1033))*0.4-23,0.75,      (Mws.z*0.50+Mwe.z*0.50)*0.7+(Mws.z*0.50+Mwe.z*0.50)*rand(seed(2364))*0.3+11>,
  <(Mws.x*0.25+Mwe.x*0.75)*0.8+(Mws.x*0.25+Mwe.x*0.75)*rand(seed(2033))*0.2-7, 0.75,      (Mws.z*0.25+Mwe.z*0.75)*0.8+(Mws.z*0.25+Mwe.z*0.75)*rand(seed(2143))*0.2+15>,
  <(Mws.x*0.10+Mwe.x*0.90)*0.9+(Mws.x*0.25+Mwe.x*0.75)*rand(seed(1433))*0.1+1, Mwe.y-0.25,(Mws.z*0.10+Mwe.z*0.90)*0.9+(Mws.z*0.25+Mwe.z*0.75)*rand(seed(6433))*0.1+3>,
  Mwe+<0,0,1>,
  Mwe  
}
#declare MouseWire =
union {
  #declare Ctr=0
  #while (Ctr<1)
    sphere { eval_3d_spline ("spline_mousewire",Ctr),0.251 }
    #declare Ctr=Ctr+0.001;
  #end
  texture {AmiPlastic}
}
//joystick wire
#declare Mws = JoyLoc+<0,0.5,4>;
#declare Mwe = AmigaLoc+<16,1.0,19.5+15>;
#init_3d_spline {
  "spline_joywire",natural, 
  Mws,
  Mws+<-1.0,0.95,1.0>,
  <(Mws.x*0.90+Mwe.x*0.10)*0.9+(Mws.x*0.75+Mwe.x*0.25)*rand(seed(8754))*0.1-4, 1.05/*Mws.y+0.25*/,(Mws.z*0.90+Mwe.z*0.10)*0.9+(Mws.z*0.75+Mwe.z*0.25)*rand(seed(4213))*0.1+7>,
  <(Mws.x*0.75+Mwe.x*0.25)*0.7+(Mws.x*0.75+Mwe.x*0.25)*rand(seed(4033))*0.3-8, 0.95,      (Mws.z*0.75+Mwe.z*0.25)*0.8+(Mws.z*0.75+Mwe.z*0.25)*rand(seed(6433))*0.2+5>,
  <(Mws.x*0.50+Mwe.x*0.50)*0.6+(Mws.x*0.50+Mwe.x*0.50)*rand(seed(1033))*0.4-10,0.95,      (Mws.z*0.50+Mwe.z*0.50)*0.7+(Mws.z*0.50+Mwe.z*0.50)*rand(seed(2364))*0.3+18>,
  <(Mws.x*0.25+Mwe.x*0.75)*0.8+(Mws.x*0.25+Mwe.x*0.75)*rand(seed(2033))*0.2-5, 0.95,      (Mws.z*0.25+Mwe.z*0.75)*0.8+(Mws.z*0.25+Mwe.z*0.75)*rand(seed(2143))*0.2+15>,
  <(Mws.x*0.10+Mwe.x*0.90)*0.9+(Mws.x*0.25+Mwe.x*0.75)*rand(seed(1433))*0.1+1, Mwe.y-0.25,(Mws.z*0.10+Mwe.z*0.90)*0.9+(Mws.z*0.25+Mwe.z*0.75)*rand(seed(6433))*0.1+3>,
  Mwe+<0,0,1>,
  Mwe  
}
#declare JoyWire =
union {
  #declare Ctr=0
  #while (Ctr<1)
    sphere { eval_3d_spline ("spline_joywire",Ctr),0.251 }
    #declare Ctr=Ctr+0.001;
  #end
  texture {Black_Rubber}
}

//power cord
#declare Mws = PowerLoc+<0,8.5,-1.5>;
#declare Mwe = AmigaLoc+<-18,1.0,19.5+15>;
#init_3d_spline {
  "spline_powerwire",natural, 
  Mws,
  Mws+<0,0,-1>,
  <(Mws.x*0.90+Mwe.x*0.10)*0.9+(Mws.x*0.75+Mwe.x*0.25)*rand(seed(8754))*0.1-1, 0.55,(Mws.z*0.90+Mwe.z*0.10)*0.9+(Mws.z*0.75+Mwe.z*0.25)*rand(seed(4213))*0.1+7>,
  <(Mws.x*0.75+Mwe.x*0.25)*0.7+(Mws.x*0.75+Mwe.x*0.25)*rand(seed(4033))*0.3-8, 0.65,      (Mws.z*0.75+Mwe.z*0.25)*0.8+(Mws.z*0.75+Mwe.z*0.25)*rand(seed(6433))*0.2+15>,
  <(Mws.x*0.50+Mwe.x*0.50)*0.6+(Mws.x*0.50+Mwe.x*0.50)*rand(seed(1033))*0.4-12, 0.65,      (Mws.z*0.50+Mwe.z*0.50)*0.7+(Mws.z*0.50+Mwe.z*0.50)*rand(seed(2364))*0.3+11>,
  <(Mws.x*0.25+Mwe.x*0.75)*0.8+(Mws.x*0.25+Mwe.x*0.75)*rand(seed(2033))*0.2-13, 0.70,      (Mws.z*0.25+Mwe.z*0.75)*0.8+(Mws.z*0.25+Mwe.z*0.75)*rand(seed(2143))*0.2+15>,
  <(Mws.x*0.10+Mwe.x*0.90)*0.9+(Mws.x*0.25+Mwe.x*0.75)*rand(seed(1433))*0.1+1, 1.25,(Mws.z*0.10+Mwe.z*0.90)*0.9+(Mws.z*0.25+Mwe.z*0.75)*rand(seed(6433))*0.1+3>,
  Mwe+<0,0.75,1>,
  Mwe  
}
#declare PowerWire =
union {
  #declare Ctr=0
  #while (Ctr<1)
    sphere { eval_3d_spline ("spline_powerwire",Ctr),0.351 }
    #declare Ctr=Ctr+0.001;
  #end
  texture {AmiPlastic}
}








object {Amiga500 translate AmigaLoc+<0,0.2,0>}

object {MatUnderAmy scale <1.0,1.0,1.0> rotate y*-0.5 translate AmigaLoc+<0,0,17>}

object {c1084S translate <0,0,22>}

object {PileOdisks1 translate <21,0,40>}
object {PileOdisks2 translate <-34,0,19>}

object {Speaker rotate y*-33 translate <-52,0,20>}
object {Speaker rotate y*33 translate <52,0,20>}

object {PizzaBox rotate y*20 translate <56,40,25>}

object {Amplifier translate <33.25,0,25.5>}
object {BeerSpill scale <1.5,1,1.5> translate <-20,0.01,0> rotate y*20 translate <60,0,9>}
object {BeerCan_1 rotate y*44 translate x*2.5 rotate z*90 rotate y*20 translate <62,0,10>}//translate <0,0,-0>}
object {Beercans1 rotate y*-20 translate <56,0,3>}// translate <-15,0,30>}
object {Beercans2 rotate y*150 translate <-23,0,47>}

object {MouseMat scale <0.95,1.0,0.95> rotate y*7 translate <41,0,-3>}

object {AmigaMouse translate <0,0,-5.5> rotate y*-12 translate <0,0,5.5> translate MouseLoc}
object {AtariJoy translate <-3,0,0> rotate y*-50 translate <0,0,4.75> translate JoyLoc}
object {JoyWire}
object {MouseWire}
object {PowerWire}
object {book rotate y*-34 translate <-45,0,-2>}

object {Table translate <0,0,25>}

