#ifndef(sparowhawk_detail)

  #local sparowhawk_detail = 1;

  light_source { 10 rgb 1 }

  camera {location <1,1.5,1> look_at <0,.5,0>}

  global_settings {
    assumed_gamma 1.0
  }
#end
     
#local body = array[16]
{
  <0,.7,0>, // neck
  <0,.625,0>, // neck, lower
  <0,.55,0>, // stomac
  <0,.45,0>, // hip
  <0,.63,-.05>,//legs, start
  <0,.63,.05> //left leg start
  <0,.25,-.1>,// thigh
  <.2,.25,.06>,// leftthigh
  <-.1,0,-.075>,
  <.25,0,.075>
  <-.05,-.05,-.095>,
  <.35,-.05,.095>
  <.15,.62,-.22>,
  <0,.5,.12>
  <.175,.75,-.2>,
  <.1,.45,.21>
}


union {
#if(sparowhawk_detail)
	#local sp_t = texture {pigment {checker pigment {rgb z}pigment{rgb y}}finish{ambient 0}}
  blob {
    threshold .05
    cylinder { body[0] body[1] .03 1}
    cylinder { body[1] body[3] .07 .2 scale <1,1,1.5> texture {sp_t}}
    cylinder { body[3] body[6] .075 .1 }
    cylinder { body[3] body[7] .075 .1 }
    cylinder { body[6] body[8] .04 1}
    cylinder { body[7] body[9] .04 1}
    cylinder { body[8] body[10] .04 1}
    cylinder { body[9] body[11] .04 1}
    cylinder { body[12] body[4] .03 1}
    cylinder { body[13] body[5] .03 1}
    cylinder { body[12] body[14] .03 1}
    cylinder { body[13] body[15] .03 1}
  }
	
	cylinder { <0,.4375,0><0,.4625,0>.08 pigment { rgb 0}}
	
	light_source { <.5,1.5,0> .7 fade_distance 1.25 fade_power 5 }
	intersection{	
		box {<-.125,-.25,-.05> <.125,.2,0>}
		sphere{<0,0,0>1 scale<.25,.5,.05>translate <-.125,.2,-.05>}
		sphere{<0,0,0>1 scale<.25,.5,.05>translate <.125,.2,-.05>}
		texture {sp_t translate y*.05}
		texture {
			pigment{
			image_map {png "tux.png" once filter 0 1}
			rotate y*180
			translate <.5,-.275,0> scale <128/151,1,1> scale .22
			}
			finish{ambient 0}
		}
		rotate x*-40
		translate <.1,.5,.25>
	}
	union {
		box {	<-.01,.075,-.01><.01,.4,.01> rotate y*45 scale <2,1,1>}
		rotate z*30
		rotate y*90
		translate <-.05,.3,-.15>
		pigment { rgb <.5,.4,.3> } finish { ambient 0 }
	}
	union {
		cylinder { <0,-.05,0><0,.05,0>.015 pigment {rgb <.2,.1,.05>}}
		intersection{	
			box {<-.04,.075,-.01> <.04,.8,.01>}
			sphere {<0,0,0>1 scale <.05,.8,.035> translate <0,.075,.025>}
			sphere {<0,0,0>1 scale <.05,.8,.035> translate <0,.075,-.025>}
			pigment{bumps color_map{[0 rgb 1][1 rgb .5]}scale .3}
			finish{ambient 0 specular .5 roughness .01 reflection .1 metallic}
			scale <.75,1,.85>
		}
		box {	<-.05,.05,-.025><.05,.075,.025> pigment { rgb <.5,.3,.2>}finish{ambient 0}}
		rotate z*70
		translate body[14]
	}
	union {
	  sphere { 0 1 scale <.05,.075,.05> }
		cylinder { <0,.03,0><0,.05,0>.045}
		cylinder {<0,0,-.01><0,0,.01>1 scale <.055,.08,1>}
		translate <.02,.725,0>
	}
#else
  cylinder { body[0] body[1] .02 }
  cylinder { body[1] body[3] .02 }
  cylinder { body[1] body[2] .02 }
  cylinder { body[1] body[4] .02 }
  cylinder { body[1] body[5] .02 }
  cylinder { body[3] body[6] .02 }
  cylinder { body[3] body[7] .02 }
  cylinder { body[6] body[8] .02 }
  cylinder { body[7] body[9] .02 }
  cylinder { body[8] body[10] .02 }
  cylinder { body[9] body[11] .02 }
  cylinder { body[12] body[4] .02 }
  cylinder { body[13] body[5] .02 }
  cylinder { body[12] body[14] .02 }
  cylinder { body[13] body[15] .02 }

  union {
    cylinder { <0,.5,0> <0,-.5,0> .02 }
    cylinder { <0,.5,0> <0,.51,0> .021 }
    cylinder { <0,-.5,0> <0,-.51,0> .021 }
    rotate <15,0,-40> translate body[14]
  }


  sphere { 0 1 scale <.05,.08,.05> translate <0,.75,0> }
#end
	rotate y*-110
	translate <0,.2,0>
  pigment { rgb .4 }
  normal{crackle  scale .05}
	finish { ambient 0 diffuse .2 specular .3 roughness .01 metallic }
}
