// mytree_detail 0 for no detail, 1 for full detail
#declare rs1 = seed(2825809);
#macro tree_01 ()
  #if(mytree_detail)
		union {
			make_tree_01(.1,2.8,0,.05)
    	pigment { bumps color_map {[0 rgb .8][.4 rgb .8][.6 rgb <.4,.3,.2>]} scale .05 } 
			normal {granite 1 scale <.1,.2,.1>}
			finish{ambient 0 diffuse .4 specular .1}
		}
  #else
    box { <-.25,0,-.25> <.25,1,.25> pigment { rgb y*.5 } finish{ambient 0}}
  #end
#end
#declare rec_limit = 0.1;
#macro make_tree_01 (ly,uy,cn,rd)
	#if(uy-ly > rec_limit)
		#local rx=(rand(rs1)-rand(rs1))/7;
		#local ry=(rand(rs1)-rand(rs1))/7;
		make_tree_01(ly+(uy-ly)/4,uy,cn+<rx,0,ry>,rd*.8)
		make_tree_01_trunck(ly,ly+(uy-ly)/4,cn,<rx,0,ry>,rd)
	#end
#end
#declare min_rad = 0.02;
#declare rad_mul = 0.04;
#macro make_tree_01_trunck(ly,uy,cn,dl,rd)
	cone { cn+y*ly rd cn+dl+y*uy rd*.8 }
	#local ba = 360*rand(rs1);
	#local br = 6*rand(rs1)+2;
	#local i = 0;
	#if(uy-ly>rec_limit)
	#while(i<br)
		make_tree_01_branch(
			ly+(uy-ly)/2,
			(uy-ly)*1.2 + min_rad*3
			(uy-ly)/uy*rad_mul/3+min_rad/3,
			y*(ba+i/br*360+15*rand(rs1)),
			0,
			cn+dl/2
		)
		#local i = i+1;
	#end
	#end
#end
#macro make_tree_01_branch(hght,lngth,rds,rttn,cntr,rgn)
	#if(lngth-cntr>rec_limit)
		#local r_val = .04*(2*rand(rs1)-rand(rs1));
		make_tree_01_branch(hght+r_val,lngth,rds*.8,rttn,cntr+(lngth-cntr)/3,rgn)
		cone {<cntr,hght,0> rds <cntr+(lngth-cntr)/3,hght+r_val,0> rds*.8 rotate rttn translate rgn}
	#end
#end
