#version unofficial MegaPov 0.5;

%hf_s = <30,1,30>;

%ground_plane =
height_field {
  pattern 300,300 {
    hf_gray_16
    granite
    color_map {
      [0 rgb 0]
      [1 rgb 1]
    }
    scale .2
  }
  smooth
  scale hf_s
  translate hf_s*<-.5,0,-.5>
}
object{
  ground_plane
  pigment{crackle color_map{[0 rgb .9*<.25,.125,.05>][1 rgb <.5,.25,.1>]}scale .1}
	normal { granite 1 scale .25 }
	finish{diffuse .2 ambient 0}
}

%grass_o = 
mesh {
	triangle {<0,0,.01><0,0,-.01><0,.2,0>}
	triangle {<0,.1,.01><0,.1,-.01><.1,.15,0>}
	pigment {rgb<.2,.25,.1>}
	finish{diffuse .3 ambient 0}
}

#ifdef(grass)
%rs = seed(198437);
%i=0;
%n=40000;
#while(i<n)
  %gx=rand(rs)/3+1/3;
  %gz=rand(rs)/3+1/3;
  %gy=hf_height_at(gx,gz,ground_plane);
  object{
    grass_o
    scale 1+(rand(rs)-rand(rs))/2
    rotate x*45*rand(rs)
    rotate y*360*rand(rs)
    translate hf_s*(<gx,gy,gz>-<.5,0,.5>)
  }
  %i=i+1;
#end
#end


#ifdef(wwbush)
%rs = seed(987);
	%bush =
	mesh {
		%i=0;
		%n=26;
		#while(i<n)
			%rv1=(rand(rs)-rand(rs))*.4;
			%rv2=(rand(rs)-rand(rs))*.3;
			%rv3=(rand(rs)-rand(rs))*.4;
			triangle {<0,0,.015><0,0,-.015><rv1,.7+rv2,rv3>}
			%i=i+1;
		#end
	pigment {rgb<.1,.25,.1>}
	finish{diffuse .2 ambient 0}
	translate y*-.1
	}
%i=0;
%n=55;
#while(i<n)
	%gx=rand(rs)*.25+.375;
	%gz=rand(rs)*.25+.375;
	%gy=hf_height_at(gx,gz,ground_plane);
	%rv=rand(rs)-rand(rs);
	object{
		bush
		scale <1,1+rand(rs)*.5,1>
	  translate hf_s*(<gx,gy,gz>-<.5,0,.5>)
	}
	%i=i+1;
#end
#end
	

#include "mytree.inc"


#local tree = tree_01()
#local tree_2 = tree_01()

%rs = seed(34900);

%i=0;
%n=50;
#while(i<n)
  object{tree 
  rotate y*360*rand(rs) scale .9+(rand(rs)-rand(rs))*.6 
  translate x*(3.5+4*rand(rs)) 
  rotate y*(360*rand(rs)+15)
  }
  %i=i+1;
#end

%i=0;
%n=100;
#while(i<n)
  object{tree_2
  rotate y*360*rand(rs) scale 1+(rand(rs)-rand(rs))*.5 
  translate x*(4+10*rand(rs)) 
  rotate y*-(90*rand(rs)+45)}
  %i=i+1;
#end

