// Tunel.h: interface for the Tunel class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TUNEL_H__85A7B161_794D_11D5_AD0F_506957C10000__INCLUDED_)
#define AFX_TUNEL_H__85A7B161_794D_11D5_AD0F_506957C10000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define	KEYSCOUNT			100
#define	BLOBSCOUNT			20

class CTunnel : public CEfx 
{
private:
	
	class CSplineNode
	{
	public:
		
		FLOAT				m_fT;

		he3d_CVector		m_vPos;
		he3d_CVector		t0, t1;
	};

	CSplineNode				spline[KEYSCOUNT];

	CSimpleBlobSystem		m_blobsSystem;
	CSimpleBlob3D			m_blobs[BLOBSCOUNT];

	FLOAT					m_fCurrentT;	
	he3d_CMatrix			m_mtxCamera;

	FLOAT					m_fMove;

	CSimpleMesh				m_mRedCell;

	FLOAT					m_pfCells[100];
	he3d_CVector			m_pvCells[100];

	PDIRECT3DVERTEXBUFFER8	m_pvbCells;
	PDIRECT3DINDEXBUFFER8	m_pibCells;

	PDIRECT3DVERTEXBUFFER8	m_pvbWhiteCells;
	FLOAT					m_pfWhiteCells[100];
	he3d_CVector			m_pvWhiteCells[100];

	CImageQuad*				m_piqFade;
	BOOL					m_bRenderFade;

	CImageQuad*				m_piqAuthor;
	PDIRECT3DTEXTURE8		m_ptextAuthor;

	he3d_CVector CalculateVector( FLOAT fT );
	he3d_CVector CalculateDeriv( FLOAT fT );	

public:

	CTunnel( PDIRECT3DDEVICE8 pDevice );
	virtual ~CTunnel();

	virtual BOOL InitEfx();
	virtual BOOL FinishEfx();
	virtual BOOL UpdateFrame( FLOAT fTime );
	virtual BOOL RenderEfx();
};

#endif // !defined(AFX_TUNEL_H__85A7B161_794D_11D5_AD0F_506957C10000__INCLUDED_)
