// TitleScreen.h: interface for the CTitleScreen class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TITLESCREEN_H__C7F076C1_7384_11D5_AD0F_106557C10000__INCLUDED_)
#define AFX_TITLESCREEN_H__C7F076C1_7384_11D5_AD0F_106557C10000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CTitleScreen : public CEfx  
{
private:
	
	CImageQuad*				m_piqTitle;		
	CImageQuad*				m_piqFlash;

	BOOL					m_bRenderFlash;
	BOOL					m_bRenderFade;

	FLOAT					m_fAlpha;
	DWORD					m_dwTextIndex;
	DWORD					m_dwAlphaIndex;

	FLOAT					m_fAngle;
	FLOAT					m_fSAlpha;
	FLOAT					m_fLogoPos;

	PDIRECT3DTEXTURE8		m_pptextMips[5];
	PDIRECT3DTEXTURE8		m_pptextAlpha[32];

	CSimpleMesh*			m_pmS;
	CSimpleMesh*			m_pmLogo;
	CTextureRenderer*		m_ptext;

	CSimpleMesh				m_mMirror[10];
	CSimpleMesh				m_mPiece[5];

	he3d_CMatrix			m_mtxMirror[10];	

	PDIRECT3DVERTEXBUFFER8	m_pvbCrack;
	DWORD					m_dwCrackFaces;
	FLOAT					m_fCrackScale;
	FLOAT					m_fCrackAlpha;
	FLOAT					m_fCrackMove;
	BOOL					m_bRenderCrack;

	PDIRECT3DVERTEXBUFFER8	m_pvbVolumetic[5];
	PDIRECT3DVERTEXBUFFER8	m_pvbInnerVolumetric[5];
	PDIRECT3DINDEXBUFFER8	m_pibInnerVolumetric[5];
	DWORD					m_dwVolumeFaces[5];
	FLOAT					m_fVolumeLen[5];	
	BOOL					m_bRenderVolume[5];
	he3d_CMatrix			m_mtxPiece[5];

public:

	CTitleScreen( PDIRECT3DDEVICE8 pDevice );
	virtual ~CTitleScreen();

	virtual BOOL InitEfx();
	virtual BOOL UpdateFrame( FLOAT fTime );
	virtual BOOL RenderEfx();
	virtual BOOL FinishEfx();		
};

#endif // !defined(AFX_TITLESCREEN_H__C7F076C1_7384_11D5_AD0F_106557C10000__INCLUDED_)
