//=he3d=file============================================================================================
//	Helium3d system	(c) 2000/2001 acid.z51 
//------------------------------------------------------------------------------------------------------
//
//	name:	he3d_texture.h
//  desc:	simply util function to load and menage textures
//			note that system have to be initiazlied before any loading may happend
//			the LoadTextureAutoAlpha function load texture and(!) alpha chanell if(!) 8bpp bmp with name
//			orginalnamewitoutextension_alpha.bmp is present
//			GetTexture do not(!) throw exception when texture is not present but simply
//			return NULL pointer
//			system is not case sensitive
//
//	history		
//		+ 11.02.2001				initial version by acid
//
//	todo
//		+ 11.02.2001				a lot :)
//======================================================================================================

#ifndef __TEXTURE_H_
#define __TEXTURE_H_

#include <d3dx8.h>

enum TEXTUREERRORCODES
{
	TEXERR_NOTINITIALIZED,
	TEXERR_NOFILEPRESENT,
	TEXERR_FILEFORMATERR,
	TEXERR_UNABLETOLOAD
};

class CTextureException
{
public:

	DWORD			code;

public:

	CTextureException( DWORD _code ) : code( _code )
	{
	}
};

enum AUTOALPHASTATE
{
	AAS_ALPHALOADED,
	AAS_ALPHANOTLOADED
};

enum MIPMAPS
{
	MIP_NONE	= 1,
	MIP_ALL		= 0,
	MIP_ONE		= 2,
	MIP_TWO		= 3,
	MIP_TREE	= 4
};

void InitializeTextureSystem( PDIRECT3DDEVICE8 pdevice, DWORD format = D3DFMT_A8R8G8B8 );
void CloseTextureSystem();
void SetTexturePath( const char* path );
int LoadTextureAutoAlpha( const char* filename, DWORD dwMip = MIP_NONE );
void LoadTexture( const char* filename, DWORD dwMip = MIP_NONE );
void LoadAlphaToTexture( const char* filename, const char* texturename );
void LoadTextureWithAlpha( const char* texfilename, const char* alpfilename, DWORD dwMip = MIP_NONE );
void LoadAlphaTexture( const char* filename );
void DeleteTexture( const char* name );
PDIRECT3DTEXTURE8 GetTexture( const char* name );

#endif
