// Flora.h: interface for the CFlora class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FLORA_H__80A58C46_81BE_11D5_AD0F_C06357C12026__INCLUDED_)
#define AFX_FLORA_H__80A58C46_81BE_11D5_AD0F_C06357C12026__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CFlora : public CEfx
{
private:

	he3d_CScene*			pScene;
	
	CParticleSystem			m_psSeed;	

	CFinitePointEmiter		m_peFlowers[5];		

	PDIRECT3DVERTEXBUFFER8	m_pvbVolumeHull;	
	PDIRECT3DVERTEXBUFFER8	m_pvbEnergyBeam;
	//PDIRECT3DVERTEXBUFFER8	m_pvbGroundPieces;

	FLOAT					m_pfVelocity[300];
	FLOAT					m_pfBornTime[300];
	he3d_CVector			m_pvPos[300];

	CSimpleMesh				m_mSky;

	he3d_CVector			m_vShiluette[10];

	VECTORKEY				m_vsVolume1[4];
	VECTORKEY				m_vsVolume2[4];
	VECTORKEY				m_vsVolume3[4];
	VECTORKEY				m_vsVolume4[4];
	VECTORKEY				m_vsVolume5[4];

	he3d_CVector			m_vVolumeScale[5];

	CImageQuad*				m_piqFade;

public:
	CFlora( PDIRECT3DDEVICE8 pDevice );
	virtual ~CFlora();

	virtual BOOL InitEfx();
	virtual BOOL FinishEfx();
	virtual BOOL UpdateFrame( FLOAT fTime );
	virtual BOOL RenderEfx();
};

#endif // !defined(AFX_FLORA_H__80A58C46_81BE_11D5_AD0F_C06357C12026__INCLUDED_)
