// BlackHole.h: interface for the CBlackHole class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BLACKHOLE_H__80A58C45_81BE_11D5_AD0F_C06357C12026__INCLUDED_)
#define AFX_BLACKHOLE_H__80A58C45_81BE_11D5_AD0F_C06357C12026__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

typedef struct _OBJECT
{
	FLOAT					m_fOmega;
	FLOAT					m_fAlpha;

	FLOAT					m_fDistance;

	he3d_CVector			m_vPos;
	he3d_CVector			m_vDir;

	BOOL					m_bThrowAway;

	FLOAT					m_fScale;	

} OBJECT, *POBJECT;

class CBlackHole : public CEfx
{
private:

	CSimpleMesh				m_mSphere;
	CSimpleMesh				m_mAsteroid;

	PDIRECT3DVERTEXBUFFER8	m_pvbHorizont;

	PDIRECT3DVERTEXBUFFER8	m_pvbBeams;
	he3d_CVector			m_vBeams[3000];
	FLOAT					m_fBornTime[3000];

	PDIRECT3DVERTEXBUFFER8	m_pvbParticle;
	FLOAT					m_fLastUpdate;

	POBJECT					m_poParticle;
	POBJECT					m_poPlanets;

	FLOAT					m_fFactor;

	CImageQuad*				m_piqFade;
	CImageQuad*				m_piqText;

public:
	
	CBlackHole( PDIRECT3DDEVICE8 pDevice );
	virtual ~CBlackHole();

	virtual BOOL InitEfx();
	virtual BOOL FinishEfx();
	virtual BOOL UpdateFrame( FLOAT fTime );
	virtual BOOL RenderEfx();
};

#endif // !defined(AFX_BLACKHOLE_H__80A58C45_81BE_11D5_AD0F_C06357C12026__INCLUDED_)
