// Door.cpp: implementation of the CDoor class.
//
//////////////////////////////////////////////////////////////////////
#include "Door.h"
#include "Sprite3d.h"

CSprite3d Textbande;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDoor::CDoor()
{

}

CDoor::~CDoor()
{

}


HRESULT CDoor::Init(LPDIRECT3DDEVICE7 pd3dDevice)
{
	AnimPorte.Init(pd3dDevice,"door.tld");
	Textbande.Initf(pd3dDevice,"layers/bandetext.jpg",-1,5,2.50,4);
	return S_OK;
}



bool CDoor::FrameMove(LPDIRECT3DDEVICE7 pd3dDevice, FLOAT fTimeKey)
{
	AnimPorte.FrameMove(pd3dDevice,fTimeKey);
	delta = fTimeKey - fFirstTimeKey;
	if(delta > 33 )
		return TRUE;
    if (delta > 5 ) Textbande.Move(1,1,1,1);
	return FALSE;
}


HRESULT CDoor::Render( LPDIRECT3DDEVICE7 pd3dDevice )
{
	AnimPorte.Render(pd3dDevice);
    if (delta > 5 ) Textbande.Render(pd3dDevice);
	return S_OK;
}


void CDoor::ReInit(LPDIRECT3DDEVICE7 pd3dDevice)
{
	AnimPorte.ReInit(pd3dDevice);
	fFirstTimeKey = timeGetTime() * 0.001f;
}
