// Particle.cpp: implementation of the CParticle class.
// coded by keus  & captainfr 09/07/2000 at party place
//////////////////////////////////////////////////////////////////////

#include "Particle.h"
#include "texture.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CParticle::CParticle()
{

}

CParticle::~CParticle()
{
	
}


HRESULT CParticle::Init(LPDIRECT3DDEVICE7 pd3dDevice,int NbParticles,float ffar)
{
	m_NbParticles = NbParticles;
	
	Map.Initf(pd3dDevice,"particle2.jpg",0,0,0,0);

	for(int i=0;i<m_NbParticles;i++)
	{
		Particles[i].x = 0;
		Particles[i].y = 0;
		Particles[i].z = 0;
		Particles[i].fade = 0;
		Particles[i].xi = float(((rand()%50)-26.0f)*5.0f)/(1000*2.5f);
		//Particles[i].yi = float(((rand()%50)-0.0f)*5.0f)/(1000*2.5f);
		Particles[i].yi = float(((rand()%50)-0.0f)*5.0f)/(1000*2.5f)+ 6;
		Particles[i].zi = float(((rand()%50)-25.0f+ffar)*5.0f)/(1000*2.5f);
	}
	return S_OK;
}



bool CParticle::FrameMove(LPDIRECT3DDEVICE7 pd3dDevice, float fTimeKey)
{
	for(int i=0;i<m_NbParticles;i++)
	{
		Particles[i].x += (Particles[i].xi + Particles[i].xg)* cosf(fTimeKey)*1.5f;
		Particles[i].y += (Particles[i].yi + Particles[i].yg)* cosf(fTimeKey)*1.5f;
		Particles[i].z += (Particles[i].zi + Particles[i].zg)* cosf(fTimeKey);
	}

	return FALSE;
}


bool CParticle::FrameMoveLINE(LPDIRECT3DDEVICE7 pd3dDevice, float fTimeKey)
{
	float delta = fTimeKey - fFirstTimeKey;

	if(delta > 33)
	{
		for(int i=0;i<m_NbParticles;i++)
		{
			//Particles[i].x += (Particles[i].xi + Particles[i].xg)* cosf(fTimeKey)*1.5f;
			Particles[i].x += Particles[i].xi;
			if (Particles[i].x > 8) 
				Particles[i].xi = -Particles[i].xi;
			if (Particles[i].x < -8) 
				Particles[i].xi = -Particles[i].xi;

			//Particles[i].y += (Particles[i].yi + Particles[i].yg)* cosf(fTimeKey)*1.5f;
				Particles[i].y = 7.5f + cosf(fTimeKey+i*4)*0.2f - (delta-33);
				Particles[i].z += (Particles[i].zi + Particles[i].zg)* cosf(fTimeKey);
		}
	}


	return FALSE;
}


bool CParticle::FrameMoveLINE2(LPDIRECT3DDEVICE7 pd3dDevice, float fTimeKey)
{
	float delta = fTimeKey - fFirstTimeKey;

	if(delta > 33)
	{
		for(int i=0;i<m_NbParticles;i++)
		{
			//Particles[i].x += (Particles[i].xi + Particles[i].xg)* cosf(fTimeKey)*1.5f;
			Particles[i].x += Particles[i].xi;
			if (Particles[i].x > 8) 
				Particles[i].xi = -Particles[i].xi;
			if (Particles[i].x < -8) 
				Particles[i].xi = -Particles[i].xi;

			//Particles[i].y += (Particles[i].yi + Particles[i].yg)* cosf(fTimeKey)*1.5f;
				Particles[i].y = cosf(fTimeKey+i*4)*0.2f - (delta-33);
				Particles[i].z += (Particles[i].zi + Particles[i].zg)* cosf(fTimeKey);
		}
	}


	return FALSE;
}

HRESULT CParticle::Render(LPDIRECT3DDEVICE7 pd3dDevice)
{
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ZENABLE, FALSE );
	for(int i=0;i<m_NbParticles;i++)
	{
		Map.MoveZ(Particles[i].x-0.5f,Particles[i].y+0.5f,Particles[i].x+0.5f,Particles[i].y-0.5f,Particles[i].z);
		Map.Render(pd3dDevice);
	}
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ZENABLE, TRUE );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, FALSE );
	return S_OK;
}

void CParticle::ReInit(LPDIRECT3DDEVICE7 pd3dDevice)
{
    pd3dDevice->SetRenderState( D3DRENDERSTATE_AMBIENT, D3DRGB( 1,1,1) );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_LIGHTING, FALSE );
	fFirstTimeKey = timeGetTime() * 0.001f;
}