// Greets2.cpp: implementation of the Greets class.
// coded by captainfr 09/07/2000 at party place
//////////////////////////////////////////////////////////////////////

#include "Greets2.h"
#include "Sprite3d.h"
#include "particle.h"
#include "LoadTLD.h"

CSprite3d Greets[9];
CParticle Particles;
CLoadTLD blob;


float gposx[9],
      gposy[9],
	  gposh[9],
	  gposb[9];
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CGreets::CGreets()
{

}

CGreets::~CGreets()
{

}

HRESULT CGreets::Init(LPDIRECT3DDEVICE7 pd3dDevice)
{
	Particles.Init(pd3dDevice,150,0);
	blob.Init(pd3dDevice,"greets.tld");

	Greets[1].Initf(pd3dDevice,"textures/Kami.jpg",-15,6,-30,4.5f);
	Greets[2].Initf(pd3dDevice,"textures/Talis.jpg",15,-1,30,-2.5f);
	Greets[3].Initf(pd3dDevice,"textures/Mei.jpg",-15,-2,-30,-4.5f);
	Greets[4].Initf(pd3dDevice,"textures/Sigo.jpg",15,3,30,5.5f);
	Greets[5].Initf(pd3dDevice,"textures/doh.jpg",-15,2.5f,-30,5);
	Greets[6].Initf(pd3dDevice,"textures/vengeurs.jpg",15,6,30,4.5f);
	Greets[7].Initf(pd3dDevice,"textures/codefr.jpg",-15,-1,-30,-2.5f);
	Greets[8].Initf(pd3dDevice,"textures/orion.jpg",15,-2,30,-4.5f);
	Greets[9].Initf(pd3dDevice,"textures/popsy.jpg",-15,3,-30,5.5f);
    gposx[1] = -15; gposh[1] = 6;    gposy[1] = -30; gposb[1] = 4.5f;
	gposx[2] = 15;  gposh[2] = -1;   gposy[2] = 30;  gposb[2] = -2.5f;
	gposx[3] = -15; gposh[3] = -2;   gposy[3] = -30; gposb[3] = -4.5f;
	gposx[4] = 15;  gposh[4] = 3;    gposy[4] = 30;  gposb[4] = 5.5f;
	gposx[5] = -15; gposh[5] = 2.5f; gposy[5] = -30; gposb[5] = 5;
	gposx[6] = 15;  gposh[6] = 6;    gposy[6] = 30;  gposb[6] = 4.5f;
	gposx[7] = -15; gposh[7] = -1;   gposy[7] = -30; gposb[7] = -2.5f;
	gposx[8] = 15;  gposh[8] = -2;   gposy[8] = 30;  gposb[8] = -4.5f;
	gposx[9] = -15; gposh[9] = 3;    gposy[9] = -30; gposb[9] = 5.5f;

	return S_OK;
}



bool CGreets::FrameMove(LPDIRECT3DDEVICE7 pd3dDevice, FLOAT fTimeKey)
{
	
	delta = fTimeKey - fFirstTimeKey;
	if(delta > 33 )
		return TRUE;

	Particles.FrameMoveLINE2(pd3dDevice,fTimeKey);
//	blob.Scene[0].SetRotate(cosf(fTimeKey),cosf(fTimeKey),cosf(fTimeKey));
//	blob.Scene[0].UpdateVB(blob.Scene[0].Obj);
	blob.FrameMove(pd3dDevice,fTimeKey);
    

    if ((delta > 1) && (delta < 20))
	{
		gposx[1] = gposx[1]+0.1f;
		gposy[1] = gposy[1] + 0.1f;
		Greets[1].Move(gposb[1],gposx[1],gposy[1],gposh[1]);
	}
   
	if ((delta > 25) && (delta < 45))
	{
		gposx[2] = gposx[2]-0.1f;
		gposy[2] = gposy[2] - 0.1f;
		Greets[2].Move(gposx[2],gposh[2],gposy[2],gposb[2]);
	}


	if ((delta > 3) && (delta < 23))
	{
		gposx[3] = gposx[3]+0.1f;
		gposy[3] = gposy[3] + 0.1f;
		Greets[3].Move(gposx[3],gposh[3],gposy[3],gposb[3]);
	}
if ((delta > 7) && (delta < 27))
	{
		gposx[4] = gposx[4]-0.1f;
		gposy[4] = gposy[4] - 0.1f;
		Greets[4].Move(gposx[4],gposh[4],gposy[4],gposb[4]);
	}
if ((delta > 10) && (delta < 30))
	{
		gposx[5] = gposx[5]+0.1f;
		gposy[5] = gposy[5] + 0.1f;
		Greets[5].Move(gposx[5],gposh[5],gposy[5],gposb[5]);
	}
if ((delta > 14) && (delta < 34))
	{
		gposx[6] = gposx[6]-0.1f;
		gposy[6] = gposy[6] - 0.1f;
		Greets[6].Move(gposx[6],gposh[6],gposy[6],gposb[6]);
	}
if ((delta > 17) && (delta < 37))
	{
		gposx[7] = gposx[7]+0.1f;
		gposy[7] = gposy[7] + 0.1f;
		Greets[7].Move(gposx[7],gposh[7],gposy[7],gposb[7]);
	}
if ((delta > 20) && (delta < 40))
	{
		gposx[8] = gposx[8]-0.1f;
		gposy[8] = gposy[8] - 0.1f;
		Greets[8].Move(gposx[8],gposh[8],gposy[8],gposb[8]);
	}
if ((delta > 23) && (delta < 43))
	{
		gposx[9] = gposx[9]+0.1f;
		gposy[9] = gposy[9] + 0.1f;
		Greets[9].Move(gposx[9],gposh[9],gposy[9],gposb[9]);
	}

	if (delta > 50)
		return TRUE;

	return FALSE;
}


HRESULT CGreets::Render( LPDIRECT3DDEVICE7 pd3dDevice )
{
	//Particles.Render(pd3dDevice);
	blob.Render(pd3dDevice);

	pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );
    if ((delta > 1 ) && (delta < 20)) Greets[1].Render(pd3dDevice);
    if ((delta > 25 ) && (delta < 45)) Greets[2].Render(pd3dDevice);
	if ((delta > 3) && (delta < 23)) Greets[3].Render(pd3dDevice);
	if ((delta > 7 ) && (delta < 27)) Greets[4].Render(pd3dDevice);
    if ((delta > 10 ) && (delta < 30)) Greets[5].Render(pd3dDevice);
	if ((delta > 14 ) && (delta < 34)) Greets[6].Render(pd3dDevice);
	if ((delta > 17 ) && (delta < 37)) Greets[7].Render(pd3dDevice);
    if ((delta > 20 ) && (delta < 40)) Greets[8].Render(pd3dDevice);
	if ((delta > 23 ) && (delta < 43)) Greets[9].Render(pd3dDevice);
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, FALSE );
	return S_OK;
}


void CGreets::ReInit(LPDIRECT3DDEVICE7 pd3dDevice)
{
	
	fFirstTimeKey = timeGetTime() * 0.001f;
	blob.ReInit(pd3dDevice);
	blob.FrameMove(pd3dDevice,fFirstTimeKey);
}
