// Door.cpp: implementation of the CDoor class.
// coded by keus  & captainfr 09/07/2000 at party place
//////////////////////////////////////////////////////////////////////
#include "Door.h"
#include "Sprite3d.h"

CSprite3d Textbande;
CSprite3d layer[5];

float posx[6],
      posy[6],
	  posh[6],
	  posb[6];
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDoor::CDoor()
{

}

CDoor::~CDoor()
{

}


HRESULT CDoor::Init(LPDIRECT3DDEVICE7 pd3dDevice)
{
	AnimPorte.Init(pd3dDevice,"door.tld");
	Textbande.Initf(pd3dDevice,"layers/bandetext.jpg",10,6,50,4.5f);
    layer[1].Initf(pd3dDevice,"layers/layer11.jpg",10,-2,10,-3);
    layer[2].Initf(pd3dDevice,"layers/layer8.jpg",10,-1,10,-2.2f);
	posx[1] = 5; posh[1] = 6; posy[1] = 50; posb[1] = 4.5f;
	posx[2] = 5; posh[2] = -2; posy[2] = 10; posb[2] = -3;
	posx[3] = 5; posh[3] = -1; posy[3] = 10; posb[3] = -2.2f;
	return S_OK;
}



bool CDoor::FrameMove(LPDIRECT3DDEVICE7 pd3dDevice, FLOAT fTimeKey)
{
	AnimPorte.FrameMove(pd3dDevice,fTimeKey);
	delta = fTimeKey - fFirstTimeKey;
	if(delta > 33 )
		return TRUE;
    if ((delta > 6 ) && (delta < 30))
	{
		posx[1] = posx[1]-0.1f;
		posy[1] = posy[1] - 0.1f;
		Textbande.Move(posx[1],posh[1],posy[1],posb[1]);
	}
    if ((delta > 15 ) && (delta < 20))
	{
		posx[2] = posx[2]-0.1f;
		posy[2] = posy[2] - 0.1f;
		layer[1].Move(posx[2],posh[2],posy[2],posb[2]);
	}
	if ((delta > 22 ) && (delta < 27))
	{
		posx[3] = posx[3] - 0.1f;
		posy[3] = posy[3] - 0.1f;
		layer[2].Move(posx[3],posh[3],posy[3],posb[3]);
	}
	return FALSE;
}


HRESULT CDoor::Render( LPDIRECT3DDEVICE7 pd3dDevice )
{
	
	AnimPorte.Render(pd3dDevice);
    pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );
    if (delta > 5 ) Textbande.Render(pd3dDevice);
    if ((delta > 15 ) && (delta < 20)) layer[1].Render(pd3dDevice);
	if ((delta > 22 ) && (delta < 27)) layer[2].Render(pd3dDevice);
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, FALSE );
	return S_OK;
}


void CDoor::ReInit(LPDIRECT3DDEVICE7 pd3dDevice)
{
	AnimPorte.ReInit(pd3dDevice);
	fFirstTimeKey = timeGetTime() * 0.001f;
}
