// CityPart.cpp: implementation of the CCityPart class.
// coded by keus juillet 2000
//////////////////////////////////////////////////////////////////////

#include "CityPart.h"
#include "Particle.h"

CParticle Partic;
CSprite3d Texte2;
CSprite3d Layer[5];
CSprite3d Titre3;
CSprite3d LogoMDR;
CSprite3d LogoTLD;
CSprite3d Porte;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCityPart::CCityPart()
{

}

CCityPart::~CCityPart()
{

}


HRESULT CCityPart::Init(LPDIRECT3DDEVICE7 pd3dDevice)
{
	Titre3.Initf(pd3dDevice,"layers/titre3.jpg",-8,8,8,-8);

	LogoMDR.Initf(pd3dDevice,"layers/mdr.jpg",-6,3.4f,6,-3.4f);
	LogoTLD.Initf(pd3dDevice,"layers/tld.jpg",-6,3.4f,6,-3.4f);
	Porte.Initf(pd3dDevice,"textures/porte.jpg",-9,8.4f,9,-8.4f);

	Partic.Init(pd3dDevice,100,1);
	CityAnim.Init(pd3dDevice,"city.tld");
	Texte2.Initf(pd3dDevice,"texte2.jpg",-8,8,8,-8);
	Layer[0].Initf(pd3dDevice,"layers/layer5.jpg",-6,5,2.5f,3.8f);
	return S_OK;
}

bool CCityPart::FrameMove(LPDIRECT3DDEVICE7 pd3dDevice, float fTimeKey)
{
	Partic.FrameMoveLINE(pd3dDevice,fTimeKey);
	CityAnim.FrameMove(pd3dDevice,fTimeKey);
//	if(CityAnim.Camera.Frame  CityAnim.Camera.NbCameraPos)
//		return TRUE;
	delta = fTimeKey - fFirstTimeKey;
	if(delta > 46 )
		return TRUE;

	if((delta > 0) && (delta < 5))
		Layer[0].MoveTBL(delta);

	return FALSE;
}

HRESULT CCityPart::Render(LPDIRECT3DDEVICE7 pd3dDevice)
{
	CityAnim.Render(pd3dDevice);
	if ((delta > 33) && (delta <= 46))
		Partic.Render(pd3dDevice);
	if ((delta >42) &&(delta<= 46 ))
	Porte.Render(pd3dDevice);

	pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );
	if ((delta > 0) && (delta < 3))
		LogoMDR.Render(pd3dDevice);
	if ((delta > 5) && (delta < 8))
		LogoTLD.Render(pd3dDevice);


	if((delta > 10) && (delta < 14))
		Titre3.Render(pd3dDevice);

	//Texte2.Render(pd3dDevice);
	//Layer[0].Render(pd3dDevice);
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, FALSE );

	return S_OK;
}

void CCityPart::ReInit(LPDIRECT3DDEVICE7 pd3dDevice)
{
	Partic.ReInit(pd3dDevice);
	CityAnim.ReInit(pd3dDevice);
	fFirstTimeKey = timeGetTime() * 0.001f;

	pd3dDevice->SetRenderState( D3DRENDERSTATE_FOGENABLE, FALSE );

	    D3DMATRIX mat;
	D3DUtil_SetIdentityMatrix(mat);
    D3DMATRIX matWorld = mat;
    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &matWorld );
    D3DMATRIX matView = mat;
    matView._43 = 15.0f;
    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_VIEW, &matView );
    D3DMATRIX matProj = mat;
    matProj._11 =  2.0f;
    matProj._22 =  2.0f;
    matProj._34 =  1.0f;
    matProj._43 = -1.0f;
    matProj._44 =  0.5f;
	//funy shit //D3DUtil_SetProjectionMatrix(matProj, float(3.1415/1.15), 4/3, 1.01f, 200000.0f);
	//D3DUtil_SetProjectionMatrix(matProj, float(43.4558), 800/600, 1.01f, 200000.0f);
    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_PROJECTION, &matProj );

}