// AlphaLayer.cpp: implementation of the CAlphaLayer class.
// coded by keus juin 2000
//////////////////////////////////////////////////////////////////////
#define RANDOM_NUM      (((FLOAT)rand()-(FLOAT)rand())/RAND_MAX)
#define RANDOM_VECTOR   D3DVECTOR(RANDOM_NUM,RANDOM_NUM,RANDOM_NUM)

#include "AlphaLayer.h"
#include "TLDutils.h"
#include "D3DUtil.h"
#include "texture.h"


float ExploTimeKey = 1.0f;
// local proto
VOID BlendMeshes( D3DVERTEX* pDstMesh, D3DVERTEX* pSrcMesh1,
                  D3DVERTEX* pSrcMesh2, DWORD dwNumVertices, FLOAT fWeight );
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAlphaLayer::CAlphaLayer()
{

}

CAlphaLayer::~CAlphaLayer()
{
	delete [] Obj;
}

void CAlphaLayer::Init(LPDIRECT3DDEVICE7 pd3dDevice,char *filename,bool VB)
{
	hFile = fopen(filename,"r");
	if (!hFile) 
	{
		sprintf(debug,"foirage de l'ouverture de %s",filename);
		MessageBox(NULL,debug,"z",MB_OK);
	}
	rewind (hFile);

	GoToObj(hFile,1);
	char name[50];
	fscanf(hFile,"%s",&name);

	LoadObject(name);

	fclose(hFile);

	if (CreateVertexBuffer(pd3dDevice) != S_OK )
		MessageBox(NULL,"d'la merde ce vertex buffer","z",MB_OK);

	D3DUtil_SetIdentityMatrix(matRotate);

	FakeVertexBuffer = new D3DVERTEX[m_NbObjVertex];

	if(VB) UpdateVB(Obj);
	else   UpdateFVB(Obj);

	UpdateVB(Obj);

}

void CAlphaLayer::MultiInit(LPDIRECT3DDEVICE7 pd3dDevice,char *filename,int num,bool VB)
{
	hFile = fopen(filename,"r");
	if (!hFile) 
	{
		sprintf(debug,"foirage de l'ouverture de %s",filename);
		MessageBox(NULL,debug,"z",MB_OK);
	}
	rewind (hFile);

	GoToObj(hFile,num);
	char name[50];
	fscanf(hFile,"%s",&name);

	LoadObject(name);

	fclose(hFile);

	if (CreateVertexBuffer(pd3dDevice) != S_OK )
		MessageBox(NULL,"d'la merde ce vertex buffer","z",MB_OK);

	D3DUtil_SetIdentityMatrix(matRotate);

	FakeVertexBuffer = new D3DVERTEX[m_NbObjVertex];

	if(VB) UpdateVB(Obj);
	else   UpdateFVB(Obj);

	UpdateVB(Obj);

}

///////////////////////////////////////////////////////////////////////
// render Obj
///////////////////////////////////////////////////////////////////////
void CAlphaLayer::Render(LPDIRECT3DDEVICE7 pd3dDevice, bool Alpha)
{
	pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &matRotate );

	if (Alpha)
	{
		pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );

		ApplySphereMapToObject(pd3dDevice,Obj,m_NbObjVertex);

		pd3dDevice->DrawPrimitive( D3DPT_TRIANGLELIST, D3DFVF_VERTEX,
                                    FakeVertexBuffer, m_NbObjVertex, 0 );
		//pd3dDevice->DrawPrimitiveVB( D3DPT_TRIANGLELIST, VertexBuffer,
		//						 0, m_NbObjVertex, NULL );
		pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, FALSE );
	}

	else
	{

	ApplySphereMapToObject(pd3dDevice,Obj,m_NbObjVertex);
	pd3dDevice->DrawPrimitive( D3DPT_TRIANGLELIST, D3DFVF_VERTEX,
                                    FakeVertexBuffer, m_NbObjVertex, 0 );
	//pd3dDevice->DrawPrimitiveVB( D3DPT_TRIANGLELIST, VertexBuffer,
	//							 0, m_NbObjVertex, NULL );
	}

	D3DMATRIX mat;
	D3DUtil_SetIdentityMatrix(mat);
	pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &mat );

}

void CAlphaLayer::SRender(LPDIRECT3DDEVICE7 pd3dDevice)
{
	pd3dDevice->DrawPrimitive( D3DPT_TRIANGLELIST, D3DFVF_VERTEX,
                                    FakeVertexBuffer, m_NbObjVertex, 0 );
	//pd3dDevice->DrawPrimitiveVB( D3DPT_TRIANGLELIST, VertexBuffer,
	//							 0, m_NbObjVertex, NULL );
}

void CAlphaLayer::RenderVB(LPDIRECT3DDEVICE7 pd3dDevice, bool Alpha)
{
	pd3dDevice->DrawPrimitiveVB( D3DPT_TRIANGLELIST, VertexBuffer,
								 0, m_NbObjVertex, NULL );
}

void CAlphaLayer::RenderVBRO(LPDIRECT3DDEVICE7 pd3dDevice, bool Alpha)
{
	pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &matRotate );

	
	pd3dDevice->DrawPrimitiveVB( D3DPT_TRIANGLELIST, VertexBuffer,
								 0, m_NbObjVertex, NULL );
		D3DMATRIX mat;
	D3DUtil_SetIdentityMatrix(mat);
	pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &mat );

}




void CAlphaLayer::InitExplosion()
{
	ExploParam = new D3DVECTOR[m_NbObjFaces];

	for (int i=0;i<m_NbObjFaces;i++)
	{
		ExploParam[i] = Normalize(RANDOM_VECTOR);
		ExploParam[i].x += 1.0f;
		ExploParam[i].y += 1.0f;
		ExploParam[i].z += 1.0f;
	}

	D3DMATRIX mat;
	Exploded = new D3DVERTEX[m_NbObjVertex];
	for(i=0;i<m_NbObjFaces;i++)
	{		
		D3DUtil_SetScaleMatrix( mat, ExploParam[i].x,
									 ExploParam[i].y,
									 ExploParam[i].z);
		D3DMath_VertexMatrixMultiply( Exploded[i*3], Obj[i*3], mat);
		D3DMath_VertexMatrixMultiply( Exploded[i*3+1], Obj[i*3+1], mat);
		D3DMath_VertexMatrixMultiply( Exploded[i*3+2], Obj[i*3+2], mat);

	}

	delete [] ExploParam;
}


void CAlphaLayer::DoExplosion(float fTimeKey, bool sens)
{
	D3DVERTEX* ObjTemp;
	ObjTemp = new D3DVERTEX[m_NbObjVertex];

	if (sens)
		ExploTimeKey-= 0.01f;
	else ExploTimeKey+= 0.01f;
	BlendMeshes( ObjTemp, Obj, Exploded, m_NbObjVertex, ExploTimeKey);

	// update Vertex Buffer
	UpdateVB(ObjTemp);
	delete [] ObjTemp;
}



//-----------------------------------------------------------------------------
// Name: BlendMeshes()
// Desc: Does a linear interpolation between all vertex positions and normals
//       in two source meshes and outputs the result to the destination mesh.
//       This function assumes that all strided vertices have the same stride,
//       and that each mesh contains the same number of vertices
//-----------------------------------------------------------------------------
VOID BlendMeshes( D3DVERTEX* pDstMesh, D3DVERTEX* pSrcMesh1,
                  D3DVERTEX* pSrcMesh2, DWORD dwNumVertices, FLOAT fWeight )
{
    FLOAT fInvWeight = 1.0f - fWeight;

    // LERP positions and normals
    for( DWORD i=0; i<dwNumVertices; i++ )
    {
        pDstMesh->x  = fWeight*pSrcMesh1->x  + fInvWeight*pSrcMesh2->x;
        pDstMesh->y  = fWeight*pSrcMesh1->y  + fInvWeight*pSrcMesh2->y;
        pDstMesh->z  = fWeight*pSrcMesh1->z  + fInvWeight*pSrcMesh2->z;
        pDstMesh->nx = fWeight*pSrcMesh1->nx + fInvWeight*pSrcMesh2->nx;
        pDstMesh->ny = fWeight*pSrcMesh1->ny + fInvWeight*pSrcMesh2->ny;
        pDstMesh->nz = fWeight*pSrcMesh1->nz + fInvWeight*pSrcMesh2->nz;
		pDstMesh->tu = pSrcMesh1->tu;
		pDstMesh->tv = pSrcMesh1->tv;


        pDstMesh++;
        pSrcMesh1++;
        pSrcMesh2++;
    }
}


void CAlphaLayer::UpdateFVB(D3DVERTEX* Prout)
{
/*    D3DVERTEX* pVertices;
    if( SUCCEEDED( VertexBuffer->Lock( DDLOCK_WAIT, (VOID**)&pVertices,
                                          NULL ) ) )
    {
		for (int i=0;i<m_NbObjVertex;i++)
			pVertices[i] = Prout[i];

        VertexBuffer->Unlock();
    }
	else MessageBox(NULL,"failed to lock Vertex Buffer","z",MB_OK);*/
	for (int i=0;i<m_NbObjVertex;i++)
		FakeVertexBuffer[i] = Prout[i];

}

void CAlphaLayer::UpdateVB(D3DVERTEX* Prout)
{
	/*char debug[50];
	sprintf(debug,"m_NbObjVertex = %d",m_NbObjVertex);
	MessageBox(NULL,debug,"z",MB_OK);*/
    D3DVERTEX* pVertices;
    if( SUCCEEDED( VertexBuffer->Lock( DDLOCK_WAIT, (VOID**)&pVertices,
                                          NULL ) ) )
    {
		for (int i=0;i<m_NbObjVertex;i++)
			pVertices[i] = Prout[i];

        VertexBuffer->Unlock();
    }
	else MessageBox(NULL,"failed to lock Vertex Buffer","z",MB_OK);
}


//-----------------------------------------------------------------------------
// Name: ApplySphereMapToObject()
// Desc: Uses the current orientation of the vertices to calculate the object's
//       spheremapped texture coords.
//-----------------------------------------------------------------------------
HRESULT CAlphaLayer::ApplySphereMapToObject(LPDIRECT3DDEVICE7 pd3dDevice ,D3DVERTEX* pvVertices, DWORD dwNumVertices )
{
    // Get the current world-view matrix
    D3DMATRIX matWorld, matView, matWV;
    pd3dDevice->GetTransform( D3DTRANSFORMSTATE_VIEW,  &matView );
    pd3dDevice->GetTransform( D3DTRANSFORMSTATE_WORLD, &matWorld );
    D3DMath_MatrixMultiply( matWV, matWorld, matView );

    // Extract world-view matrix elements for speed
    FLOAT m11 = matWV._11,   m21 = matWV._21,   m31 = matWV._31;
    FLOAT m12 = matWV._12,   m22 = matWV._22,   m32 = matWV._32;
    FLOAT m13 = matWV._13,   m23 = matWV._23,   m33 = matWV._33;

    // Loop through the vertices, transforming each one and calculating
    // the correct texture coordinates.
    for( WORD i = 0; i < dwNumVertices; i++ )
    {
        FLOAT nx = pvVertices[i].nx;
        FLOAT ny = pvVertices[i].ny;
        FLOAT nz = pvVertices[i].nz;

        // Check the z-component, to skip any vertices that face backwards
        if( nx*m13 + ny*m23 + nz*m33 > 0.0f )
            continue;

        // Assign the spheremap's texture coordinates
        pvVertices[i].tu = 0.5f * ( 1.0f + ( nx*m11 + ny*m21 + nz*m31 ) );
        pvVertices[i].tv = 0.5f * ( 1.0f - ( nx*m12 + ny*m22 + nz*m32 ) );
    }

    return S_OK;
}



//-----------------------------------------------------------------------------
// Name: ApplySphereMapToObject()
// Desc: Uses the current orientation of the vertices to calculate the object's
//       spheremapped texture coords.
//-----------------------------------------------------------------------------
HRESULT CAlphaLayer::ApplyMapToObject(LPDIRECT3DDEVICE7 pd3dDevice ,D3DVERTEX* pvVertices, DWORD dwNumVertices )
{
    // Get the current world-view matrix
    D3DMATRIX matWorld, matView, matWV;
    pd3dDevice->GetTransform( D3DTRANSFORMSTATE_VIEW,  &matView );
    pd3dDevice->GetTransform( D3DTRANSFORMSTATE_WORLD, &matWorld );
    D3DMath_MatrixMultiply( matWV, matWorld, matView );

    // Extract world-view matrix elements for speed
    FLOAT m11 = matWV._11,   m21 = matWV._21,   m31 = matWV._31;
    FLOAT m12 = matWV._12,   m22 = matWV._22,   m32 = matWV._32;
    FLOAT m13 = matWV._13,   m23 = matWV._23,   m33 = matWV._33;

    // Loop through the vertices, transforming each one and calculating
    // the correct texture coordinates.
    for( WORD i = 0; i < dwNumVertices; i++ )
    {
        FLOAT nx = pvVertices[i].nx;
        FLOAT ny = pvVertices[i].ny;
        FLOAT nz = pvVertices[i].nz;

        // Check the z-component, to skip any vertices that face backwards
        if( nx*m13 + ny*m23 + nz*m33 > 0.0f )
            continue;

        // Assign the spheremap's texture coordinates
        pvVertices[i].tu = ((nx*m11 + ny*m21 + nz*m31  ) / 3);
        pvVertices[i].tv = (( nx*m12 + ny*m22 + nz*m32 ) /3);
    }

    return S_OK;
}


void CAlphaLayer::ApplyDisplacement(LPDIRECT3DDEVICE7 pd3dDevice, char* Filename)
{
/*	LPDIRECTDRAWSURFACE7 pddsRender        = NULL;
	LPDIRECTDRAW7        lpDD			   = NULL;
	LPDIRECTDRAWSURFACE7 lpDisplacementMap = NULL;
	LPDIRECTDRAWSURFACE7 lpTempSurf        = NULL;

    pd3dDevice->GetRenderTarget( &pddsRender );
    pddsRender->GetDDInterface( (VOID**)&lpDD );
    pddsRender->Release();
	
	lpTempSurf = CreateTexture(pd3dDevice,Filename);

	DDSURFACEDESC2 ddsdTemp;
    ZeroMemory( &ddsdTemp, sizeof(DDSURFACEDESC2) );
    ddsdTemp.dwSize = sizeof(DDSURFACEDESC2);
	lpTempSurf->GetSurfaceDesc(&ddsdTemp);

    DDSURFACEDESC2 ddsd;
    ZeroMemory( &ddsd, sizeof(DDSURFACEDESC2) );
    ddsd.dwSize          = sizeof(DDSURFACEDESC2);
    ddsd.dwFlags         = DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH|
                           DDSD_PIXELFORMAT;
    ddsd.ddsCaps.dwCaps  = DDSCAPS_TEXTURE;
    ddsd.dwWidth         = ddsdTemp.dwWidth;
    ddsd.dwHeight        = ddsdTemp.dwHeight;
	ddsd.ddpfPixelFormat.dwRGBBitCount = 8;
	ddsd.ddpfPixelFormat.dwSize = sizeof(DDPIXELFORMAT);

    if( DD_OK != lpDD->CreateSurface( &ddsd, &lpDisplacementMap, NULL ) ) 
        MessageBox(NULL,"merdouille","z",MB_OK);

	lpDisplacementMap->Blt(NULL,lpTempSurf,NULL,DDBLT_WAIT ,NULL);
	
	UCHAR* DisplacementBuffer;
	lpDisplacementMap->Lock(NULL,&ddsd, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT,NULL);
	DisplacementBuffer = (UCHAR *)ddsd.lpSurface; 
	lpDisplacementMap->Unlock(NULL);	

	for(i=0;i<30;i++)
	{
		char debug[260];
		sprintf(debug,"pixel %d de la displacement map= %d",i,DisplacementBuffer[i]);
		MessageBox(NULL,debug,"z",MB_OK);
	}



	lpTempSurf->Release();
	lpDisplacementMap->Release();
	lpDD->Release();*/
}	
