#declare FrontTex = texture {
  pigment {
    gradient y
    turbulence 0.3
    color_map {
      [0.00 color rgb <1.00,0.50,0.00> ]
      [0.20 color rgb <0.65,0.16,0.16> ]
      [0.80 color rgb <0.18,0.31,0.18> ]
      [0.90 color rgb <0.18,0.31,0.18> ]
      [0.95 color rgb <0.00,1.00,0.00> ]
      [1.00 color rgb <0.18,0.31,0.18> ]
    }
    scale 0.5
    rotate 90*z 
    turbulence 0.4
  }   
  normal {
    bumps 0.8
    scale 0.5
  }
}

#declare BodyTex = texture {
  pigment {
    granite
    turbulence 0.3
    color_map {
      [0.0 color rgb <0.65,0.16,0.16> ]
      [0.1 color rgb <0.18,0.31,0.18> ]
      [0.7 color rgb <0.18,0.56,0.14> ]
      [1.0 color rgb <0.18,0.31,0.18> ]
    }
    scale 2
  }   
  normal {
    bumps 0.2
    scale 0.5
  }
}

#declare ShellTex01 = texture {
  pigment {
    granite
    color_map {
      [0.0 color rgb <0.52,0.37,0.26>*0.9+<0.00,1.00,0.00>*0.1 ]
      [1.0 color rgb <0.65,0.16,0.16>*0.5+<0.18,0.31,0.18>*0.1    ]
    }
  }
  normal { 
    bumps 0.3
    scale 0.5
  }    
  finish {phong 1 phong_size 300 reflection 0.13}
}

#declare ShellTex02 = texture {
  pigment {
    granite
    color_map {
      [0.0 color rgb <0.52,0.37,0.26>*0.95+<0.00,1.00,0.00>*0.2 ]
      [1.0 color rgb <0.65,0.16,0.16>*0.6+<0.18,0.31,0.18>*0.2    ]
    }
  }
  normal { 
    bumps 0.3
    scale 0.5
  }
  finish {phong 1 phong_size 300 reflection 0.13}
}

#declare ShellRimTex = texture {
  pigment {
    granite
    color_map {
      [0.0 color rgb <0.52,0.37,0.26>*0.5+<0.00,1.00,0.00>*0.1 ]
      [1.0 color rgb <0.65,0.16,0.16>*0.1+<0.18,0.31,0.18>*0.1    ]
    }
  }
  normal { 
    bumps 0.3
    scale 0.5
  }
}

#declare T_Shell_Plate = polygon {
  6
  <0,2>, <2,1>, <2,-1>, <0,-2>, <-2,-1>, <-2,1>
}

#declare T_Shell_Middle = union {
  object { T_Shell_Plate }
  object { T_Shell_Plate translate  2*x rotate  16*y translate  2*x }
  object { T_Shell_Plate translate  2*x rotate  16*y translate  4*x rotate  16*y translate  2*x }
  object { T_Shell_Plate translate -2*x rotate -16*y translate -2*x }
  object { T_Shell_Plate translate -2*x rotate -16*y translate -4*x rotate -16*y translate -2*x }
}  

#declare T_Shell_SecMiddle = union {  
  object { T_Shell_Plate translate  2*x rotate  8*y }
  object { T_Shell_Plate translate -2*x rotate -8*y }
  object { T_Shell_Plate translate  2*x rotate  8*y translate  2*x rotate  16*y translate  2*x }
  object { T_Shell_Plate translate -2*x rotate -8*y translate -2*x rotate -16*y translate -2*x }
}

#declare T_Shell_LowerTop = union {  
  object { T_Shell_Plate }
  object { T_Shell_Plate translate  2*x rotate  16*y translate  2*x }
  object { T_Shell_Plate translate -2*x rotate -16*y translate -2*x }
}

#declare T_Shell_Top = union {  
  object { T_Shell_Plate translate  2*x rotate  8*y }
  object { T_Shell_Plate translate -2*x rotate -8*y }
}

#declare T_Shell_NoRim = difference {
  union {
    object { T_Shell_Middle }
    object { T_Shell_SecMiddle translate  1*y rotate -16*x translate  2*y }
    object { T_Shell_SecMiddle translate -1*y rotate  16*x translate -2*y }
    object { T_Shell_LowerTop  translate  1*y rotate -16*x translate  3*y rotate -24*x translate  2*y }
    object { T_Shell_LowerTop  translate -1*y rotate  16*x translate -3*y rotate  24*x translate -2*y }
    object { T_Shell_Top       translate  1*y rotate -16*x translate  3*y rotate -24*x translate  2*y rotate -16*x translate  2*y}
    object { T_Shell_Top       translate -1*y rotate  16*x translate -3*y rotate  24*x translate -2*y rotate  16*x translate -2*y}
  }
  union {
    cylinder { 
      <0,0,5>, <0,0,-5>, 5
      scale <1.5,1.3,1>
      inverse
    } 
    plane { z, -2.5 }
  }
}   

#declare T_Shell01 = union {
  object { T_Shell_NoRim texture { ShellTex01 } }
  torus { 
    5,0.2 
    rotate x*90 
    scale <1.5,1.3,1> 
    translate -2.1*z 
    texture { ShellRimTex }
  } 
}

#declare T_Shell02 = union {
  object { T_Shell_NoRim texture { ShellTex02 } }
  torus { 
    5,0.2 
    rotate x*90 
    scale <1.5,1.3,1> 
    translate -2.1*z 
    texture { ShellRimTex }
  } 
}


#declare T_Body01 = union {
  object { T_Shell01 }
  difference {
    sphere { <0,0,-2.1>, 5 scale <1.5,1.3,0.8> clipped_by { plane { z,-2.3 } } }
    union {
      sphere { <0,0,-2.1>, 5 scale <1.5,1.3,0.8>*0.95 }
      cylinder { < -3.0,10,-3.5>, < -3.0,-10,-3.5>, 1.0 }
      cylinder { <  4.0,10,-3.5>, <  4.0,-10,-3.5>, 1.0 }
      cylinder { <-10.0, 0,-3.2>, <  0.0,  0,-3.2>, 1.5 }
    }
    texture { FrontTex }
  }
}

#declare T_Body02 = union {
  object { T_Shell02 }
  difference {
    sphere { <0,0,-2.1>, 5 scale <1.5,1.3,0.8> clipped_by { plane { z,-2.3 } } }
    union {
      sphere { <0,0,-2.1>, 5 scale <1.5,1.3,0.8>*0.95 }
      cylinder { < -3.0,10,-3.5>, < -3.0,-10,-3.5>, 1.0 }
      cylinder { <  4.0,10,-3.5>, <  4.0,-10,-3.5>, 1.0 }
      cylinder { <-10.0, 0,-3.2>, <  0.0,  0,-3.2>, 1.5 }
    }
    texture { FrontTex }
  }
}

#declare T_Head01 = blob {
  threshold 0.6
  cylinder { <0,0,-3.2>, <0,6.5,-3.2>, 2, 1 }
  sphere { <0,8.75,-4>, 3, 1 scale <1.5,0.8,1.25> }
  sphere { <0,8.2,-4>, 3, 1 }
  texture { BodyTex }
}
  
#declare T_Head02 = blob {
  threshold 0.6
  cylinder { <0,0,-3.2>, <0,6.5,-3.2>, 2, 1 }
  sphere { <0,8.75,-4>, 3, 1 scale <1.5,0.8,1.25> rotate z*-15 }
  sphere { <0,8.2,-4>, 3, 1 rotate z*-15 }
  texture { BodyTex }
}
  
#declare T_Arms = blob {
  threshold 0.6
  cylinder { <-5,3,-3.2>, <5,3,-3.2>, 2.5 ,0.8 }
  // right arm
  cylinder { <-0.5,0,0>, <0.5,0,0>, 1.5 ,1 rotate  90*y rotate x*-50 translate <-5.75,2.5,-4.5> }
  sphere { <0,0,0>, 1.5, 1 translate <-5.75,2.5,-5> }
  cylinder { <-0.5,0,0>, <0.5,0,0>, 5 ,-0.2 rotate  90*y rotate x*-50 translate <-5.75,2.5,-8> }
  // left arm
  cylinder { <-0.5,0,0>, <0.5,0,0>, 1.5 ,1 rotate  90*y rotate x*-50 translate < 5.75,2.5,-4.5> }
  sphere { <0,0,0>, 1.5, 1 translate < 5.75,2.5,-5> }
  cylinder { <-0.5,0,0>, <0.5,0,0>, 5 ,-0.2 rotate  90*y rotate x*-50 translate < 5.75,2.5,-8> }
  texture { BodyTex }                
}

#declare T_Feet = blob {
  threshold 0.6
  cylinder { <-4.5,3,-3.2>, <4.5,3,-3.2>, 2.5 ,0.8 }
  // right arm
  cylinder { <-0.75,0,0>, <0.5,0,0>, 1.5 ,1 rotate  90*y rotate x*-50 translate <-4.75,2.5,-4.5> }
  sphere { <0,0,0>, 1.5, 1 translate <-5.25,2.5,-5> }
  cylinder { <-0.5,0,0>, <0.5,0,0>, 5 ,-0.2 rotate  90*y rotate x*-50 translate <-4.75,2.5,-8> }
  // left arm
  cylinder { <-0.75,0,0>, <0.5,0,0>, 1.5 ,1 rotate  90*y rotate x*-50 translate < 4.75,2.5,-4.5> }
  sphere { <0,0,0>, 1.5, 1 translate < 5.25,2.5,-5> }
  cylinder { <-0.5,0,0>, <0.5,0,0>, 5 ,-0.2 rotate  90*y rotate x*-50 translate < 4.75,2.5,-8> }
  texture { BodyTex }                
}

  
#declare Turtle01 = union {
  object { T_Body01 rotate -90*z }
  object { T_Head01 }
  object { T_Arms }
  object { T_Feet translate -7*y }
}

#declare Turtle02 = union {
  object { T_Body02 rotate -90*z }
  object { T_Head02 }
  object { T_Arms }
  object { T_Feet translate -7*y }
}

// **** End of file ****