#include "config.h"
#define __PWPLIB_C

#include <stdio.h>
#include <stdlib.h>

#include <signal.h>
#include <time.h>
#include <sys/time.h>

#include "pwplib.h"

#define DESTRUCTORS 8

/******************** random stuff *************************/

void pwplib_dummy(){}
#define pwp_dummy pwplib_dummy

void pwplib_dump_rast_plain()
{
   TEMPMALL(u8,tmp,pwplib.videobuf.width*pwplib.videobuf.height*2);
   u8
      *d=tmp,
      *parentbuf=pwplib.videobuf.d,
      *s=parentbuf;

   int i=pwplib.videobuf.width*pwplib.videobuf.height;
   
   for(;i;i--)
   {
      d[0]='%';
      d[1]=*s++;
      d+=2;
   }

   pwplib.videobuf.d=tmp;
   pwplib.dump_attr();
   pwplib.videobuf.d=parentbuf;

   TEMPFREE(tmp);
}

/********************* timer (unix) ************************/

#define TIMERHZ 72
int pwp_timer_nrt()
{
   static int lastctr=0,framectr=0;

   if(pwplib.setup[SETUP_BPS])
   {
      pwplib.timer_counter++; /* kludge */
      return (pwplib.timer_counter*TIMERHZ)/(pwplib.setup[SETUP_BPS]>>3);
   }
    else
   {
      if(pwplib.timer_counter!=lastctr)
      {
         framectr++;
         lastctr=pwplib.timer_counter;
      }
       else 
          pwplib.timer_counter++;
      return (framectr*TIMERHZ)/pwplib.setup[SETUP_FPS];
   }
}
int pwp_unix_tod()
{
        struct timeval tod;
        gettimeofday(&tod,NULL);
        return (tod.tv_sec*TIMERHZ)+(tod.tv_usec*TIMERHZ/1000000);
}
int pwplib_timer()
{
        static int base=-1;int v;
        v=pwplib.timerfunc();
        if(base==-1)base=v;
        return v-base;
}

/********************* destructors, signals etc **********/

void(*pwp_destr[DESTRUCTORS])();

void pwp_regdestr(void(*func)())
{
   static int curr=0;
   pwp_destr[curr++]=func;
   pwp_destr[curr]=NULL;
}

void pwplib_shutdown()
{
   int i=0;

   while(pwp_destr[i]!=NULL)
         pwp_destr[i++]();
}

void pwp_fatalsignal(int n)
{
   char buf[40];

   pwplib_shutdown();

   sprintf(buf,"* died to signal %d\n",n);
   pwpwrite(buf);
   
   exit(1);
}

/******************** initialization *********************/

int pwplib_initcore()
{
   /*** base stuff ***/

   pwplib.sound=
   pwplib.loopflush=
   pwplib.player=
   pwplib.dump_attr=
   pwplib.dump_rast=
   pwplib.prep_attr=
   pwplib.prep_rast=
     pwp_dummy;

   pwp_destr[0]=NULL;

   signal(SIGTERM,pwp_fatalsignal);
   signal(SIGINT,pwp_fatalsignal);
   signal(SIGQUIT,pwp_fatalsignal);
   signal(SIGKILL,pwp_fatalsignal);
   signal(SIGSEGV,pwp_fatalsignal);

   /*** video ***/

#   ifdef DRIVE_VIDEO

#   ifdef DRIVE_PVP
   if(pwplib.setup[SETUP_PVP])
     pvp_init();
   else
#   endif
   if(!pwplib.setup[SETUP_NOVIDEO])
   {
     tty_init();
   }
#   endif

   /*** audio ***/
#  ifdef DRIVE_AUDIO
   if(!pwplib.setup[SETUP_NOSOUND])
   {
#     ifdef DRIVE_OSS
       if(!oss_init())
#     endif
       pwpwrite("* couldn't init sound. going silent.\n");
   }
   else
     pwpwrite("* no sound, as requested\n");
#  endif

   /*** fallbacks - remove? ***/

   if(pwplib.dump_rast==pwplib_dummy && pwplib.dump_attr!=pwplib_dummy)
      pwplib.dump_rast=pwplib_dump_rast_plain;

   /*** timer ***/

   if(pwplib.setup[SETUP_BPS]|pwplib.setup[SETUP_FPS])
   {
      char tmp[100];
      sprintf(tmp,"non-realtime output (bps=%d fps=%d)\n",
        pwplib.setup[SETUP_BPS],pwplib.setup[SETUP_FPS]);
      pwpwrite(tmp);

      pwplib.timerfunc=pwp_timer_nrt;
      pwplib.timer_counter=0;
   }
    else
      pwplib.timerfunc=pwp_unix_tod;

   /*** hmmm ***/

   if(pwplib.setup[SETUP_HALVE])
      pwplib.videobuf.height<<=1;

     /* only allow if smaller than original? */

   if(pwplib.setup[SETUP_USERHEIGHT])
      pwplib.videobuf.height=pwplib.setup[SETUP_USERHEIGHT];
   if(pwplib.setup[SETUP_USERWIDTH])
      pwplib.videobuf.width=pwplib.setup[SETUP_USERWIDTH];

   /*** done ***/
   
#   ifdef DRIVE_VIDEO
   if(!pwplib.setup[SETUP_NOVIDEO])
   {char tmp[100];
   sprintf(tmp,"* pwplib now controls a %d x %d framebuffer\n",
      pwplib.videobuf.width,pwplib.videobuf.height);
   pwpwrite(tmp);
   }
#  endif

   return 1;
}
