#include <stdio.h>
#include <stdlib.h>

#include "pwpdemo.h"

typedef struct
{
   int width,height;
   u8*pict;
   u8*mask;
}sprite;

#include "sprites.h"

#define INLINE
  /* to pwplib.h -- #define INLINE inline */

INLINE void zoomsprite_loop
  (mask, pict, xzoom, d, xo0, xdim, ydim, spwidth, yzoom, yo0)
register u8* mask, *pict;
register int xzoom;
u8* d;
int xo0, xdim, ydim, spwidth, yzoom, yo0;
{
   register u8 *dd, *m, *p;
   register int xo, x;

   for(;ydim;ydim--)
   {
      int linebase = (yo0>>8) * spwidth;
      
      m  = mask + linebase;
      p  = pict + linebase;
      dd = d;
      xo = xo0;

      for(x=xdim;x;x--)
      {
         register int z=xo>>8;

         *dd++ = (*dd & m[z]) | p[z];

         xo += xzoom;
      }

      yo0 += yzoom;
      d   += pwplib_bufw;
   }
}

/* include 32bit-optimized loops (encode 32 bits at a time)

   optimize for 8086, z80, even 6502?
*/

/* 
    have pwpGL which contains optimized loops for several processors:

    zoomsprite, 3d/raycasting stuff etc
*/

void zoomsprite(int x0,int y0,sprite*sp,int xzoom,int yzoom)
{
   int xdim,ydim,
       xo0=0,yo0=0,x,y,ptr;

   if(xzoom<=32 && yzoom<=32)return;
   
   xdim=(sp->width<<8)/xzoom;
   ydim=(sp->height<<8)/yzoom;

   x0-=(xdim>>1);
   y0-=(ydim>>1);

   if(x0<0)
   {
      xdim+=x0;
      xo0=(0-x0)<<8;
      x0=0;
   }

   if(y0<0)
   {
      ydim+=y0;
      yo0=(0-y0)<<8;
      y0=0;
   }

   if(x0+xdim>=pwplib_bufw)
   {
      xdim=pwplib_bufw-x0;
   }

   if(y0+ydim>=pwplib_bufh)
   {
      ydim=pwplib_bufh-y0;
   }
   
   if(xdim<=0 || ydim<=0) return;

   zoomsprite_loop
   (
      sp->mask, sp->pict, xzoom,
      pwplib_buf+x0+y0*pwplib_bufw,
      xo0, xdim, ydim, sp->width, yzoom, yo0
   );
}
/*
  (mask, pict, xzoom, d, xo0, xdim, ydim, spwidth, yzoom, yo0)
*/

void zoomsprite_gen(int x0,int y0,sprite*sp,int zoom)
{
   zoomsprite(((x0+128)*pwplib_bufw)>>8,
              ((y0+128)*pwplib_bufh)>>8,
              sp,
              abs((zoom<<8)/pwplib_bufw),
              abs((zoom<<7)/pwplib_bufh)
             );
}

void metsae(int t,int mode)
{
   int i,x;

  const sprite*mo[]={&kuusi};
  const int mosiz[]={128};
  const int mostep[]={64};

  for(i=0;i<512;i+=mostep[mode])
  {
   zoomsprite_gen(
     ((i-t/3)&511)-256 ,0,mo[mode],mosiz[mode]);
  }
}

void drawkiller(int tminus)
{
   int ttt=tminus;

   if(tminus<-64)tminus=-64;else
   if(tminus>0)tminus=0;

   zoomsprite_gen(tminus,48,(ttt&16)?&pelustna0:&pelustna1,80);
}

void encounter(int tminus,int kode,int zoom,int speed)
{
   int ttt=tminus;
   sprite*pum[][2]=
   {
      &krist0,&krist1,
      &pelusieni,&pelusieni,
      &pelusieni1,&pelusieni1,
      &pelusieni2,&pelusieni2,
      &pelux,&pelux,
      &pelustna0,&pelustna1,
      &ruumis,&ruumis,
      &uusmed0,&uusmed1,
      &tesno0,&tesno1,
      &army0,&army0,
      &windows0,&windows1,
      &quake0,&quake0      
   };

   if(ttt<0)ttt=0;

   zoomsprite_gen(0+ttt,48,(tminus&16)?pum[kode][0]:pum[kode][1],zoom);
}

void pelubounce(int t,int bouncemode)
{
   const unsigned char bfunc[32]={
       32,32,32,36,38,40,42,44,50,60,61,62,62,63,63,63,
       63,63,63,62,61,60,50,40,32,33,34,35,34,33,32,32
   };
   const sprite*poo[3]={&peluface0,&peluface1,&peluface2};
   
   zoomsprite_gen(0,0,bouncemode?&sieni:poo[(t>>6)%3],40+((t-2560)&63));
}

void blaah(int t)
{
   int x0=0,
       y0=0,
       z0=300+SIN(t/71)/120; /* 32768 (sin(t/70.8)*300); */

   zoomsprite_gen(x0,y0,(t&16)?&krist0:&krist1,z0);
}


/*****************************/

/*
        for(y=0;y<hg;y++)
        {
	     register int dofz=(hg*64)/(y+3),ofz=t*32-dofz*20-((dofz>>4)*32*256);
             {int x=pwplib.videobuf.width;for(;x;x--)*d++=texture1[((ofz+=dofz)>>8)&1023];}
	     k-=(k>>3);
	}
}

*/
