#include <stdio.h>
#include <stdlib.h>

#include "pwpdemo.h"

typedef struct
{
   int width,height;
   u8*pict;
   u8*mask;
}sprite;

#include "sprites.h"

#include "font.h"

#define INLINE
  /* to pwplib.h -- #define INLINE inline */

INLINE void zoomsprite_loop
  (mask, pict, xzoom, d, xo0, xdim, ydim, spwidth, yzoom, yo0)
register u8* mask, *pict;
register int xzoom;
u8* d;
int xo0, xdim, ydim, spwidth, yzoom, yo0;
{
   register u8 *dd, *m, *p;
   register int xo, x;

   for(;ydim;ydim--)
   {
      int linebase = (yo0>>8) * spwidth;
      
      m  = mask + linebase;
      p  = pict + linebase;
      dd = d;
      xo = xo0;

      for(x=xdim;x;x--)
      {
         register int z=xo>>8;

         *dd++ = (*dd & m[z]) | p[z];

         xo += xzoom;
      }

      yo0 += yzoom;
      d   += pwplib_bufw;
   }
}

void zoomsprite(int x0,int y0,sprite*sp,int xzoom,int yzoom)
{
   int xdim,ydim,
       xo0=0,yo0=0,x,y,ptr;

   if(xzoom<=32 && yzoom<=32)return;
   
   xdim=(sp->width<<8)/xzoom;
   ydim=(sp->height<<8)/yzoom;

   x0-=(xdim>>1);
   y0-=(ydim>>1);

   if(x0<0)
   {
      xdim+=x0;
      xo0=(0-x0)<<8;
      x0=0;
   }

   if(y0<0)
   {
      ydim+=y0;
      yo0=(0-y0)<<8;
      y0=0;
   }

   if(x0+xdim>=pwplib_bufw)
   {
      xdim=pwplib_bufw-x0;
   }

   if(y0+ydim>=pwplib_bufh)
   {
      ydim=pwplib_bufh-y0;
   }
   
   if(xdim<=0 || ydim<=0) return;

   zoomsprite_loop
   (
      sp->mask, sp->pict, xzoom,
      pwplib_buf+x0+y0*pwplib_bufw,
      xo0, xdim, ydim, sp->width, yzoom, yo0
   );
}
/*
  (mask, pict, xzoom, d, xo0, xdim, ydim, spwidth, yzoom, yo0)
*/

void zoomsprite_gen(int x0,int y0,sprite*sp,int zoom)
{
   zoomsprite(((x0+128)*pwplib_bufw)>>8,
              ((y0+128)*pwplib_bufh)>>8,
              sp,
              abs((zoom<<8)/pwplib_bufw),
              abs((zoom<<7)/pwplib_bufh)
             );
}

/*
void metsae(int t,int mode)
{
   int i,x;

  const sprite*mo[]={&kuusi};
  const int mosiz[]={128};
  const int mostep[]={64};

  for(i=0;i<512;i+=mostep[mode])
  {
   zoomsprite_gen(
     ((i-t/3)&511)-256 ,0,mo[mode],mosiz[mode]);
  }
}

void drawkiller(int tminus)
{
   int ttt=tminus;

   if(tminus<-64)tminus=-64;else
   if(tminus>0)tminus=0;

   zoomsprite_gen(tminus,48,(ttt&16)?&pelustna0:&pelustna1,80);
}

void encounter(int tminus,int kode,int zoom,int speed)
{
   int ttt=tminus;
   sprite*pum[][2]=
   {
      &krist0,&krist1,
      &pelusieni,&pelusieni,
      &pelusieni1,&pelusieni1,
      &pelusieni2,&pelusieni2,
      &pelux,&pelux,
      &pelustna0,&pelustna1,
      &ruumis,&ruumis,
      &uusmed0,&uusmed1,
      &tesno0,&tesno1,
      &army0,&army0,
      &windows0,&windows1,
      &quake0,&quake0      
   };

   if(ttt<0)ttt=0;

   zoomsprite_gen(0+ttt,48,(tminus&16)?pum[kode][0]:pum[kode][1],zoom);
}
*/

void sflogo(int t)
{
   int a=rand();

   zoomsprite_gen(0,0, &pwp_sf,
      t<256?(256+48-t):48);
}

void sf_esittaa()
{
   zoomsprite_gen(-32,-32,&esittaa,96);
   zoomsprite_gen(32,32,&forevisar,96);
}
void isantapari(int t)
{
   zoomsprite_gen((SIN(t/2)*16)>>16,64,&isanta,64);
}

void tankit(int t)
{
   int i=7;int col1=0x88,col2=0x02;
   
   if(!((t^(t>>2))&511)){col1=0xff;col2=0x7f;}

   memset(pwplib_buf,col1,pwplib_bufw*pwplib_bufh/2);
   memset(pwplib_buf+pwplib_bufw*pwplib_bufh/2,col2,pwplib_bufw*pwplib_bufh/2);

   for(;i;i--)
   {
      zoomsprite_gen(((t+i*84)&511)-256,8+i*8,&tankki,128-i*4);
   }
}

void tankit2(int t)
{
   int i=7;int col1=0x11,col2=0x08;

   memset(pwplib_buf,col1,pwplib_bufw*pwplib_bufh/2);
   memset(pwplib_buf+pwplib_bufw*pwplib_bufh/2,col2,pwplib_bufw*pwplib_bufh/2);

   for(;i;i--)
   {
      zoomsprite_gen(((t+i*84)&511)-256,8+i*8,&tumpsa,128-i*4);
   }
}

/******************/

char scale[3][8]={
   0x00,0x08,0x80,0x88,0x87,0x77,0xf7,0xff,
   0x00,0x08,0x07,0x80,0x88,0x87,0x77,0x7f,
   0x00,0x06,0x60,0x66,0x6e,0xe6,0xee,0xef
};

char bwpal[8][256];
void bwpals()
{
   int i,j;
   for(i=0;i<8;i++)
   {
      int gamma=rand()&3;
      int brite=256+(rand()&15)-(rand()&15);
      int scl=rand()%3;

      for(j=0;j<256;j++)
      {
         int it=((j&1)?1:0)+((j&2)?6:0)+((j&4)?3:0)+((j&8)?5:0)+
                 ((j&16)?3:0)+((j&32)?12:0)+((j&64)?8:0)+((j&128)?8:0);

         it+=gamma;
         it=(it*brite)>>8;
         if(it>63)it=63;

         it/=8;

	 bwpal[i][j]=scale[scl][it];
      }
   }
}

void naarmuta()
{
   int i=pwplib_bufh*pwplib_bufw;
   static int ph=0,rr=0,nrmx=0;
   
   char*d=pwplib_buf;
   char*lookup=&bwpal[rr&7][0];
   ph++;if(!(ph&3))rr=rand();

   for(i=100;i;i--)
   {
      int z=rand()%(pwplib_bufw*pwplib_bufh);
      pwplib_buf[z]^=0x87;
   }
   
   for(i=0;i<pwplib_bufh;i++){ 
     pwplib_buf[pwplib_bufw*i+nrmx]&=~0x78; if(!(rand()&7))nrmx+=(rand()&3)-1;
     if(nrmx<0 || nrmx>=pwplib_bufw) nrmx=rand()%pwplib_bufw;
   }

   i=pwplib_bufh*pwplib_bufw;
   for(;i;i--){*d=lookup[*d];d++;}
}

sprite textbuf={0,0,NULL,NULL};

void killtext()
{
   if(textbuf.width){textbuf.width=0;free(textbuf.pict);free(textbuf.mask);}
}

void drawtext(char*txt,int col)
{
   int wdt=0,x=0,y=0,idx,hgt=7;
   unsigned char*f,*fnt=font;

   killtext();
   {char*t=txt;
   for(;;)
   {int thiswdt=0;
    while(*t && *t!='\n'){thiswdt+=font_lengths[(*t>='A'&&*t<=']')?(*t-'@'):4];t++;}
    if(thiswdt>wdt)wdt=thiswdt;
    if(!*t)break; else {t++;hgt+=11;}
   }}

   textbuf.width=wdt+1;
   textbuf.height=hgt+1;
   { int sz=textbuf.height*textbuf.width*sizeof(u8);
      textbuf.pict=malloc(sz);
      textbuf.mask=malloc(sz);
      memset(textbuf.pict,0,sz);
      memset(textbuf.mask,0xff,sz);}

   while(*txt)
   {
      int z=*txt,a;

      txt++;

      if(z=='\n'){x=0;y+=textbuf.width*11;continue;}

      z-='@';
      if(z<0 || z>29){x+=4;continue;}

      f=fnt;
      while(z)
      {
         if(*f==0)z--;
         f++;
      }

      while((a=*f))
      {
         idx=x+y;

         for(;a;a>>=1)
         {
            if(a&1){textbuf.pict[idx]=col;
                    textbuf.mask[idx]=0;
                    if(textbuf.mask[idx+1+textbuf.width])
                    {
                       textbuf.pict[idx+textbuf.width+1]=
                       textbuf.mask[idx+textbuf.width+1]=0;
                    }
                    }

            idx+=textbuf.width;
         }
         x++;
         f++;
      }
      x++; /* x+=2; */
   }
}

void addtext(int t,int m)
{
   if(m==1)m=96+abs((t-32)&63-32);else m=96;
   if(textbuf.width)
   {
      zoomsprite_gen(0,0,&textbuf,m);
   }
}

void rotozoompaski(u8*s,int u0,int v0,int du,int dv)
{
   u8*d=pwplib_buf;
   int i,j,u,v;
   int idu=du/pwplib_bufw,idv=dv/pwplib_bufw,
       odu=dv/pwplib_bufh,odv=-du/pwplib_bufh;

   for(i=pwplib_bufh;i;i--)
   {
      int iu=u,iv=v;
      for(j=pwplib_bufw;j;j--) 
      {
         *d++=s[((iu>>4)&(1023&~31))|((iv>>9)&31)];
         iu+=idu;iv+=idv;
      }
      u+=idv;v+=-idu;
   }
}

void rotozoom_do(int t,int m)
{
   u8*poo[]={piimae.pict,pelu.pict,taehti.pict};
   int u=SIN(t),v=COS(t);
   rotozoompaski(poo[m],(-u+v)*32,(-v-u)*32,u,v);
}
