#!/usr/bin/perl

sub comment
{
   print "\n\n/*** $_[0] ***/\n\n";
}

sub newline
{
   print "\n";
   $pos=0;
}

sub wr
{
   $_=$_[0];

   $pos+=length($_);
   print $_,",";
   if($pos>72) { newline(); }
}

$pat=0;
sub newpat
{
   comment("pattern $pat");
   return $pat++;
}

sub music
{
   $nct=0;
   $base=8;

   if($_[1]){ $base+=$_[1];}

   $_=$_[0];

   $_=join('!',split('',$_));
   s/\!\#/\#/g;

   foreach(split('!',$_))
   { 
      $note="";
   
      if ($_ eq '<')  { $base -= 12;  }
      if ($_ eq '>')  { $base += 12;  }

      if ($_ eq '|')  { $note = 253; }
      if ($_ eq '.')  { $note = 254; }
      if ($_ eq ',')  { $note = 255; }

      if ($_ eq 'c')  { $note = 0; }
      if ($_ eq 'c#') { $note = 1; }
      if ($_ eq 'd')  { $note = 2; }
      if ($_ eq 'd#') { $note = 3; }
      if ($_ eq 'e')  { $note = 4; }
      if ($_ eq 'f')  { $note = 5; }
      if ($_ eq 'f#') { $note = 6; }
      if ($_ eq 'g')  { $note = 7; }
      if ($_ eq 'g#') { $note = 8; }
      if ($_ eq 'a')  { $note = 9; }
      if ($_ eq 'a#') { $note = 10; }
      if ($_ eq 'b')  { $note = 11; }

      if ($note ne "")
      {      
         if ($note<128) { wr($base+$note); }
                   else { wr($note); }
         $nct++;
      }
   }
   
   print "/* $nct */";
   
   if($nct<64) { for(;$nct<64;$nct++) { wr(255); }}

   newline();
   newline();
}

#####################################################################################################

print "u8 pwpmusic[][3][64]={\n";

$taisto0=newpat();
music("c,,.c,d,d#,,.c,,.d,c,<a#,g#,g,,.>d,,.g,f,d#,d,g,f,d#,d,d#.,,c,,,,..",48);
music("c..,c..,c..,c..,<a#..,a#..,a#..,a#..,>d#..,d#..,d#..,d#..,c..,c..,c..,c..,",24);
music("");

$taisto1=newpat();
music("d,d#,f,g,d,d#,f,g,d#,d,d#,d,c,,.d#,,,d,d#,f,g,d,d#,f,g,d#...c,,,,..",48);
music("d..,d..,d..,d..,d..,d..,c..,c..,d..,d..,d..,d..,c..,c..,c..,c..,",24);
music("");

$taisto1b=newpat();
music("d,d#,f,g,d,d#,f,g,d#,d,d#,d,c,,.d#,,,d,d#,f,g,d,d#,f,g,c,,,,,,.|.|",48);
music("d..,d..,d..,d..,d..,d..,c..,c..,d..,d..,d..,d..,c..,...,...,...,",24);
music("");

$tiluli0=newpat();
music("c.c.d#,c,g,c,d#,c.,,c,d#,c,g,c,d#,c,d#.d#.g,d#,a#,d#,f,<a#.,,a#,>d,<a#,>f,<a#,>d,<a#,",48);
music("c.c.d#.d#.g.g.d#.d#.c.c.d#.d#.g.g.d#.d#.d#.d#.f.f.a#.a#.f.f.d.d.f.f.a#.a#.f.f.",24);
#music("c,,.d#,,.c,,.d#,,.c,,.d#,,.c,,.d#,,.d#,,.f,,.d#,,.f,,.d,,.f,,.a#fa#fa#fa#f",36);
music(""); # c,,,c,,,d#,,,g,,,c,,,c,,,d#,,,g,,,d#,,,d#,,,f,,,a#,,,d,,,d,,,f,,,a#,,,",24);
#music("c.d#cc.d#cc.d#cc.d#cd#.gd#<a#.>d<a#a#.>d<a#a#.
	
$tiluli1=newpat();
music("c.c.d#,c,g,c,d#,c.,,c,d#,c,g,c,d#,c,d#.d#.g,d#,a#,d#,f,<a#.,,a#,>d,<a#,>f,<a#,>d,<a#,",48+5);
music("c.c.d#.d#.g.g.d#.d#.c.c.d#.d#.g.g.d#.d#.d#.d#.f.f.a#.a#.f.f.d.d.f.f.a#.a#.f.f.",24+5);
#music("c,,.d#,,.c,,.d#,,.c,,.d#,,.c,,.d#,,.d#,,.f,,.d#,,.f,,.d,,.f,,.a#fa#fa#fa#f",36+5);
music("");

$tiluli2=newpat();
music("c.c.d#,c,g,c,d#,c.,,c,d#,c,g,c,d#,c,d#.d#.g,d#,a#,d#,f,<a#.,,a#,>d,<a#,>f,<a#,>d,<a#,",48+7);
music("c.c.d#.d#.g.g.d#.d#.c.c.d#.d#.g.g.d#.d#.d#.d#.f.f.a#.a#.f.f.d.d.f.f.a#.a#.f.f.",24+7);
#music("c,,.d#,,.c,,.d#,,.c,,.d#,,.c,,.d#,,.d#,,.f,,.d#,,.f,,.d,,.f,,.a#fa#fa#fa#f",36+7);
music("");

$tyhja=newpat();
music("");
music("");
music("");

print "};\n\n";

#####################################################

print "u8 pwpmusic_order[]={\n";
print "$taisto0, $taisto0, $taisto1, $taisto1b,\n";
print "$tiluli0, $tiluli0, $tiluli1, $tiluli1,\n";
print "$tiluli0, $tiluli0, $tiluli1, $tiluli1,\n";
print "$tiluli0, $tiluli0, $tiluli1, $tiluli1,\n";
print "$tiluli0, $tiluli0, $tiluli1, $tiluli1,\n";
print "$tiluli0, $tiluli0, $tiluli1, $tiluli1,\n";
print "$tiluli0, $tiluli0, $tiluli1, $tiluli1, $taisto1b, $tyhja,\n";
print "$taisto0, $taisto0, $taisto1, $taisto1b, $tyhja,$tyhja,$tyhja\n";
print "};\n\n";
