#include <dos.h>

#define PWPLIBINT

#include "pwplib.h"

/******************
 *
 *   timer & init
 */

void interrupt int_8();
void interrupt (*old_int8)();

void clockspeed(char spiidi)
{
   disable();
   outportb(0x43,0x36);
   outportb(0x40,0x00);
   outportb(0x40,spiidi);
   enable();
}

void pwplib_startup()
{
    timectr=0;

    initsound();

    initvideo();

    disable();
    old_int8=getvect(0x08);
    setvect(0x08,int_8);
    enable();
    clockspeed(64);
}

void pwplib_shutdown()
{
    disable();
    setvect(0x08,old_int8);
    enable();
    clockspeed(0);

    initsound();

    textcolor(15);
    clrscr();
}

void interrupt int_8()
{
   timectr++;
   if (!(timectr&3)) (*old_int8)(); else outport(0x20,0x20);

   if(auditype)play8tick();
   /* ... should also call player */
}

/******************
 *
 *   sound-related
 */

unsigned char chnote[3];

unsigned int subtick;

const int notefreqs[12] =
{
    0x157,0x16b,0x181,0x198,0x1b0,0x1ca,
    0x1e5,0x202,0x220,0x241,0x263,0x287
};

int pwplib_sound(int c,int n,int v,int r)
{
   subtick=0;
   chnote[c]=n;
}

int play8tick()
{
   if(auditype==1)
   {
      signed int toplay=-1;

      if(subtick==0)toplay=chnote[0];
      if(subtick==2)toplay=chnote[1]?chnote[1]:chnote[2];

      if(!toplay)nosound();
            else sound(notefreqs[toplay%12]<<(toplay/12));
   }
    else
   if(auditype==2)
   {
      int c;
   
      if(!subtick)
        for(c=0;c<3;c++)
          if(!chnote[c])
          {
             adlib(0x40+c,2);
             adlib(0x43+c,1);
          }
           else
          {
             int n=chnote[c];
             int bt=notefreqs[n%12]|(32*256)|((n/12)<<6);
          
             adlib(0xb0+c,bt>>8);
             adlib(0xa0+c,bt&255);

             adlib(0x40+c,63);
             adlib(0x43+c,63);
          }
   }

   subtick++;
}

/*** adlib inits ***/

char instru[2][11]=
{
    0xa1,0xa1,0xff,0xff,0x0f,0x0f,0x03,0x03,0x01,0x00,0x00,  /* bass */
    0xa2,0xa2,0xff,0xff,0x0f,0x0f,0x03,0x03,0x01,0x00,0x00,  /* organ */
};

void adl_ldinstr(int kanava,int i)
{
    char*ins=instru[i];
    char osotte[11] = {
    0x20,0x23,0x60,0x63,0x80,0x83,0xe0,0xe3,0xc0,0x40,0x43 };
      char *tmp=ins; char l;
      for(l=0;l<11;l++) adlib(kanava+osotte[l],*tmp++);
}

int initsound()
{
   if(auditype==1)nosound(); else
   if(auditype==2)
   {
      int l;

      if(auditype==1) nosound();

      for(l=0;l<244;l++) adlib(l,0);
      adlib(0x01,0x20);
      adl_ldinstr(0,1);
      adl_ldinstr(1,1);
      adl_ldinstr(2,1);
   }
}

void setvideomode()
{
   setvideo(0x0003);
   setvideo(0x0013);
   setvideo(0x1112);
   /* 80x25: setvideo(0x0003);setvideo(0x1003)*/
   
   /* fill with something? */
}

/********************
 *
 *  video-related
 */

void pwplib_loopflush()
{
   dump80501616(pwplib_buf);
   /* if setup_mono==2: dumpmono(pwplib_buf); */
}

int initvideo()
{
   setvideo(0x0003);
   setvideo(0x0013);
   setvideo(0x1112);
}
