#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <termios.h>

#define STDIN 0
#define STDOUT 1

struct termios term0;

char pwplib_getch()
{
   fd_set fdset;
   struct timeval timeout;

   timeout.tv_sec=1;
   timeout.tv_usec=0;

   if(FD_ISSET(0,&fdset))
   {
      char c;
      read(0,&c,sizeof(char));
      return c;
   }
   return 0;
}

/* only if interactivity required */
tty_termios_init()
{
   struct termios t;
   tcgetattr(STDIN,&t);
   memcpy(&term0,&t,sizeof(struct termios));
   t.c_lflag=t.c_oflag=0;
   t.c_cc[VMIN]=1;
   t.c_cc[VTIME]=0;
   tcsetattr(STDIN,TCSADRAIN,&t);
}

tty_termios_end()
{
   tcsetattr(STDIN,TCSADRAIN,&term0);
}

main()
{
   fd_set fdset;
   struct timeval timeout;

   tty_termios_init();

   memset((void*)&fdset,0,sizeof(fd_set));
   FD_SET(0,&fdset);
   timeout.tv_sec=1;
   timeout.tv_usec=0;

   write(STDOUT,"\33[c",3*sizeof(char));

   select(0,&fdset,NULL,NULL,&timeout);

   if(FD_ISSET(STDIN,&fdset))
   {
      char buf[40],*b;
      int lgt,num;


      lgt=read(STDIN,buf,40*sizeof(char))/sizeof(char);

      if(lgt<3) return 0;
      if( (buf[0]!=27) ||
          (buf[1]!='[') ||
          (buf[2]!='?')) return 0;

      b=buf+3;lgt-=3;num=0;

      printf("response:\n");

      while(lgt)
      {
         char c=*b++;
         if(c>='0' && c<='9')
            num=(num*10)+c-'0';
         else
         {
            printf("%d\n",num);
            num=0;
         }
         lgt--;
      }
   }
    else printf("no response to query\n");

   tty_termios_end();
   return 1;
}
