/* present.c - stock penguin animation
   Copyright (C) 2000 Tijs van Bakel and Jorik Blaas.
   Tijs van Bakel <smoke@casema.net>
   Jorik Blaas <jrk@panic.et.tudelft.nl>
 
 This file is part of a silly intro
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with This program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "present.h"
#include "crap_video.h"
#include "crap_mod.h"
#include "crap_font.h"
#include "crap_png.h"
#include "crap_lib.h"

#define MAJOR_AVOOZL  1
#define MAJOR_SMOKE   2
#define MAJOR_FLOPPI  3

Image present_image;
Palette present_palette;

Image subimage_codegfxmusic;
Image subimage_avoozl;
Image subimage_smoke;
Image subimage_floppi;

int max_height, max_width; /* maximal image size */

void plasmaprecalc( int width, int height );

#define BLOCKS_X 8
#define BLOCKS_Y 8

Present_data* create_fx_present ( Image* dest )
{
  Present_data* data;
  int i;
  
  data = (Present_data*) malloc ( sizeof(Present_data) );
  data->first_step = 1;

  crap_png_load ( &present_image, &present_palette, "logo.png" );

  /* generate palette */
  for ( i = 0; i < 128; i++ )
    {
      present_palette.color[i].r =
	fmax ( sin ( i / 64.0 * 1.0 * M_PI ) * 31.0, 0.0 ) + 15.0*i/128.0;
      present_palette.color[i].g =
	fmax ( sin ( i / 32.0 * 1.0 * M_PI ) * 31.0, 0.0 ) + 12.0*i/128.0;
      present_palette.color[i].b =
	fmax ( sin ( i / 16.0 * 1.0 * M_PI ) * 31.0, 0.0 ) + 3.0*i/128.0;
    }
  
  crap_image_subimage ( &present_image, &subimage_codegfxmusic, 0, 80, 106, 24 );
  crap_image_subimage ( &present_image, &subimage_avoozl, 80, 0, 80, 60 );
  crap_image_subimage ( &present_image, &subimage_smoke, 160, 0, 80, 60 );
  crap_image_subimage ( &present_image, &subimage_floppi, 240, 0, 80, 60 );

  max_width = 80;
  max_height = 60;
  
  plasmaprecalc( dest->width / BLOCKS_X, dest->height / BLOCKS_Y );

  return data;
}


uint8 * plasm1;
uint8 * plasm2;

void plasmaprecalc( int width, int height )
{
  int x,y;

  plasm1 = malloc( width*2 * height * 2 );
  plasm2 = malloc( width*2 * height * 2 );
  
  for (y=0;y<height*2;y++)
    for (x=0;x<width*2;x++)
      {
	int c;
	c = 31.0+30.0 * sin( x*1.0/(float)width*M_PI*1.0 )
	  * sin( y*1.0/(float)height*M_PI*1.0 );
	plasm1[x+y*width*2] = c;
	
	c = 31.0+30.0 * sin( x*1.0/(float)width*M_PI*2.0 )
	  * cos( (y+x)*0.05 );
	plasm2[x+y*width*2] = x;
      }
  
}

void plasma ( Image* dest, int x0, int y0, int width, int height, float counter, int shift )
{
  int x,y;
  uint8* destptr = dest->buffer + (x0+1) + (y0+1) * dest->stride;
  uint8* plasmptr1;
  uint8* plasmptr2;
  int skip = dest->stride - width + 2;

  int ofs1x = width * ( 0.5 + 0.45 * sin(counter/30.0 + x0));
  int ofs1y = height * ( 0.5 + 0.4 * sin(counter/23.0 + x0*2.3));
  int ofs2x = width * ( 0.5 + 0.45 * sin(counter/31.0 + y0*0.3));
  int ofs2y = height * ( 0.5 + 0.2 * sin(counter/12.0 + y0*32.0));

  plasmptr1 = plasm1 + ofs1x+ofs1y*width*2;
  plasmptr2 = plasm2 + ofs2x+ofs2y*width*2;
 
  for ( y = 1; y < height-1; y++ )
    {
      for ( x = 1; x < width-1; x++ )
	{
  	  *destptr++ = (( *plasmptr1++ + *plasmptr2++  ) & 127 ) >> shift; 
	}
      plasmptr1 += width+2;
      plasmptr2 += width+2;
      destptr += skip;
    }
  
}

void draw_block ( Image* dest, int x, int y, int state, float counter, int shift, int pan_x, int pan_y )
{
  Image tmp_image;
  int x0, y0;
  int width, height;

  x0 = x * (dest->width/BLOCKS_X);
  y0 = y * (dest->height/BLOCKS_Y);
  width = dest->width/BLOCKS_X;
  height = dest->height/BLOCKS_Y;

  switch ( state )
    {
    case 1:
      plasma ( dest, x0, y0, width, height, counter, shift );
      break;
    case 2:
      crap_image_subimage ( &present_image, &tmp_image, x0, y0, width, height );
      crap_image_blit ( dest, x0+pan_x, y0+pan_y, &tmp_image );
      break;
    }
}

int wipe_table1 [ BLOCKS_X ] [ BLOCKS_Y ] =
{
  { 0, 1, 2, 3, 4, 5, 6, 7 },
  { 15, 14, 13, 12, 11, 10, 9, 8 },
  { 16, 17, 18, 19, 20, 21, 22, 23 },
  { 31, 30, 29, 28, 27, 26, 25, 24 },


  { 24, 25, 26, 27, 28, 29, 30, 31 },
  { 23, 22, 21, 20, 19, 18, 17, 16 },
  { 8, 9, 10, 11, 12, 13, 14, 15 },
  { 7, 6, 5, 4, 3, 2, 1, 0 }
};

int wipe_table2 [ BLOCKS_X ] [ BLOCKS_Y ] =
{
  { 0, 1, 2, 3, 4, 5, 6, 7 },
  { 0, 1, 2, 3, 4, 5, 6, 7 },
  { 16, 17, 18, 19, 20, 21, 22, 23 },
  { 16, 17, 18, 19, 20, 21, 22, 23 },

  { 23, 22, 21, 20, 19, 18, 17, 16 },
  { 23, 22, 21, 20, 19, 18, 17, 16 },
  { 7, 6, 5, 4, 3, 2, 1, 0 },
  { 7, 6, 5, 4, 3, 2, 1, 0 }
};

void fx_present ( Image* dest, Present_data* data )
{
  static int wipe_pos1 = 0;
  static int wipe_pos2 = 0;
  static int blocks[BLOCKS_X][BLOCKS_Y];
  static int shader[BLOCKS_X][BLOCKS_Y];
  static int shader2[BLOCKS_X][BLOCKS_Y];
  static int pan_y = 0;
  static int pan_x = 0;
  int note;
  static float f = 1.0;
  int x,y;
  static float counter = 0.0;
  int head_moved;
  static int prev_note = 64;
  Image temp_image;
  static float sin_counter = 1.0;

  if ( data->first_step == 1 )
    {
      memset ( blocks, 0, BLOCKS_X * BLOCKS_Y * sizeof(int) );
      memset ( shader, 0, BLOCKS_X * BLOCKS_Y * sizeof(int) );
      memset ( shader2, 0, BLOCKS_X * BLOCKS_Y * sizeof(int) );
      crap_setpalette ( &present_palette, 0, 128 );
      crap_setpalette ( &present_palette, 192, 256-192 );
      crap_image_fill(dest, 0);
      data->first_step = 0;
    }

  /* swing to the beat */
  note = crap_mod_get_patpos();
  if ( ( (note/4) & 3 ) == 0 )
    f = 1.0;
  else
    f *= 0.99;

  counter += 1.0;
  x = 0;
  y = 0;

  if ( note < 32 )
    {
      // buildup
      head_moved = (note!=prev_note);
      
      for (y = 0; y<BLOCKS_Y;y++)
	{
	  for ( x = 0; x<BLOCKS_X;x++)
	    {
	      if ( head_moved && ( wipe_table1[y][x] == wipe_pos1 ) )
		{
		  shader[x][y] = 4;
		  blocks[x][y] = 1;
		}
	      
	      if ( head_moved && ( shader[x][y] > 0 ))
		shader[x][y]--;
	      
	      draw_block ( dest, x, y, blocks[x][y], counter, 4-shader[x][y], pan_x, pan_y );
	    }
	}
      if ( note != prev_note )
	{
	  wipe_pos1 ++;
	  prev_note = note;
	}
    }
  else if ( note < 64 )
    {
      // breakdown
      head_moved = (note!=prev_note);
      
      for (y = 0; y<BLOCKS_Y;y++)
	{
	  for ( x = 0; x<BLOCKS_X;x++)
	    {
	      if ( head_moved && ( wipe_table2[y][x] == wipe_pos2 ) )
		{
		  shader2[x][y] = 1;
		  blocks[x][y] = 1;
		}
	      
	      if ( head_moved && ( shader[x][y] > 0 ))
		shader[x][y]--;
	      if ( head_moved && ( shader2[x][y] > 0 )  && (shader2[x][y]<4))
		shader2[x][y]++;

	      if (shader2[x][y]==4)
		blocks[x][y]=2;
	      
	      draw_block ( dest, x, y, blocks[x][y], counter, 4-shader[x][y]+shader2[x][y], 0, 0 );
	    }
	}
      if ( note != prev_note )
	{
	  wipe_pos2 ++;
	  prev_note = note;
	}
    }
  else if ( note < 64 + 64 - 16 )
    {
      sin_counter *= 1.03;
      for ( y = 30; y < 170; y++ )
	{
	  crap_image_subimage ( &present_image, &temp_image, 0, y, 320, 1 );
	  crap_image_blit ( dest,
			    sin(sin_counter/50.0+sin(sin_counter/500.0)*y)*sin(sin_counter/1000.0)*100.0,
			    y, &temp_image );
	}
    }
  else
    {
#define LOGO_Y (200-33)
      pan_y += -(pan_y-(LOGO_Y))*0.1 + 1;
      
      if ( pan_y > LOGO_Y )
	pan_y = LOGO_Y;
      
      /*  	  pan_x-=8; */
      
      /*  	  if ( pan_x < -320 ) */
      /*  	    pan_x = -320; */

      crap_image_rect_fill ( dest, 0, 0, 0, dest->width, pan_y );
      crap_image_blit ( dest, 0, pan_y, &present_image );
      
      sin_counter *= 1.03;
      for ( y = 30; y < 170; y++ )
	{
	  crap_image_subimage ( &present_image, &temp_image, 0, y, 320, 1 );
	  crap_image_blit ( dest,
			    sin(sin_counter/50.0+sin(sin_counter/500.0)*y)*sin(sin_counter/1000.0)*100.0,
			    y+pan_y, &temp_image );
	}
    }
}


