/* intro.c - rectum cauda intro for ltp4
   Copyright (C) 2000 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of crapstation, a collection of demobuilder tools.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "config.h"

#ifdef HAVE_SCHED_H
#include <sched.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>

#define USE_RASTER_TIMING
/* start with an argument to see raster bars */
#ifdef USE_RASTER_TIMING
#include <asm/io.h>
#include <sys/perm.h>
#endif

#include "crap_types.h"
#include "crap_lib.h"
#include "crap_video.h"
#include "crap_mod.h"
#include "crap_font.h"
#include "crap_file.h"
#include "crap_png.h"

#include "present.h"
#include "beer.h"
#include "rotozoom.h"

int realtime_process ()
{
#ifdef HAVE_SCHED_H
    struct sched_param sp;

    printf("trying to set minimal SCHED_RR scheduling priority\n");
    sp.sched_priority = sched_get_priority_min ( SCHED_RR );
    if ( sched_setscheduler ( 0, SCHED_RR, &sp ) )
    {
        fprintf ( stderr, "could not enable realtime scheduling, continuing.\n" );
        return -1;
    };
#endif
    return 0;
}

int renice_process ()
{
    if ( nice ( -20 ) )
    {
        fprintf ( stderr, "could not renice process by -20, continuing.\n" );
        return -1;
    };
    return 0;
}

int mod_fake_pattern_lengths[] = { 128, 128, 128, 128 };

int
main ( int argc, char* argv[] )
{
  int note;
  int will_end_soon = 0;
  uint8* palvec = NULL;
  int first_time_around = 1;
  
  Rotozoom_data* rotozoom_data;
  Present_data* present_data;

  int end_intro = 0;
  
  Image logo_image;
  Image image;
  Palette palette;
  
  Image *root_image;
  Image effect_image;

#ifdef USE_RASTER_TIMING
  int _timing = ( argc > 1 );
  
  if ( _timing )
    iopl(3);
#endif

  printf("\n");
  printf("slager bert "VERSION"\n");
  printf("Copyright (C) 2000, Tijs van Bakel and Jorik Blaas\n");
  printf("\n");
  printf("This program is free software; you may redistribute it under the terms of\n");
  printf("the GNU General Public License. (See the file COPYING for more details).\n");
  printf("This program has absolutely no warranty.\n");
  printf("\n");

  realtime_process ();

  crap_video_init ( 320, 200 );

  crap_font_init ();

  crap_mod_init ( crap_file_find ("chip.xm") , 8 );
  crap_mod_fake_pattern_lengths ( 4, mod_fake_pattern_lengths );
  
  root_image =  crap_video_root_image();
  crap_image_fill ( root_image, 0 );
  crap_image_subimage ( root_image, &effect_image, 0, 0, 320, 200-31 );
  
  crap_png_load ( &image, &palette, "logo.png" );
  crap_image_subimage ( &image, &logo_image, 0, 0, 320, 31 );

  present_data = create_fx_present ( root_image );
  rotozoom_data = create_fx_rotozoom ( &effect_image );

  /* bigscreen syncing delay */
  beer ( root_image, 5 );
  
  crap_mod_start_playing ();

  while (!end_intro)
    {
#ifdef USE_RASTER_TIMING
      if ( _timing )
	{ outb(0,0x3c8); outb(30,0x3c9); outb(30,0x3c9); outb(0,0x3c9); }
#endif
      
      note = crap_mod_get_patpos();
      #define BARS 4
      switch ( crap_mod_get_songpos() )
	{
	case 0:
	  // introductory part
	  end_intro = will_end_soon;
	  fx_present ( root_image, present_data );
	  break;
	case 1:
	  // butcher shop + animals
	  fx_rotozoom ( &effect_image, rotozoom_data, note, 0 );
	  crap_image_rect_fill ( root_image, 0, 0, 200-34, root_image->width, 1 );
	  crap_image_blit ( root_image, 0, 200-33, &logo_image );
	  break;
	case 2:
	  // evil butcher
	  fx_rotozoom ( &effect_image, rotozoom_data, note, 1 );
	  crap_image_rect_fill ( root_image, 0, 0, 200-34, root_image->width, 1 );
	  crap_image_blit ( root_image, 0, 200-33, &logo_image );
	  break;
	case 3:
	  // naked mooning butcher
	  will_end_soon = 1;
	  fx_rotozoom ( &effect_image, rotozoom_data, note, 2 );
	  crap_image_rect_fill ( root_image, 0, 0, 200-34, root_image->width, 1 );
	  crap_image_blit ( root_image, 0, 200-33, &logo_image );
	  crap_mod_set_volume ( max ( 128-note*2, 0 ) );

	  if ( first_time_around )
	    {
	      first_time_around = 0;
	      palvec = crap_video_getcurrentpalette();
	    }
	  else
	    {
	      if ( note > 32 ) 
		crap_video_fadecolors ( 0, 256, palvec, max ( 128-(note-32)*2, 0 ) / 128.0 );
	      if ( note > 64+32 )
		end_intro = 1;
	    }
	  
	  break;
	default:
	  break;
	};
      
#ifdef USE_RASTER_TIMING
      if ( _timing )
	{ outb(0,0x3c8); outb(0,0x3c9); outb(30,0x3c9); outb(0,0x3c9); }
#endif
      crap_mod_update();
#ifdef USE_RASTER_TIMING
      if ( _timing )
	{ outb(0,0x3c8); outb(0,0x3c9); outb(0,0x3c9); outb(0,0x3c9); }
#endif
      
      crap_video_waitretrace();
      crap_video_blit ( root_image );
      
      if ( (crap_video_keypress()) && ( crap_video_getkey() == CRAP_KEY_ESCAPE ) )
	break;
    }

  crap_video_done ();
  crap_mod_done ();

  printf("\n");
  printf("(defcredits :code '(avoozl smoke)\n");
  printf("            :gfx '(smoke)\n");
  printf("            :borrowed-tune '(heretic))\n");
  printf("\n");
  printf("(defemail (('smoke \"smoke@casema.net\")\n");
  printf("           ('avoozl \"jrk@panic.et.tudelft.nl\")\n");
  printf("\n");

  return 0;
}
